/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.http.cypher.integration.TransactionConditions;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.rule.OtherThreadRule;
import org.neo4j.test.server.HTTP;

@ExtendWith(value={OtherThreadExtension.class})
public class TransientErrorIT
extends AbstractRestFunctionalTestBase {
    @Inject
    public OtherThreadRule otherThread;

    @Test
    @Timeout(value=60L)
    public void deadlockShouldRollbackTransaction() throws Exception {
        HTTP.Response failed;
        HTTP.Response initial = HTTP.POST((String)TransientErrorIT.txCommitUri(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'CREATE (n1 {prop : 1}), (n2 {prop : 2})'}]}"));
        Assertions.assertThat((int)initial.status()).isEqualTo(200);
        Assertions.assertThat((Object)initial).satisfies(TransactionConditions.containsNoErrors());
        HTTP.Response firstInTx1 = HTTP.POST((String)TransientErrorIT.txUri(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'MATCH (n {prop : 1}) SET n.prop = 3'}]}"));
        long tx1 = TransientErrorIT.extractTxId(firstInTx1);
        HTTP.Response firstInTx2 = HTTP.POST((String)TransientErrorIT.txUri(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'MATCH (n {prop : 2}) SET n.prop = 4'}]}"));
        long tx2 = TransientErrorIT.extractTxId(firstInTx2);
        Future future = this.otherThread.execute(() -> HTTP.POST((String)TransientErrorIT.txUri(tx1), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'MATCH (n {prop : 2}) SET n.prop = 5'}]}")));
        HTTP.Response secondInTx2 = HTTP.POST((String)TransientErrorIT.txUri(tx2), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'MATCH (n {prop : 1}) SET n.prop = 6'}]}"));
        HTTP.Response secondInTx1 = (HTTP.Response)future.get();
        Assertions.assertThat((int)secondInTx1.status()).isEqualTo(200);
        Assertions.assertThat((int)secondInTx2.status()).isEqualTo(200);
        if (TransientErrorIT.containsError(secondInTx1)) {
            failed = secondInTx1;
        } else if (TransientErrorIT.containsError(secondInTx2)) {
            failed = secondInTx2;
        } else {
            failed = null;
            org.junit.jupiter.api.Assertions.fail((String)"Either tx1 or tx2 is expected to fail");
        }
        Assertions.assertThat((Object)failed).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Transaction.DeadlockDetected}));
        HTTP.Response commit = HTTP.POST((String)failed.stringFromContent("commit"));
        Assertions.assertThat((int)commit.status()).isEqualTo(404);
    }

    @Test
    public void unavailableCsvResourceShouldRollbackTransaction() throws JsonParseException {
        HTTP.Response first = HTTP.POST((String)TransientErrorIT.txUri(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'CREATE ()'}]}"));
        Assertions.assertThat((int)first.status()).isEqualTo(201);
        Assertions.assertThat((Object)first).satisfies(TransactionConditions.containsNoErrors());
        long txId = TransientErrorIT.extractTxId(first);
        HTTP.Response second = HTTP.POST((String)TransientErrorIT.txUri(txId), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'LOAD CSV FROM \\\"http://127.0.0.1/null/\\\" AS line CREATE (a {name:line[0]})'}]}"));
        Assertions.assertThat((int)second.status()).isEqualTo(200);
        Assertions.assertThat((Object)second).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.ExternalResourceFailed}));
        HTTP.Response commit = HTTP.POST((String)second.stringFromContent("commit"));
        Assertions.assertThat((int)commit.status()).isEqualTo(404);
    }

    private static boolean containsError(HTTP.Response response) throws JsonParseException {
        return response.get("errors").iterator().hasNext();
    }
}

