/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.server;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.junit.jupiter.api.parallel.ResourceLocks;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.server.helpers.WebContainerHelper;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.server.WebContainerHolder;

@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLocks(value={@ResourceLock(value="sharedContext"), @ResourceLock(value="java.lang.System.out")})
public class SharedWebContainerTestBase {
    private static TestWebContainer testWebContainer;

    protected static TestWebContainer container() {
        return testWebContainer;
    }

    @BeforeAll
    public static void allocateServer() throws Throwable {
        System.setProperty("org.neo4j.useInsecureCertificateGeneration", "true");
        SuppressOutput.suppressAll().call(() -> {
            WebContainerHolder.setWebContainerBuilderProperty(GraphDatabaseSettings.cypher_hints_error.name(), "true");
            WebContainerHolder.setWebContainerBuilderProperty(BoltConnector.enabled.name(), "true");
            WebContainerHolder.setWebContainerBuilderProperty(BoltConnector.listen_address.name(), "localhost:0");
            WebContainerHolder.setWebContainerBuilderProperty(GraphDatabaseSettings.transaction_timeout.name(), "300s");
            WebContainerHolder.setWebContainerBuilderProperty(ServerSettings.transaction_idle_timeout.name(), "300s");
            WebContainerHolder.setWebContainerBuilderProperty(GraphDatabaseInternalSettings.track_tx_statement_close.name(), "false");
            testWebContainer = WebContainerHolder.allocate();
            WebContainerHelper.cleanTheDatabase(testWebContainer);
            return null;
        });
    }

    @AfterAll
    public static void releaseServer() throws Exception {
        try {
            SuppressOutput.suppressAll().call(() -> {
                WebContainerHolder.release(testWebContainer);
                return null;
            });
        }
        finally {
            testWebContainer = null;
        }
    }
}

