/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@ResourceLock(value="sharedContext")
public abstract class PageCacheTestSupport<T extends PageCache> {
    protected static ExecutorService executor;
    protected long SHORT_TIMEOUT_MILLIS = 30000L;
    protected long SEMI_LONG_TIMEOUT_MILLIS = 120000L;
    protected long LONG_TIMEOUT_MILLIS = 360000L;
    protected int recordSize = 9;
    protected int maxPages = 20;
    protected int pageCachePageSize;
    protected int recordsPerFilePage;
    protected int recordCount;
    protected int filePageSize;
    protected ByteBuffer bufA;
    protected FileSystemAbstraction fs;
    protected JobScheduler jobScheduler;
    protected T pageCache;
    private Fixture<T> fixture;

    @BeforeAll
    public static void startExecutor() {
        executor = Executors.newCachedThreadPool();
    }

    @AfterAll
    public static void stopExecutor() {
        executor.shutdown();
    }

    protected abstract Fixture<T> createFixture();

    @BeforeEach
    public void setUp() throws IOException {
        this.fixture = this.createFixture();
        Thread.interrupted();
        this.fs = this.createFileSystemAbstraction();
        this.jobScheduler = new ThreadPoolJobScheduler();
        this.ensureExists(this.file("a"));
    }

    @AfterEach
    public void tearDown() throws Exception {
        Thread.interrupted();
        if (this.pageCache != null) {
            this.tearDownPageCache(this.pageCache);
        }
        this.jobScheduler.close();
        this.fs.close();
    }

    protected final T createPageCache(PageSwapperFactory swapperFactory, int maxPages, PageCacheTracer tracer) {
        T pageCache = this.fixture.createPageCache(swapperFactory, maxPages, tracer, this.jobScheduler, this.fixture.getBufferFactory());
        this.pageCachePageSize = pageCache.pageSize();
        this.recordsPerFilePage = this.pageCachePageSize / this.recordSize;
        this.recordCount = 5 * maxPages * this.recordsPerFilePage;
        this.filePageSize = this.recordsPerFilePage * this.recordSize;
        this.bufA = ByteBuffers.allocate((int)this.recordSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        return pageCache;
    }

    protected T createPageCache(FileSystemAbstraction fs, int maxPages, PageCacheTracer tracer) {
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory(fs);
        return this.createPageCache((PageSwapperFactory)swapperFactory, maxPages, tracer);
    }

    protected final T getPageCache(FileSystemAbstraction fs, int maxPages, PageCacheTracer tracer) {
        if (this.pageCache != null) {
            this.tearDownPageCache(this.pageCache);
        }
        this.pageCache = this.createPageCache(fs, maxPages, tracer);
        return this.pageCache;
    }

    protected void configureStandardPageCache() {
        this.getPageCache(this.fs, this.maxPages, PageCacheTracer.NULL);
    }

    protected final void tearDownPageCache(T pageCache) {
        this.fixture.tearDownPageCache(pageCache);
    }

    protected final FileSystemAbstraction createFileSystemAbstraction() {
        return this.fixture.getFileSystemAbstraction();
    }

    protected final Path file(String pathname) throws IOException {
        return this.fixture.file(pathname);
    }

    protected void ensureExists(Path file) throws IOException {
        this.fs.mkdirs(file.getParent());
        this.fs.write(file).close();
    }

    protected Path existingFile(String name) throws IOException {
        Path file = this.file(name);
        this.ensureExists(file);
        return file;
    }

    protected void verifyRecordsMatchExpected(PageCursor cursor) throws IOException {
        ByteBuffer expectedPageContents = ByteBuffers.allocate((int)this.filePageSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ByteBuffer actualPageContents = ByteBuffers.allocate((int)this.filePageSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        byte[] record = new byte[this.recordSize];
        long pageId = cursor.getCurrentPageId();
        for (int i = 0; i < this.recordsPerFilePage; ++i) {
            long recordId = pageId * (long)this.recordsPerFilePage + (long)i;
            expectedPageContents.position(this.recordSize * i);
            ByteBuffer slice = expectedPageContents.slice();
            slice.limit(this.recordSize);
            PageCacheTestSupport.generateRecordForId(recordId, slice);
            do {
                cursor.setOffset(this.recordSize * i);
                cursor.getBytes(record);
            } while (cursor.shouldRetry());
            actualPageContents.position(this.recordSize * i);
            actualPageContents.put(record);
        }
        this.assertRecords(pageId, actualPageContents, expectedPageContents);
    }

    protected void verifyRecordsMatchExpected(long pageId, int offset, ByteBuffer actualPageContents) {
        ByteBuffer expectedPageContents = ByteBuffers.allocate((int)this.filePageSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        for (int i = 0; i < this.recordsPerFilePage; ++i) {
            long recordId = pageId * (long)this.recordsPerFilePage + (long)i;
            expectedPageContents.position(this.recordSize * i);
            ByteBuffer slice = expectedPageContents.slice();
            slice.limit(this.recordSize);
            PageCacheTestSupport.generateRecordForId(recordId, slice);
        }
        int len = actualPageContents.limit() - actualPageContents.position();
        byte[] actual = new byte[len];
        byte[] expected = new byte[len];
        actualPageContents.get(actual);
        expectedPageContents.position(offset);
        expectedPageContents.get(expected);
        this.assertRecords(pageId, actual, expected);
    }

    protected void assertRecords(long pageId, ByteBuffer actualPageContents, ByteBuffer expectedPageContents) {
        byte[] actualBytes = actualPageContents.array();
        byte[] expectedBytes = expectedPageContents.array();
        this.assertRecords(pageId, actualBytes, expectedBytes);
    }

    protected void assertRecords(long pageId, byte[] actualBytes, byte[] expectedBytes) {
        int estimatedPageId = this.estimateId(actualBytes);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])actualBytes).as("Page id: " + pageId + " (based on record data, it should have been " + estimatedPageId + ", a difference of " + Math.abs(pageId - (long)estimatedPageId) + ")", new Object[0])).containsExactly(expectedBytes);
    }

    protected int estimateId(byte[] record) {
        return ByteBuffer.wrap(record).getInt() - 1;
    }

    protected void writeRecords(PageCursor cursor) {
        cursor.setOffset(0);
        for (int i = 0; i < this.recordsPerFilePage; ++i) {
            long recordId = cursor.getCurrentPageId() * (long)this.recordsPerFilePage + (long)i;
            PageCacheTestSupport.generateRecordForId(recordId, this.bufA);
            cursor.putBytes(this.bufA.array());
        }
    }

    protected void generateFileWithRecords(Path file, int recordCount, int recordSize) throws IOException {
        try (StoreChannel channel = this.fs.write(file);){
            this.generateFileWithRecords((WritableByteChannel)channel, recordCount, recordSize);
        }
    }

    protected void generateFileWithRecords(WritableByteChannel channel, int recordCount, int recordSize) throws IOException {
        ByteBuffer buf = ByteBuffers.allocate((int)recordSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        for (int i = 0; i < recordCount; ++i) {
            PageCacheTestSupport.generateRecordForId(i, buf);
            int rem = buf.remaining();
            while ((rem -= channel.write(buf)) > 0) {
            }
        }
    }

    protected static void generateRecordForId(long id, ByteBuffer buf) {
        buf.position(0);
        int x = (int)(id + 1L);
        buf.putInt(x);
        while (buf.position() < buf.limit()) {
            buf.put((byte)(++x & 0xFF));
        }
        buf.position(0);
    }

    protected void verifyRecordsInFile(Path file, int recordCount) throws IOException {
        try (StoreChannel channel = this.fs.read(file);){
            this.verifyRecordsInFile((ReadableByteChannel)channel, recordCount);
        }
    }

    protected void verifyRecordsInFile(ReadableByteChannel channel, int recordCount) throws IOException {
        ByteBuffer buf = ByteBuffers.allocate((int)this.recordSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ByteBuffer observation = ByteBuffers.allocate((int)this.recordSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        for (int i = 0; i < recordCount; ++i) {
            PageCacheTestSupport.generateRecordForId(i, buf);
            observation.position(0);
            channel.read(observation);
            this.assertRecords((long)i, observation, buf);
        }
    }

    protected Runnable closePageFile(PagedFile file) {
        return () -> ((PagedFile)file).close();
    }

    public static abstract class Fixture<T extends PageCache> {
        private Supplier<FileSystemAbstraction> fileSystemAbstractionSupplier = EphemeralFileSystemAbstraction::new;
        private Function<String, Path> fileConstructor = x$0 -> Path.of(x$0, new String[0]);
        private IOBufferFactory bufferFactory;

        public abstract T createPageCache(PageSwapperFactory var1, int var2, PageCacheTracer var3, JobScheduler var4, IOBufferFactory var5);

        public abstract void tearDownPageCache(T var1);

        public final FileSystemAbstraction getFileSystemAbstraction() {
            return this.fileSystemAbstractionSupplier.get();
        }

        public IOBufferFactory getBufferFactory() {
            return this.bufferFactory;
        }

        public final Fixture<T> withFileSystemAbstraction(Supplier<FileSystemAbstraction> fileSystemAbstractionSupplier) {
            this.fileSystemAbstractionSupplier = fileSystemAbstractionSupplier;
            return this;
        }

        public final Path file(String pathname) {
            return this.fileConstructor.apply(pathname).toAbsolutePath().normalize();
        }

        public final Fixture<T> withBufferFactory(IOBufferFactory bufferFactory) {
            this.bufferFactory = bufferFactory;
            return this;
        }

        public final Fixture<T> withFileConstructor(Function<String, Path> fileConstructor) {
            this.fileConstructor = fileConstructor;
            return this;
        }
    }
}

