/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.io.pagecache.impl.muninn.LatchMap;
import org.neo4j.test.ThreadTestUtils;
import org.neo4j.util.concurrent.BinaryLatch;

class LatchMapTest {
    LatchMapTest() {
    }

    @ValueSource(ints={128, 1024, 2048})
    @ParameterizedTest
    void takeOrAwaitLatchMustReturnLatchIfAvailable(int size) {
        LatchMap latches = new LatchMap(size);
        LatchMap.Latch latch = latches.takeOrAwaitLatch(0L);
        Assertions.assertThat((Object)latch).isNotNull();
        latch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValueSource(ints={128, 1024, 2048})
    @ParameterizedTest
    void takeOrAwaitLatchMustAwaitExistingLatchAndReturnNull(int size) throws Exception {
        LatchMap latches = new LatchMap(size);
        AtomicReference threadRef = new AtomicReference();
        LatchMap.Latch latch = latches.takeOrAwaitLatch(42L);
        Assertions.assertThat((Object)latch).isNotNull();
        ExecutorService executor = null;
        try {
            Thread th;
            executor = Executors.newSingleThreadExecutor();
            Future<BinaryLatch> future = executor.submit(() -> {
                threadRef.set(Thread.currentThread());
                return latches.takeOrAwaitLatch(42L);
            });
            while ((th = (Thread)threadRef.get()) == null) {
            }
            ThreadTestUtils.awaitThreadState((Thread)th, (long)10000L, (Thread.State)Thread.State.WAITING, (Thread.State[])new Thread.State[0]);
            latch.release();
            Assertions.assertThat((Object)future.get(1L, TimeUnit.SECONDS)).isNull();
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValueSource(ints={128, 1024, 2048})
    @ParameterizedTest
    void takeOrAwaitLatchMustNotLetUnrelatedLatchesConflictTooMuch(int size) throws Exception {
        LatchMap latches = new LatchMap(size);
        LatchMap.Latch latch = latches.takeOrAwaitLatch(42L);
        Assertions.assertThat((Object)latch).isNotNull();
        ExecutorService executor = null;
        try {
            executor = Executors.newSingleThreadExecutor();
            Future<BinaryLatch> future = executor.submit(() -> latches.takeOrAwaitLatch(33L));
            Assertions.assertThat((Object)future.get(30L, TimeUnit.SECONDS)).isNotNull();
            latch.release();
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    @ValueSource(ints={128, 1024, 2048})
    @ParameterizedTest
    void latchMustBeAvailableAfterRelease(int size) {
        LatchMap latches = new LatchMap(size);
        latches.takeOrAwaitLatch(42L).release();
        latches.takeOrAwaitLatch(42L).release();
    }

    @Test
    void shouldFailOnSizeNotPowerOfTwo() {
        Assertions.assertThatThrownBy(() -> new LatchMap(123)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void largerLatchMapShouldAllowMoreLatches() {
        LatchMap latches = new LatchMap(512);
        ArrayList<LatchMap.Latch> latchList = new ArrayList<LatchMap.Latch>();
        for (int i = 0; i < 256; ++i) {
            latchList.add(latches.takeOrAwaitLatch((long)i));
        }
        latchList.forEach(LatchMap.Latch::release);
    }
}

