/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.UnsatisfiedDependencyException;
import org.neo4j.server.configuration.ConfigurableServerModules;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.rest.security.CommunityWebContainerTestBase;
import org.neo4j.test.server.HTTP;

public class NeoWebServerConfigurableModulesIT
extends CommunityWebContainerTestBase {
    @Test
    void webServerShouldNotStartWithoutAnyModule() {
        Assertions.assertThatExceptionOfType(UnsatisfiedDependencyException.class).isThrownBy(() -> CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(ServerSettings.http_enabled_modules.name(), "").build());
    }

    @Test
    void authAndDbmsShouldBeEnabled() throws IOException {
        this.startTestWebContainer(EnumSet.of(ConfigurableServerModules.TRANSACTIONAL_ENDPOINTS), true);
        HTTP.Response response = HTTP.POST((String)this.txCommitURL("system"), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'SHOW DEFAULT DATABASE' } ] }"));
        Assertions.assertThat((int)response.status()).isEqualTo(401);
        response = HTTP.GET((String)this.testWebContainer.getBaseUri().resolve("/").toString());
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((Map)((Map)response.content())).containsKey((Object)"transaction");
    }

    private static Stream<Arguments> disabledModuleAndURIs() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{ConfigurableServerModules.TRANSACTIONAL_ENDPOINTS, baseUir -> List.of(baseUir.resolve("/db/neo4j/tx"), baseUir.resolve("/db/data/transaction")), uri -> HTTP.POST((String)uri.toString())}), Arguments.arguments((Object[])new Object[]{ConfigurableServerModules.BROWSER, baseUir -> List.of(baseUir.resolve("/browser")), uri -> HTTP.GET((String)uri.toString())}), Arguments.arguments((Object[])new Object[]{ConfigurableServerModules.UNMANAGED_EXTENSIONS, baseUir -> List.of(baseUir.resolve("/dummy")), uri -> HTTP.withHeaders((String[])new String[]{"Accept", "text/plain"}).GET(uri.toString())}));
    }

    @ParameterizedTest(name="{0} should be disabled")
    @MethodSource(value={"disabledModuleAndURIs"})
    void moduleShouldBeDisabled(ConfigurableServerModules disabledModule, Function<URI, List<URI>> uriProvider, Function<URI, HTTP.Response> httpCall) throws IOException {
        this.startTestWebContainer(EnumSet.complementOf(EnumSet.of(disabledModule)), false);
        for (URI uri : uriProvider.apply(this.testWebContainer.getBaseUri())) {
            HTTP.Response response = httpCall.apply(uri);
            Assertions.assertThat((int)response.status()).isEqualTo(404);
        }
    }

    private String moduleSettingsToProperty(EnumSet<ConfigurableServerModules> enabledModules) {
        return enabledModules.stream().map(Enum::name).collect(Collectors.joining(","));
    }

    void startTestWebContainer(EnumSet<ConfigurableServerModules> enabledModules, boolean authEnabled) throws IOException {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), Boolean.toString(authEnabled)).withProperty(ServerSettings.http_enabled_modules.name(), this.moduleSettingsToProperty(enabledModules)).withThirdPartyJaxRsPackage("org.dummy.web.service", "/dummy").build();
    }
}

