/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing.recording;

import java.util.Objects;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.recording.Event;
import org.neo4j.io.pagecache.tracing.recording.RecordingTracer;

public class RecordingPageCursorTracer
extends RecordingTracer
implements PageCursorTracer {
    private int pins;
    private int faults;
    private final PageCacheTracer tracer;
    private final String tag;

    public RecordingPageCursorTracer(PageCacheTracer tracer, String tag) {
        super(Pin.class, Fault.class);
        this.tracer = tracer;
        this.tag = tag;
    }

    @SafeVarargs
    public RecordingPageCursorTracer(PageCacheTracer tracer, String tag, Class<? extends Event> ... eventTypesToTrace) {
        super(eventTypesToTrace);
        this.tracer = tracer;
        this.tag = tag;
    }

    public long faults() {
        return this.faults;
    }

    public long pins() {
        return this.pins;
    }

    public long unpins() {
        return 0L;
    }

    public long hits() {
        return 0L;
    }

    public long bytesRead() {
        return 0L;
    }

    public long evictions() {
        return 0L;
    }

    public long evictionExceptions() {
        return 0L;
    }

    public long bytesWritten() {
        return 0L;
    }

    public long flushes() {
        return 0L;
    }

    public long merges() {
        return 0L;
    }

    public double hitRatio() {
        return 0.0;
    }

    public PinEvent beginPin(boolean writeLock, final long filePageId, final PageSwapper swapper) {
        return new PinEvent(){
            private boolean hit = true;

            public void setCachePageId(long cachePageId) {
            }

            public PageFaultEvent beginPageFault(final long filePageId2, int swapperId) {
                this.hit = false;
                return new PageFaultEvent(){

                    public void addBytesRead(long bytes) {
                    }

                    public void done() {
                        RecordingPageCursorTracer.this.pageFaulted(filePageId2, swapper);
                    }

                    public void fail(Throwable throwable) {
                    }

                    public void freeListSize(int freeListSize) {
                    }

                    public EvictionEvent beginEviction(long cachePageId) {
                        return EvictionEvent.NULL;
                    }

                    public void setCachePageId(long cachePageId) {
                    }
                };
            }

            public void hit() {
            }

            public void done() {
                RecordingPageCursorTracer.this.pinned(filePageId, swapper, this.hit);
            }
        };
    }

    public void reportEvents() {
        Objects.requireNonNull(this.tracer);
        this.tracer.pins((long)this.pins);
        this.tracer.faults((long)this.faults);
    }

    public String getTag() {
        return this.tag;
    }

    private void pageFaulted(long filePageId, PageSwapper swapper) {
        ++this.faults;
        this.record(new Fault(swapper, filePageId));
    }

    private void pinned(long filePageId, PageSwapper swapper, boolean hit) {
        ++this.pins;
        this.record(new Pin(swapper, filePageId, hit));
    }

    public static class Pin
    extends Event {
        private final boolean hit;

        private Pin(PageSwapper io, long pageId, boolean hit) {
            super(io, pageId);
            this.hit = hit;
        }

        @Override
        public String toString() {
            return String.format("%s{io=%s, pageId=%s,hit=%s}", this.getClass().getSimpleName(), this.io, this.pageId, this.hit);
        }
    }

    public static class Fault
    extends Event {
        private Fault(PageSwapper io, long pageId) {
            super(io, pageId);
        }
    }
}

