/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.server;

import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.server.WebContainerHolder;

public class ExclusiveWebContainerTestBase {
    @Rule
    public TestDirectory folder = TestDirectory.testDirectory();
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void ensureServerNotRunning() throws Exception {
        System.setProperty("org.neo4j.useInsecureCertificateGeneration", "true");
        SuppressOutput.suppressAll().call(() -> {
            WebContainerHolder.ensureNotRunning();
            return null;
        });
    }

    protected static String txEndpoint() {
        return ExclusiveWebContainerTestBase.txEndpoint("neo4j");
    }

    private static String txEndpoint(String database) {
        return String.format("db/%s/tx", database);
    }

    protected static String txCommitEndpoint() {
        return ExclusiveWebContainerTestBase.txCommitEndpoint("neo4j");
    }

    protected static String txCommitEndpoint(String database) {
        return ExclusiveWebContainerTestBase.txEndpoint(database) + "/commit";
    }
}

