/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.internal.CappedLogger;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class CappedLoggerTest {
    private AssertableLogProvider logProvider;
    private CappedLogger logger;

    private static Stream<Arguments> argumentsProvider() {
        LogMethod debug = new LogMethod(){

            @Override
            public void log(CappedLogger logger, String msg) {
                logger.debug(msg);
            }

            @Override
            public void log(CappedLogger logger, String msg, Throwable cause) {
                logger.debug(msg, cause);
            }
        };
        LogMethod info = new LogMethod(){

            @Override
            public void log(CappedLogger logger, String msg) {
                logger.info(msg, new Object[0]);
            }

            @Override
            public void log(CappedLogger logger, String msg, Throwable cause) {
                logger.info(msg, cause);
            }
        };
        LogMethod warn = new LogMethod(){

            @Override
            public void log(CappedLogger logger, String msg) {
                logger.warn(msg);
            }

            @Override
            public void log(CappedLogger logger, String msg, Throwable cause) {
                logger.warn(msg, cause);
            }
        };
        LogMethod error = new LogMethod(){

            @Override
            public void log(CappedLogger logger, String msg) {
                logger.error(msg);
            }

            @Override
            public void log(CappedLogger logger, String msg, Throwable cause) {
                logger.error(msg, cause);
            }
        };
        return Stream.of(Arguments.of((Object[])new Object[]{debug, "debug"}), Arguments.of((Object[])new Object[]{info, "info"}), Arguments.of((Object[])new Object[]{warn, "warn"}), Arguments.of((Object[])new Object[]{error, "error"}));
    }

    @BeforeEach
    public void setUp() {
        this.logProvider = new AssertableLogProvider();
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustLogExceptions(LogMethod logMethod, String name) {
        this.logger = new CappedLogger(this.logProvider.getLog(CappedLogger.class), 1L, TimeUnit.MILLISECONDS, Clocks.systemClock());
        ArithmeticException exception = new ArithmeticException("EXCEPTION");
        logMethod.log(this.logger, "MESSAGE", exception);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithException("MESSAGE", (Throwable)exception);
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustThrowOnZeroTimeLimit(LogMethod logMethod, String name) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CappedLogger(this.logProvider.getLog(CappedLogger.class), 0L, TimeUnit.MILLISECONDS, Clocks.systemClock()));
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustThrowOnNegativeTimeLimit(LogMethod logMethod, String name) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CappedLogger(this.logProvider.getLog(CappedLogger.class), -1L, TimeUnit.MILLISECONDS, Clocks.systemClock()));
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustNotLogMessagesWithinConfiguredTimeLimit(LogMethod logMethod, String name) {
        FakeClock clock = this.getDefaultFakeClock();
        this.logger = new CappedLogger(this.logProvider.getLog(CappedLogger.class), 1L, TimeUnit.MILLISECONDS, (Clock)clock);
        logMethod.log(this.logger, "### AAA ###");
        logMethod.log(this.logger, "### BBB ###");
        clock.forward(1L, TimeUnit.MILLISECONDS);
        logMethod.log(this.logger, "### CCC ###");
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"### AAA ###"});
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(CappedLogger.class).doesNotContainMessage("### BBB ###");
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"### CCC ###"});
    }

    private FakeClock getDefaultFakeClock() {
        return Clocks.fakeClock((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public static interface LogMethod {
        public void log(CappedLogger var1, String var2);

        public void log(CappedLogger var1, String var2, Throwable var3);
    }
}

