/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.http.cypher.integration.TransactionConditions;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.test.server.HTTP;

public class NeoWebServerIT
extends AbstractRestFunctionalTestBase {
    @Test
    public void shouldErrorForUnknownDatabaseViaTransactionalEndpoint() {
        HTTP.Response response = HTTP.POST((String)NeoWebServerIT.txCommitUri("foo"), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'RETURN 1' } ] }"));
        Assertions.assertThat((int)response.status()).isEqualTo(404);
        Assertions.assertThat((Object)response).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Database.DatabaseNotFound}));
    }

    @Test
    public void shouldBeAbleToRunQueryAgainstSystemDatabaseViaTransactionalEndpoint() {
        HTTP.Response response = HTTP.POST((String)NeoWebServerIT.txCommitUri("system"), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'SHOW DEFAULT DATABASE' } ] }"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((Object)response).satisfies(TransactionConditions.containsNoErrors());
    }

    @Test
    public void shouldRedirectRootToBrowser() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)NeoWebServerIT.container().getBaseUri().toString().contains("browser"));
        HTTP.Response res = HTTP.withHeaders((String[])new String[]{"Accept", "text/html"}).GET(NeoWebServerIT.container().getBaseUri().toString());
        Assertions.assertThat((String)res.header("Location")).contains(new CharSequence[]{"browser"});
    }
}

