/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.rule.TestDirectory;

@Neo4jLayoutExtension
class DatabaseLayoutTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private DatabaseLayout databaseLayout;

    DatabaseLayoutTest() {
    }

    @Test
    void databaseLayoutForAbsoluteFile() {
        Path databaseDir = this.testDirectory.directory("neo4j");
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((Path)databaseDir);
        org.junit.jupiter.api.Assertions.assertEquals((Object)databaseLayout.databaseDirectory(), (Object)databaseDir);
    }

    @Test
    void databaseLayoutResolvesLinks() throws IOException {
        Path symbolicLink;
        Path databaseDir;
        block2: {
            Path basePath = this.testDirectory.homePath();
            databaseDir = this.databaseLayout.databaseDirectory();
            Path linkPath = basePath.resolve("link");
            symbolicLink = null;
            try {
                symbolicLink = Files.createSymbolicLink(linkPath, databaseDir, new FileAttribute[0]);
            }
            catch (FileSystemException e) {
                if (!e.getMessage().contains("privilege")) break block2;
                Assumptions.assumeTrue((boolean)false, (String)("Permission issues creating symbolic links in this environment: " + e));
            }
        }
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((Path)symbolicLink);
        org.junit.jupiter.api.Assertions.assertEquals((Object)databaseLayout.databaseDirectory(), (Object)databaseDir);
    }

    @Test
    void databaseLayoutUseCanonicalRepresentation() {
        Path dbDir = this.testDirectory.directory("notCanonical");
        Path notCanonicalPath = dbDir.resolve("../anotherdatabase");
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((Path)notCanonicalPath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.testDirectory.directory("anotherdatabase"), (Object)databaseLayout.databaseDirectory());
    }

    @Test
    void databaseLayoutForName() {
        String databaseName = "testdatabase";
        Neo4jLayout storeLayout = this.neo4jLayout;
        DatabaseLayout testDatabase = storeLayout.databaseLayout(databaseName);
        org.junit.jupiter.api.Assertions.assertEquals((Object)storeLayout.databasesDirectory().resolve(databaseName), (Object)testDatabase.databaseDirectory());
    }

    @Test
    void databaseLayoutForFolderAndName() {
        String database = "database";
        DatabaseLayout databaseLayout = this.neo4jLayout.databaseLayout(database);
        org.junit.jupiter.api.Assertions.assertEquals((Object)database, (Object)databaseLayout.databaseDirectory().getFileName().toString());
    }

    @Test
    void databaseLayoutProvideCorrectDatabaseName() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neo4j", (Object)this.databaseLayout.getDatabaseName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"testdb", (Object)this.neo4jLayout.databaseLayout("testdb").getDatabaseName());
    }

    @Test
    void storeFilesHaveExpectedNames() {
        DatabaseLayout layout = this.databaseLayout;
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore", (Object)layout.metadataStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.counts.db", (Object)layout.countStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.labelscanstore.db", (Object)layout.labelScanStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.labeltokenstore.db", (Object)layout.labelTokenStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.labeltokenstore.db.names", (Object)layout.labelTokenNamesStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.nodestore.db", (Object)layout.nodeStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.nodestore.db.labels", (Object)layout.nodeLabelStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db", (Object)layout.propertyStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.arrays", (Object)layout.propertyArrayStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.index", (Object)layout.propertyKeyTokenStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.index.keys", (Object)layout.propertyKeyTokenNamesStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.strings", (Object)layout.propertyStringStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshipgroupstore.db", (Object)layout.relationshipGroupStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshipstore.db", (Object)layout.relationshipStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshiptypestore.db", (Object)layout.relationshipTypeTokenStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshiptypestore.db.names", (Object)layout.relationshipTypeTokenNamesStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.schemastore.db", (Object)layout.schemaStore().getFileName().toString());
    }

    @Test
    void idFilesHaveExpectedNames() {
        DatabaseLayout layout = this.databaseLayout;
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.labeltokenstore.db.id", (Object)layout.idLabelTokenStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.labeltokenstore.db.names.id", (Object)layout.idLabelTokenNamesStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.nodestore.db.id", (Object)layout.idNodeStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.nodestore.db.labels.id", (Object)layout.idNodeLabelStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.arrays.id", (Object)layout.idPropertyArrayStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.id", (Object)layout.idPropertyStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.index.id", (Object)layout.idPropertyKeyTokenStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.index.keys.id", (Object)layout.idPropertyKeyTokenNamesStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.strings.id", (Object)layout.idPropertyStringStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshipgroupstore.db.id", (Object)layout.idRelationshipGroupStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshipstore.db.id", (Object)layout.idRelationshipStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshiptypestore.db.id", (Object)layout.idRelationshipTypeTokenStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshiptypestore.db.names.id", (Object)layout.idRelationshipTypeTokenNamesStore().getFileName().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.schemastore.db.id", (Object)layout.idSchemaStore().getFileName().toString());
    }

    @Test
    void allStoreFiles() {
        DatabaseLayout layout = this.databaseLayout;
        Set files = layout.storeFiles().stream().map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.counts.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.labelscanstore.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.labeltokenstore.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.labeltokenstore.db.names"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.nodestore.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.nodestore.db.labels"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.propertystore.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.propertystore.db.arrays"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.propertystore.db.index"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.propertystore.db.index.keys"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.propertystore.db.strings"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.relationshipgroupstore.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.relationshipstore.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.relationshiptypestore.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.relationshiptypestore.db.names"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.schemastore.db"});
    }

    @Test
    void allFilesContainsStoreFiles() {
        DatabaseFile nodeStore = DatabaseFile.NODE_STORE;
        List allNodeStoreFile = this.databaseLayout.allFiles(nodeStore).collect(Collectors.toList());
        Path nodeStoreStoreFile = this.databaseLayout.file(nodeStore);
        Assertions.assertThat(allNodeStoreFile).contains((Object[])new Path[]{nodeStoreStoreFile});
    }

    @Test
    void allFilesContainsIdFileIfPresent() {
        DatabaseFile nodeStore = DatabaseFile.NODE_STORE;
        List allNodeStoreFile = this.databaseLayout.allFiles(nodeStore).collect(Collectors.toList());
        Path nodeStoreIdFile = (Path)this.databaseLayout.idFile(nodeStore).get();
        Assertions.assertThat(allNodeStoreFile).contains((Object[])new Path[]{nodeStoreIdFile});
    }

    @Test
    void lookupFileByDatabaseFile() {
        DatabaseFile[] databaseFiles;
        DatabaseLayout layout = this.databaseLayout;
        for (DatabaseFile databaseFile : databaseFiles = DatabaseFile.values()) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)layout.file(databaseFile));
        }
        Path metadata = layout.file(DatabaseFile.METADATA_STORE);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore", (Object)metadata.getFileName().toString());
    }

    @Test
    void lookupIdFileByDatabaseFile() {
        DatabaseFile[] databaseFiles;
        DatabaseLayout layout = this.databaseLayout;
        for (DatabaseFile databaseFile : databaseFiles = DatabaseFile.values()) {
            Optional idFile = layout.idFile(databaseFile);
            org.junit.jupiter.api.Assertions.assertEquals((Object)databaseFile.hasIdFile(), (Object)idFile.isPresent());
        }
    }
}

