/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;

class SwapperSetTest {
    private SwapperSet set;

    SwapperSetTest() {
    }

    @BeforeEach
    void setUp() {
        this.set = new SwapperSet();
    }

    @Test
    void mustReturnAllocationWithSwapper() {
        DummyPageSwapper a = new DummyPageSwapper("a", 42);
        DummyPageSwapper b = new DummyPageSwapper("b", 43);
        int idA = this.set.allocate((PageSwapper)a);
        int idB = this.set.allocate((PageSwapper)b);
        SwapperSet.SwapperMapping allocA = this.set.getAllocation(idA);
        SwapperSet.SwapperMapping allocB = this.set.getAllocation(idB);
        Assertions.assertThat((Object)allocA.swapper).isEqualTo((Object)a);
        Assertions.assertThat((Object)allocB.swapper).isEqualTo((Object)b);
    }

    @Test
    void accessingFreedAllocationMustReturnNull() {
        int id = this.set.allocate((PageSwapper)new DummyPageSwapper("a", 42));
        this.set.free(id);
        org.junit.jupiter.api.Assertions.assertNull((Object)this.set.getAllocation(id));
    }

    @Test
    void doubleFreeMustThrow() {
        int id = this.set.allocate((PageSwapper)new DummyPageSwapper("a", 42));
        this.set.free(id);
        IllegalStateException exception = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.set.free(id));
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"double free"});
    }

    @Test
    void freedIdsMustNotBeReusedBeforeVacuum() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        IntHashSet ids = new IntHashSet(10000);
        for (int i = 0; i < 10000; ++i) {
            this.allocateFreeAndAssertNotReused(swapper, (MutableIntSet)ids, i);
        }
    }

    private void allocateFreeAndAssertNotReused(PageSwapper swapper, MutableIntSet ids, int i) {
        int id = this.set.allocate(swapper);
        this.set.free(id);
        if (!ids.add(id)) {
            org.junit.jupiter.api.Assertions.fail((String)("Expected ids.add( id ) to return true for id " + id + " in iteration " + i + " but it instead returned false"));
        }
    }

    @Test
    void freedAllocationsMustBecomeAvailableAfterVacuum() {
        IntHashSet allocated = new IntHashSet();
        IntHashSet freed = new IntHashSet();
        IntHashSet vacuumed = new IntHashSet();
        IntHashSet reused = new IntHashSet();
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        this.allocateAndAddTenThousand((MutableIntSet)allocated, swapper);
        allocated.forEach(arg_0 -> this.lambda$freedAllocationsMustBecomeAvailableAfterVacuum$f53d8ac5$1((MutableIntSet)freed, arg_0));
        this.set.vacuum(arg_0 -> ((MutableIntSet)vacuumed).addAll(arg_0));
        this.allocateAndAddTenThousand((MutableIntSet)reused, swapper);
        Assertions.assertThat((Object)allocated).isEqualTo((Object)freed);
        Assertions.assertThat((Object)allocated).isEqualTo((Object)vacuumed);
        Assertions.assertThat((Object)allocated).isEqualTo((Object)reused);
    }

    private void allocateAndAddTenThousand(MutableIntSet allocated, PageSwapper swapper) {
        for (int i = 0; i < 10000; ++i) {
            this.allocateAndAdd(allocated, swapper);
        }
    }

    private void allocateAndAdd(MutableIntSet allocated, PageSwapper swapper) {
        int id = this.set.allocate(swapper);
        allocated.add(id);
    }

    @Test
    void vacuumMustNotDustOffAnyIdsWhenNoneHaveBeenFreed() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        for (int i = 0; i < 100; ++i) {
            this.set.allocate((PageSwapper)swapper);
        }
        IntHashSet vacuumedIds = new IntHashSet();
        this.set.vacuum(arg_0 -> ((MutableIntSet)vacuumedIds).addAll(arg_0));
        if (!vacuumedIds.isEmpty()) {
            throw new AssertionError((Object)("Vacuum found id " + (MutableIntSet)vacuumedIds + " when it should have found nothing"));
        }
    }

    @Test
    void mustNotUseZeroAsSwapperId() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        for (int i = 0; i < 10000; ++i) {
            Assertions.assertThat((int)this.set.allocate((PageSwapper)swapper)).isNotZero();
        }
    }

    @Test
    void gettingAllocationZeroMustThrow() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.set.getAllocation(0));
    }

    @Test
    void freeOfIdZeroMustThrow() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.set.free(0));
    }

    @Test
    void mustKeepTrackOfAvailableSwapperIds() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        int initial = 0x1FFFFE;
        Assertions.assertThat((int)this.set.countAvailableIds()).isEqualTo(initial);
        int id = this.set.allocate((PageSwapper)swapper);
        Assertions.assertThat((int)this.set.countAvailableIds()).isEqualTo(initial - 1);
        this.set.free(id);
        Assertions.assertThat((int)this.set.countAvailableIds()).isEqualTo(initial - 1);
        this.set.vacuum(x -> {});
        Assertions.assertThat((int)this.set.countAvailableIds()).isEqualTo(initial);
    }

    private /* synthetic */ void lambda$freedAllocationsMustBecomeAvailableAfterVacuum$f53d8ac5$1(MutableIntSet freed, int id) {
        this.set.free(id);
        freed.add(id);
    }
}

