/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.server.helpers.WebContainerHelper;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;
import org.neo4j.test.server.HTTP;

public class ReadOnlyIT
extends ExclusiveWebContainerTestBase {
    @Rule
    public TestDirectory dir = TestDirectory.testDirectory();
    private TestWebContainer readOnlyContainer;
    private HTTP.Builder http;

    @Before
    public void setup() throws Exception {
        WebContainerHelper.cleanTheDatabase(this.readOnlyContainer);
        this.readOnlyContainer = WebContainerHelper.createReadOnlyContainer(this.dir.homePath());
        this.http = HTTP.withBaseUri((URI)this.readOnlyContainer.getBaseUri());
    }

    @After
    public void teardown() {
        if (this.readOnlyContainer != null) {
            this.readOnlyContainer.shutdown();
        }
    }

    @Test
    public void shouldReturnReadOnlyStatusWhenCreatingNodes() throws Exception {
        HTTP.Response response = this.http.POST(ReadOnlyIT.txEndpoint(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (node)' } ] }"));
        JsonNode error = response.get("errors").get(0);
        String code = error.get("code").asText();
        String message = error.get("message").asText();
        Assert.assertEquals((Object)"Neo.ClientError.General.ForbiddenOnReadOnlyDatabase", (Object)code);
        Assertions.assertThat((String)message).contains(new CharSequence[]{"This is a read only Neo4j instance"});
    }

    @Test
    public void shouldReturnReadOnlyStatusWhenCreatingNodesWhichTransitivelyCreateTokens() throws Exception {
        HTTP.Response response = this.http.POST(ReadOnlyIT.txEndpoint(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (node:Node)' } ] }"));
        JsonNode error = response.get("errors").get(0);
        String code = error.get("code").asText();
        String message = error.get("message").asText();
        Assert.assertEquals((Object)"Neo.ClientError.General.ForbiddenOnReadOnlyDatabase", (Object)code);
        Assertions.assertThat((String)message).contains(new CharSequence[]{"This is a read only Neo4j instance"});
    }
}

