/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;

public class ConfigureBaseUriIT
extends AbstractRestFunctionalTestBase {
    private static FunctionalTestHelper functionalTestHelper;
    private static HttpClient httpClient;

    @BeforeAll
    public static void setupServer() {
        functionalTestHelper = new FunctionalTestHelper(ConfigureBaseUriIT.container());
        httpClient = HttpClient.newHttpClient();
    }

    @Test
    public void shouldForwardHttpAndHost() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().header("Accept", "application/json").header("X-Forwarded-Host", "foobar.com").header("X-Forwarded-Proto", "http").build();
        HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
        ConfigureBaseUriIT.verifyContentLength(response);
        String responseBodyString = new String(response.body());
        Assertions.assertThat((String)responseBodyString).contains(new CharSequence[]{"http://foobar.com"});
        Assertions.assertThat((String)responseBodyString).doesNotContain(new CharSequence[]{"http://localhost"});
    }

    @Test
    public void shouldForwardHttpsAndHost() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().header("Accept", "application/json").header("X-Forwarded-Host", "foobar.com").header("X-Forwarded-Proto", "https").build();
        HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
        ConfigureBaseUriIT.verifyContentLength(response);
        String responseBodyString = new String(response.body());
        Assertions.assertThat((String)responseBodyString).contains(new CharSequence[]{"https://foobar.com"});
        Assertions.assertThat((String)responseBodyString).doesNotContain(new CharSequence[]{"https://localhost"});
    }

    @Test
    public void shouldForwardHttpAndHostOnDifferentPort() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().header("Accept", "application/json").header("X-Forwarded-Host", "foobar.com:9999").header("X-Forwarded-Proto", "http").build();
        HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
        ConfigureBaseUriIT.verifyContentLength(response);
        String responseBodyString = new String(response.body());
        Assertions.assertThat((String)responseBodyString).contains(new CharSequence[]{"http://foobar.com:9999"});
        Assertions.assertThat((String)responseBodyString).doesNotContain(new CharSequence[]{"http://localhost"});
    }

    @Test
    public void shouldForwardHttpAndFirstHost() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().header("Accept", "application/json").header("X-Forwarded-Host", "foobar.com, bazbar.com").header("X-Forwarded-Proto", "http").build();
        HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
        ConfigureBaseUriIT.verifyContentLength(response);
        String responseBodyString = new String(response.body());
        Assertions.assertThat((String)responseBodyString).contains(new CharSequence[]{"http://foobar.com"});
        Assertions.assertThat((String)responseBodyString).doesNotContain(new CharSequence[]{"http://localhost"});
    }

    @Test
    public void shouldForwardHttpsAndHostOnDifferentPort() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().header("Accept", "application/json").header("X-Forwarded-Host", "foobar.com:9999").header("X-Forwarded-Proto", "https").build();
        HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
        ConfigureBaseUriIT.verifyContentLength(response);
        String responseBodyString = new String(response.body());
        Assertions.assertThat((String)responseBodyString).contains(new CharSequence[]{"https://foobar.com:9999"});
        Assertions.assertThat((String)responseBodyString).doesNotContain(new CharSequence[]{"https://localhost"});
    }

    @Test
    public void shouldUseRequestUriWhenNoXForwardHeadersPresent() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().header("Accept", "application/json").build();
        HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
        ConfigureBaseUriIT.verifyContentLength(response);
        String responseBodyString = new String(response.body());
        Assertions.assertThat((String)responseBodyString).contains(new CharSequence[]{"http://localhost"});
        Assertions.assertThat((String)responseBodyString).doesNotContain(new CharSequence[]{"https://foobar.com"});
        Assertions.assertThat((String)responseBodyString).doesNotContain(new CharSequence[]{":0"});
    }

    private static void verifyContentLength(HttpResponse<byte[]> response) {
        Optional<String> contentLengthValue = response.headers().firstValue("CONTENT-LENGTH");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)contentLengthValue.isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((int)Integer.parseInt(contentLengthValue.get()), (int)response.body().length);
    }
}

