/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.http.cypher.format.output.json.StreamingJsonFormat;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class StreamingJsonFormatTest {
    private OutputFormat json;
    private ByteArrayOutputStream stream;

    StreamingJsonFormatTest() {
    }

    @BeforeEach
    void createOutputFormat() throws Exception {
        this.stream = new ByteArrayOutputStream();
        this.json = new OutputFormat((RepresentationFormat)new StreamingJsonFormat().writeTo((OutputStream)this.stream).usePrettyPrinter(), new URI("http://localhost/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void canFormatNode() {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction transaction = db.beginTx();){
            Node n = transaction.createNode();
            this.json.assemble((Representation)new NodeRepresentation(n));
        }
        finally {
            managementService.shutdown();
        }
        Assertions.assertTrue((boolean)this.stream.toString().contains("\"self\" : \"http://localhost/node/0\","));
    }

    @Test
    void canFormatString() {
        this.json.assemble((Representation)ValueRepresentation.string((String)"expected value"));
        Assertions.assertEquals((Object)"\"expected value\"", (Object)this.stream.toString());
    }

    @Test
    void canFormatListOfStrings() {
        this.json.assemble((Representation)ListRepresentation.strings((String[])new String[]{"hello", "world"}));
        String expectedString = JsonHelper.createJsonFrom(Arrays.asList("hello", "world"));
        Assertions.assertEquals((Object)expectedString, (Object)this.stream.toString());
    }

    @Test
    void canFormatInteger() {
        this.json.assemble((Representation)ValueRepresentation.number((int)10));
        Assertions.assertEquals((Object)"10", (Object)this.stream.toString());
    }

    @Test
    void canFormatEmptyObject() {
        this.json.assemble((Representation)new MappingRepresentation("empty"){

            protected void serialize(MappingSerializer serializer) {
            }
        });
        Assertions.assertEquals((Object)JsonHelper.createJsonFrom(Collections.emptyMap()), (Object)this.stream.toString());
    }

    @Test
    void canFormatObjectWithStringField() {
        this.json.assemble((Representation)new MappingRepresentation("string"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putString("key", "expected string");
            }
        });
        Assertions.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("key", "expected string")), (Object)this.stream.toString());
    }

    @Test
    void canFormatObjectWithUriField() {
        this.json.assemble((Representation)new MappingRepresentation("uri"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putRelativeUri("URL", "subpath");
            }
        });
        Assertions.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("URL", "http://localhost/subpath")), (Object)this.stream.toString());
    }

    @Test
    void canFormatObjectWithNestedObject() {
        this.json.assemble((Representation)new MappingRepresentation("nesting"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putMapping("nested", new MappingRepresentation("data"){

                    protected void serialize(MappingSerializer nested) {
                        nested.putString("data", "expected data");
                    }
                });
            }
        });
        Assertions.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("nested", Collections.singletonMap("data", "expected data"))), (Object)this.stream.toString());
    }
}

