/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.server.AbstractNeoWebServer;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.server.helpers.WebContainerHelper;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;

public class NeoWebServerStartupLoggingIT
extends ExclusiveWebContainerTestBase {
    private static ByteArrayOutputStream out;
    private static TestWebContainer webContainer;

    @BeforeClass
    public static void setupServer() throws Exception {
        out = new ByteArrayOutputStream();
        webContainer = WebContainerHelper.createNonPersistentContainer((LogProvider)new Log4jLogProvider((OutputStream)out));
    }

    @AfterClass
    public static void stopServer() {
        webContainer.shutdown();
    }

    @Test
    public void shouldLogStartup() throws Exception {
        String logContent = out.toString();
        Assertions.assertThat((int)logContent.length()).isGreaterThan(0);
        Assertions.assertThat((String)logContent).contains(new CharSequence[]{AbstractNeoWebServer.NEO4J_IS_STARTING_MESSAGE});
        HttpRequest request = HttpRequest.newBuilder(webContainer.getBaseUri()).GET().build();
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build();
        HttpResponse<Void> response = client.send(request, HttpResponse.BodyHandlers.discarding());
        Assertions.assertThat((int)response.statusCode()).isGreaterThan(199);
    }
}

