/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.http.cypher.integration.TransactionConditions;
import org.neo4j.server.rest.ParameterizedTransactionEndpointsTestBase;
import org.neo4j.test.server.HTTP;

public class TransactionErrorIT
extends ParameterizedTransactionEndpointsTestBase {
    @ParameterizedTest
    @MethodSource(value={"argumentsProvider"})
    public void begin__commit_with_invalid_cypher(String txUri) throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response response = this.POST(txUri, HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        String commitResource = response.stringFromContent("commit");
        response = this.POST(commitResource, HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE ;;' } ] }"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((Object)response).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.SyntaxError}));
        Assertions.assertThat((Object)response).satisfies(TransactionConditions.containsNoStackTraces());
        Assertions.assertThat((long)this.countNodes()).isEqualTo(nodesInDatabaseBeforeTransaction);
    }

    @ParameterizedTest
    @MethodSource(value={"argumentsProvider"})
    public void begin__commit_with_malformed_json(String txUri) throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.POST(txUri, HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response response = this.POST(commitResource, HTTP.RawPayload.rawPayload((String)"[{asd,::}]"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((Object)response).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Request.InvalidFormat}));
        Assertions.assertThat((long)this.countNodes()).isEqualTo(nodesInDatabaseBeforeTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"argumentsProvider"})
    public void begin_and_execute_periodic_commit_that_fails(String txUri) throws Exception {
        Path file = Files.createTempFile("begin_and_execute_periodic_commit_that_fails", ".csv", new FileAttribute[0]).toAbsolutePath();
        try {
            try (PrintStream out = new PrintStream(Files.newOutputStream(file, new OpenOption[0]));){
                out.println("1");
                out.println("2");
                out.println("0");
                out.println("3");
            }
            String url = file.toUri().toURL().toString().replace("\\", "\\\\");
            String query = "USING PERIODIC COMMIT 1 LOAD CSV FROM \\\"" + url + "\\\" AS line CREATE ({name: 1/toInteger(line[0])});";
            HTTP.RawPayload payload = HTTP.RawPayload.quotedJson((String)("{ 'statements': [ { 'statement': '" + query + "' } ] }"));
            HTTP.Response response = this.POST(txUri + "/commit", payload);
            Assertions.assertThat((int)response.status()).isEqualTo(200);
            Assertions.assertThat((Object)response).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.ArithmeticError}));
            JsonNode message = response.get("errors").get(0).get("message");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)message.toString().contains("on line 3."), (String)"Expected LOAD CSV line number information");
        }
        finally {
            Files.delete(file);
        }
    }

    private long countNodes() {
        return TransactionConditions.countNodes((GraphDatabaseService)this.graphdb());
    }
}

