/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.randomharness;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.StubPageCursor;
import org.neo4j.io.pagecache.randomharness.Record;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public abstract class RecordFormat {
    public abstract int getRecordSize();

    public abstract Record createRecord(Path var1, int var2, int var3, int var4);

    public abstract Record readRecord(PageCursor var1) throws IOException;

    public abstract Record zeroRecord();

    public abstract void write(Record var1, PageCursor var2);

    public final void writeRecord(Record record, StoreChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate((int)this.getRecordSize(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        StubPageCursor cursor = new StubPageCursor(0L, buffer);
        this.write(record, (PageCursor)cursor);
        channel.writeAll(buffer);
    }

    public final void fillWithRecords(PageCursor cursor) {
        cursor.setOffset(0);
        int recordsPerPage = cursor.getCurrentPageSize() / this.getRecordSize();
        for (int i = 0; i < recordsPerPage; ++i) {
            this.writeRecordToPage(cursor, cursor.getCurrentPageId(), recordsPerPage);
        }
    }

    private void writeRecordToPage(PageCursor cursor, long pageId, int recordsPerPage) {
        int pageRecordId = cursor.getOffset() / this.getRecordSize();
        int recordId = (int)(pageId * (long)recordsPerPage + (long)pageRecordId);
        Record record = this.createRecord(cursor.getCurrentFile(), recordId, (int)pageId, cursor.getOffset());
        this.write(record, cursor);
    }

    public final void assertRecordsWrittenCorrectly(PageCursor cursor) throws IOException {
        int currentPageSize = cursor.getCurrentPageSize();
        int recordSize = this.getRecordSize();
        int recordsPerPage = currentPageSize / recordSize;
        for (int pageRecordId = 0; pageRecordId < recordsPerPage; ++pageRecordId) {
            long currentPageId = cursor.getCurrentPageId();
            int recordId = (int)(currentPageId * (long)recordsPerPage + (long)pageRecordId);
            Record expectedRecord = this.createRecord(cursor.getCurrentFile(), recordId, (int)currentPageId, cursor.getOffset());
            Record actualRecord = this.readRecord(cursor);
            try {
                Assertions.assertThat((Object)actualRecord).isIn(new Object[]{expectedRecord, this.zeroRecord()});
                continue;
            }
            catch (Throwable t) {
                throw new RuntimeException(this.dumpPageContent(cursor), t);
            }
        }
    }

    protected String dumpPageContent(PageCursor cursor) {
        int initialOffset = cursor.getOffset();
        byte[] bytes = new byte[cursor.getCurrentPageSize()];
        cursor.setOffset(0);
        cursor.getBytes(bytes);
        cursor.setOffset(initialOffset);
        return "Current page: " + cursor.getCurrentPageId() + ", pageSize: " + cursor.getCurrentPageSize() + " Offset: " + initialOffset + ", data: " + Arrays.toString(bytes);
    }

    public final void assertRecordsWrittenCorrectly(Path file, StoreChannel channel) throws IOException {
        int recordSize = this.getRecordSize();
        long recordsInFile = channel.size() / (long)recordSize;
        ByteBuffer buffer = ByteBuffers.allocate((int)recordSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        StubPageCursor cursor = new StubPageCursor(0L, buffer);
        int i = 0;
        while ((long)i < recordsInFile) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)channel.read(buffer)).as("reading record id " + i, new Object[0])).isEqualTo(recordSize);
            buffer.flip();
            Record expectedRecord = this.createRecord(file, i, (int)(channel.position() / 8192L), 0);
            cursor.setOffset(0);
            Record actualRecord = this.readRecord((PageCursor)cursor);
            buffer.clear();
            try {
                Assertions.assertThat((Object)actualRecord).isIn(new Object[]{expectedRecord, this.zeroRecord()});
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            ++i;
        }
    }
}

