/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs.watcher;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.WatchKey;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.io.fs.watcher.DatabaseLayoutWatcher;
import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.io.fs.watcher.FileWatchEventListenerFactory;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.fs.watcher.resource.WatchedResource;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.rule.TestDirectory;

@Neo4jLayoutExtension
class DatabaseLayoutWatcherTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DatabaseLayout databaseLayout;
    private DatabaseLayoutWatcher watcher;
    private FileWatcher fileWatcher;
    private FileWatchEventListener eventListener;

    DatabaseLayoutWatcherTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.fileWatcher = (FileWatcher)Mockito.mock(FileWatcher.class);
        Mockito.when((Object)this.fileWatcher.watch((Path)ArgumentMatchers.any())).then(call -> new CountingWatchedResource((Path)call.getArgument(0)));
        this.eventListener = new FileWatchEventListener(){};
        FileWatchEventListenerFactory listenerFactory = set -> this.eventListener;
        this.watcher = new DatabaseLayoutWatcher(this.fileWatcher, this.databaseLayout, listenerFactory);
    }

    @Test
    void watchDatabaseDirectoryOnStart() throws Throwable {
        Mockito.verifyNoInteractions((Object[])new Object[]{this.fileWatcher});
        this.watcher.start();
        ((FileWatcher)Mockito.verify((Object)this.fileWatcher)).watch(this.databaseLayout.databaseDirectory());
        ((FileWatcher)Mockito.verify((Object)this.fileWatcher)).watch(this.testDirectory.homePath());
        ((FileWatcher)Mockito.verify((Object)this.fileWatcher)).addFileWatchEventListener(this.eventListener);
    }

    @Test
    void stopWatchingDatabaseDirectoriesOnStop() throws Throwable {
        Mockito.verifyNoInteractions((Object[])new Object[]{this.fileWatcher});
        this.watcher.start();
        this.watcher.stop();
        ((FileWatcher)Mockito.verify((Object)this.fileWatcher)).removeFileWatchEventListener(this.eventListener);
        Assertions.assertEquals((long)5L, (long)CountingWatchedResource.COUNTER.get());
    }

    private static class CountingWatchedResource
    implements WatchedResource {
        private static final AtomicLong COUNTER = new AtomicLong();
        private final Path file;

        CountingWatchedResource(Path path) {
            this.file = path;
        }

        public Path getWatchedFile() {
            return this.file;
        }

        public WatchKey getWatchKey() {
            return null;
        }

        public void close() {
            COUNTER.incrementAndGet();
        }
    }
}

