/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.randomharness;

import org.neo4j.io.pagecache.randomharness.Command;

abstract class Action {
    private final Command command;
    private final String format;
    private final Object[] parameters;
    private final Action innerAction;

    protected Action(Command command, String format, Object ... parameters) {
        this(command, null, format, parameters);
    }

    protected Action(Command command, Action innerAction, String format, Object ... parameters) {
        this.command = command;
        this.format = format;
        this.parameters = parameters;
        this.innerAction = innerAction;
    }

    abstract void perform() throws Exception;

    protected void performInnerAction() throws Exception {
        if (this.innerAction != null) {
            this.innerAction.perform();
        }
    }

    public String toString() {
        if (this.innerAction == null) {
            return String.format(this.command + this.format, this.parameters);
        }
        return String.format(this.command + this.format + ", and then " + this.innerAction, this.parameters);
    }
}

