/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.upgrade;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.store.StoreAssertions;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.recordstorage.RecordStorageEngineFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_4;
import org.neo4j.kernel.impl.storemigration.IdGeneratorMigrator;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.kernel.impl.storemigration.LogsUpgrader;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.RecordStorageMigrator;
import org.neo4j.kernel.impl.storemigration.RecordStoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Monitors;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.migration.MigrationProgressMonitor;
import org.neo4j.storageengine.migration.SchemaIndexMigrator;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@RunWith(value=Parameterized.class)
public class StoreUpgraderInterruptionTestIT {
    private static final Config CONFIG = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (Object)"8m");
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final BatchImporterFactory batchImporterFactory = BatchImporterFactory.withHighestPriority();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);
    @Parameterized.Parameter
    public String version;
    private final FileSystemAbstraction fs = this.fileSystemRule.get();
    private JobScheduler jobScheduler;
    private Neo4jLayout neo4jLayout;
    private DatabaseLayout workingDatabaseLayout;
    private Path prepareDirectory;
    private LegacyTransactionLogsLocator legacyTransactionLogsLocator;
    private PageCache pageCache;
    private RecordFormats baselineFormat;
    private RecordFormats successorFormat;

    @Parameterized.Parameters(name="{0}")
    public static Collection<String> versions() {
        return Collections.singletonList(StandardV3_4.STORE_VERSION);
    }

    @Before
    public void setUpLabelScanStore() {
        this.jobScheduler = new ThreadPoolJobScheduler();
        this.neo4jLayout = Neo4jLayout.of((Path)this.directory.homePath());
        this.workingDatabaseLayout = this.neo4jLayout.databaseLayout("neo4j");
        this.prepareDirectory = this.directory.directory("prepare");
        this.legacyTransactionLogsLocator = new LegacyTransactionLogsLocator(Config.defaults(), this.workingDatabaseLayout);
        this.pageCache = this.pageCacheRule.getPageCache(this.fs);
        this.baselineFormat = RecordFormatSelector.selectForVersion((String)this.version);
        this.successorFormat = RecordFormatSelector.findLatestFormatInFamily((RecordFormats)this.baselineFormat).orElse(this.baselineFormat);
    }

    @After
    public void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    @Test
    public void shouldSucceedWithUpgradeAfterPreviousAttemptDiedDuringMigration() throws IOException, ConsistencyCheckIncompleteException {
        MigrationTestUtils.prepareSampleLegacyDatabase((String)this.version, (FileSystemAbstraction)this.fs, (Path)this.workingDatabaseLayout.databaseDirectory(), (Path)this.prepareDirectory);
        RecordStoreVersionCheck versionCheck = new RecordStoreVersionCheck(this.fs, this.pageCache, this.workingDatabaseLayout, (LogProvider)NullLogProvider.getInstance(), Config.defaults(), PageCacheTracer.NULL);
        MigrationProgressMonitor progressMonitor = MigrationProgressMonitor.SILENT;
        NullLogService logService = NullLogService.getInstance();
        RecordStorageMigrator failingStoreMigrator = new RecordStorageMigrator(this.fs, this.pageCache, CONFIG, (LogService)logService, this.jobScheduler, PageCacheTracer.NULL, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE){

            public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progressReporter, String versionToMigrateFrom, String versionToMigrateTo, IndexImporterFactory indexImporterFactory) throws IOException, KernelException {
                super.migrate(directoryLayout, migrationLayout, progressReporter, versionToMigrateFrom, versionToMigrateTo, indexImporterFactory);
                throw new RuntimeException("This upgrade is failing");
            }
        };
        try {
            this.newUpgrader((StoreVersionCheck)versionCheck, progressMonitor, new StoreMigrationParticipant[]{this.createIndexMigrator(), failingStoreMigrator}).migrateIfNeeded(this.workingDatabaseLayout, false);
            Assert.fail((String)"Should throw exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"This upgrade is failing", (Object)e.getMessage());
        }
        Assert.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasFormatVersion((StoreVersionCheck)versionCheck, (RecordFormats)this.baselineFormat));
        RecordStorageMigrator migrator = new RecordStorageMigrator(this.fs, this.pageCache, CONFIG, (LogService)logService, this.jobScheduler, PageCacheTracer.NULL, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        IdGeneratorMigrator idMigrator = new IdGeneratorMigrator(this.fs, this.pageCache, CONFIG, PageCacheTracer.NULL);
        SchemaIndexMigrator indexMigrator = this.createIndexMigrator();
        this.newUpgrader((StoreVersionCheck)versionCheck, progressMonitor, new StoreMigrationParticipant[]{indexMigrator, migrator, idMigrator}).migrateIfNeeded(this.workingDatabaseLayout, false);
        Assert.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasFormatVersion((StoreVersionCheck)versionCheck, (RecordFormats)this.successorFormat));
        StoreUpgraderInterruptionTestIT.startStopDatabase(this.neo4jLayout.homeDirectory());
        StoreAssertions.assertConsistentStore((DatabaseLayout)this.workingDatabaseLayout);
    }

    private SchemaIndexMigrator createIndexMigrator() {
        return new SchemaIndexMigrator("upgrade test indexes", this.fs, this.pageCache, IndexProvider.EMPTY.directoryStructure(), StorageEngineFactory.defaultStorageEngine(), true);
    }

    @Test
    public void tracePageCacheAccessOnIdStoreUpgrade() throws IOException, ConsistencyCheckIncompleteException {
        MigrationTestUtils.prepareSampleLegacyDatabase((String)this.version, (FileSystemAbstraction)this.fs, (Path)this.workingDatabaseLayout.databaseDirectory(), (Path)this.prepareDirectory);
        RecordStoreVersionCheck versionCheck = new RecordStoreVersionCheck(this.fs, this.pageCache, this.workingDatabaseLayout, (LogProvider)NullLogProvider.getInstance(), Config.defaults(), PageCacheTracer.NULL);
        MigrationProgressMonitor progressMonitor = MigrationProgressMonitor.SILENT;
        NullLogService logService = NullLogService.getInstance();
        DefaultPageCacheTracer idMigratorTracer = new DefaultPageCacheTracer();
        DefaultPageCacheTracer recordMigratorTracer = new DefaultPageCacheTracer();
        IdGeneratorMigrator idMigrator = new IdGeneratorMigrator(this.fs, this.pageCache, CONFIG, (PageCacheTracer)idMigratorTracer);
        Assert.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasFormatVersion((StoreVersionCheck)versionCheck, (RecordFormats)this.baselineFormat));
        RecordStorageMigrator migrator = new RecordStorageMigrator(this.fs, this.pageCache, CONFIG, (LogService)logService, this.jobScheduler, (PageCacheTracer)recordMigratorTracer, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.newUpgrader((StoreVersionCheck)versionCheck, progressMonitor, new StoreMigrationParticipant[]{this.createIndexMigrator(), migrator, idMigrator}).migrateIfNeeded(this.workingDatabaseLayout, false);
        Assert.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasFormatVersion((StoreVersionCheck)versionCheck, (RecordFormats)this.successorFormat));
        StoreUpgraderInterruptionTestIT.startStopDatabase(this.neo4jLayout.homeDirectory());
        StoreAssertions.assertConsistentStore((DatabaseLayout)this.workingDatabaseLayout);
        Assert.assertEquals((long)43L, (long)idMigratorTracer.faults());
        Assert.assertEquals((long)82L, (long)idMigratorTracer.hits());
        Assert.assertEquals((long)125L, (long)idMigratorTracer.pins());
        Assert.assertEquals((long)125L, (long)idMigratorTracer.unpins());
        Assert.assertEquals((long)61L, (long)recordMigratorTracer.faults());
        Assert.assertEquals((long)228L, (long)recordMigratorTracer.hits());
        Assert.assertEquals((long)289L, (long)recordMigratorTracer.pins());
        Assert.assertEquals((long)289L, (long)recordMigratorTracer.unpins());
    }

    @Test
    public void shouldSucceedWithUpgradeAfterPreviousAttemptDiedDuringMovingFiles() throws IOException, ConsistencyCheckIncompleteException {
        MigrationTestUtils.prepareSampleLegacyDatabase((String)this.version, (FileSystemAbstraction)this.fs, (Path)this.workingDatabaseLayout.databaseDirectory(), (Path)this.prepareDirectory);
        RecordStoreVersionCheck versionCheck = new RecordStoreVersionCheck(this.fs, this.pageCache, this.workingDatabaseLayout, (LogProvider)NullLogProvider.getInstance(), Config.defaults(), PageCacheTracer.NULL);
        MigrationProgressMonitor progressMonitor = MigrationProgressMonitor.SILENT;
        NullLogService logService = NullLogService.getInstance();
        RecordStorageMigrator failingStoreMigrator = new RecordStorageMigrator(this.fs, this.pageCache, CONFIG, (LogService)logService, this.jobScheduler, PageCacheTracer.NULL, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE){

            public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToUpgradeFrom, String versionToMigrateTo) throws IOException {
                super.moveMigratedFiles(migrationLayout, directoryLayout, versionToUpgradeFrom, versionToMigrateTo);
                throw new RuntimeException("This upgrade is failing");
            }
        };
        IdGeneratorMigrator idMigrator = new IdGeneratorMigrator(this.fs, this.pageCache, CONFIG, PageCacheTracer.NULL);
        Assert.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasFormatVersion((StoreVersionCheck)versionCheck, (RecordFormats)this.baselineFormat));
        try {
            this.newUpgrader((StoreVersionCheck)versionCheck, progressMonitor, new StoreMigrationParticipant[]{this.createIndexMigrator(), failingStoreMigrator, idMigrator}).migrateIfNeeded(this.workingDatabaseLayout, false);
            Assert.fail((String)"Should throw exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"This upgrade is failing", (Object)e.getMessage());
        }
        RecordStorageMigrator migrator = new RecordStorageMigrator(this.fs, this.pageCache, CONFIG, (LogService)logService, this.jobScheduler, PageCacheTracer.NULL, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.newUpgrader((StoreVersionCheck)versionCheck, progressMonitor, new StoreMigrationParticipant[]{this.createIndexMigrator(), migrator, idMigrator}).migrateIfNeeded(this.workingDatabaseLayout, false);
        Assert.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasFormatVersion((StoreVersionCheck)versionCheck, (RecordFormats)this.successorFormat));
        this.pageCache.close();
        StoreUpgraderInterruptionTestIT.startStopDatabase(this.neo4jLayout.homeDirectory());
        StoreAssertions.assertConsistentStore((DatabaseLayout)this.workingDatabaseLayout);
    }

    private StoreUpgrader newUpgrader(StoreVersionCheck versionCheck, MigrationProgressMonitor progressMonitor, StoreMigrationParticipant ... participants) {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.allow_upgrade, (Object)true);
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{new Monitors()});
        RecordStorageEngineFactory storageEngineFactory = new RecordStorageEngineFactory();
        DatabaseHealth databaseHealth = new DatabaseHealth(PanicEventGenerator.NO_OP, (Log)NullLog.getInstance());
        LogsUpgrader logsUpgrader = new LogsUpgrader(this.fs, (StorageEngineFactory)storageEngineFactory, this.workingDatabaseLayout, this.pageCache, this.legacyTransactionLogsLocator, config, (DependencyResolver)dependencies, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, databaseHealth, false);
        StoreUpgrader upgrader = new StoreUpgrader(versionCheck, progressMonitor, config, this.fs, (LogProvider)NullLogProvider.getInstance(), logsUpgrader, PageCacheTracer.NULL);
        for (StoreMigrationParticipant participant : participants) {
            upgrader.addParticipant(participant);
        }
        return upgrader;
    }

    private static void startStopDatabase(Path storeDir) {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).setConfig(GraphDatabaseSettings.allow_upgrade, (Object)true).build();
        managementService.database("neo4j");
        managementService.shutdown();
    }
}

