/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.compress;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.compress.ZipUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class ZipUtilsTest {
    @Inject
    TestDirectory testDirectory;
    @Inject
    DefaultFileSystemAbstraction fileSystem;

    ZipUtilsTest() {
    }

    @Test
    void doNotCreateZipArchiveForNonExistentSource() throws IOException {
        Path archiveFile = this.testDirectory.file("archive.zip");
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (Path)this.testDirectory.file("doesNotExist"), (Path)archiveFile);
        Assertions.assertFalse((boolean)this.fileSystem.fileExists(archiveFile));
    }

    @Test
    void doNotCreateZipArchiveForEmptyDirectory() throws IOException {
        Path archiveFile = this.testDirectory.file("archive.zip");
        Path emptyDirectory = this.testDirectory.directory("emptyDirectory");
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (Path)emptyDirectory, (Path)archiveFile);
        Assertions.assertFalse((boolean)this.fileSystem.fileExists(archiveFile));
    }

    @Test
    void archiveDirectory() throws IOException {
        Path archiveFile = this.testDirectory.file("directoryArchive.zip");
        Path directory = this.testDirectory.directory("directory");
        this.fileSystem.write(directory.resolve("a")).close();
        this.fileSystem.write(directory.resolve("b")).close();
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (Path)directory, (Path)archiveFile);
        Assertions.assertTrue((boolean)this.fileSystem.fileExists(archiveFile));
        Assertions.assertEquals((int)2, (int)ZipUtilsTest.countArchiveEntries(archiveFile));
    }

    @Test
    void archiveDirectoryWithSubdirectories() throws IOException {
        Path archiveFile = this.testDirectory.file("directoryWithSubdirectoriesArchive.zip");
        Path directoryArchive = this.testDirectory.directory("directoryWithSubdirs");
        Path subdir1 = directoryArchive.resolve("subdir1");
        Path subdir2 = directoryArchive.resolve("subdir");
        this.fileSystem.mkdir(subdir1);
        this.fileSystem.mkdir(subdir2);
        this.fileSystem.write(directoryArchive.resolve("a")).close();
        this.fileSystem.write(directoryArchive.resolve("b")).close();
        this.fileSystem.write(subdir1.resolve("c")).close();
        this.fileSystem.write(subdir2.resolve("d")).close();
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (Path)directoryArchive, (Path)archiveFile);
        Assertions.assertTrue((boolean)this.fileSystem.fileExists(archiveFile));
        Assertions.assertEquals((int)6, (int)ZipUtilsTest.countArchiveEntries(archiveFile));
    }

    @Test
    void archiveFile() throws IOException {
        Path archiveFile = this.testDirectory.file("fileArchive.zip");
        Path aFile = this.testDirectory.file("a");
        this.fileSystem.write(aFile).close();
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (Path)aFile, (Path)archiveFile);
        Assertions.assertTrue((boolean)this.fileSystem.fileExists(archiveFile));
        Assertions.assertEquals((int)1, (int)ZipUtilsTest.countArchiveEntries(archiveFile));
    }

    @Test
    public void supportSpacesInDestinationPath() throws IOException {
        Path archiveFile = this.testDirectory.file("file archive.zip");
        Path aFile = this.testDirectory.file("a");
        this.fileSystem.write(aFile).close();
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (Path)aFile, (Path)archiveFile);
    }

    private static int countArchiveEntries(Path archiveFile) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(Files.newInputStream(archiveFile, new OpenOption[0])));){
            int entries = 0;
            while (zipInputStream.getNextEntry() != null) {
                ++entries;
            }
            int n = entries;
            return n;
        }
    }
}

