/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.nio.file.Path;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.server.helpers.Transactor;
import org.neo4j.server.helpers.UnitOfWork;

public final class WebContainerHelper {
    private WebContainerHelper() {
    }

    public static void cleanTheDatabase(TestWebContainer testWebContainer) {
        if (testWebContainer == null) {
            return;
        }
        WebContainerHelper.rollbackAllOpenTransactions(testWebContainer);
        WebContainerHelper.cleanTheDatabase((GraphDatabaseService)testWebContainer.getDefaultDatabase());
    }

    public static void cleanTheDatabase(GraphDatabaseService db) {
        new Transactor(db, (UnitOfWork)new DeleteAllData(), 10).execute();
        new Transactor(db, (UnitOfWork)new DeleteAllSchema(), 10).execute();
    }

    public static TestWebContainer createNonPersistentContainer() throws Exception {
        return WebContainerHelper.createContainer(CommunityWebContainerBuilder.builder(), false, null);
    }

    public static TestWebContainer createReadOnlyContainer(Path path) throws Exception {
        CommunityWebContainerBuilder builder = CommunityWebContainerBuilder.builder();
        builder.withProperty("dbms.connector.bolt.listen_address", ":0");
        WebContainerHelper.createContainer(builder, true, path).shutdown();
        builder.withProperty(GraphDatabaseSettings.read_only_database_default.name(), "true");
        return WebContainerHelper.createContainer(builder, true, path);
    }

    public static TestWebContainer createNonPersistentContainer(LogProvider logProvider) throws Exception {
        return WebContainerHelper.createContainer(CommunityWebContainerBuilder.builder(logProvider), false, null);
    }

    public static TestWebContainer createNonPersistentContainer(CommunityWebContainerBuilder builder) throws Exception {
        return WebContainerHelper.createContainer(builder, false, null);
    }

    private static TestWebContainer createContainer(CommunityWebContainerBuilder builder, boolean persistent, Path path) throws Exception {
        if (persistent) {
            builder = builder.persistent();
        }
        builder.onRandomPorts();
        return builder.usingDataDir(path != null ? path.toAbsolutePath().toString() : null).build();
    }

    private static void rollbackAllOpenTransactions(TestWebContainer testWebContainer) {
        testWebContainer.getTransactionRegistry().rollbackAllSuspendedTransactions();
    }

    private static class DeleteAllSchema
    implements UnitOfWork {
        private DeleteAllSchema() {
        }

        public void doWork(Transaction transaction) {
            DeleteAllSchema.deleteAllIndexRules(transaction);
            DeleteAllSchema.deleteAllConstraints(transaction);
        }

        private static void deleteAllIndexRules(Transaction transaction) {
            for (IndexDefinition index : transaction.schema().getIndexes()) {
                if (index.isConstraintIndex()) continue;
                index.drop();
            }
        }

        private static void deleteAllConstraints(Transaction transaction) {
            for (ConstraintDefinition constraint : transaction.schema().getConstraints()) {
                constraint.drop();
            }
        }
    }

    private static class DeleteAllData
    implements UnitOfWork {
        private DeleteAllData() {
        }

        public void doWork(Transaction transaction) {
            DeleteAllData.deleteAllNodesAndRelationships(transaction);
        }

        private static void deleteAllNodesAndRelationships(Transaction tx) {
            ResourceIterable allNodes = tx.getAllNodes();
            for (Node n : allNodes) {
                Iterable relationships = n.getRelationships();
                for (Relationship rel : relationships) {
                    rel.delete();
                }
                n.delete();
            }
        }
    }
}

