/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.util.concurrent.Futures;

@Disabled(value="This test demonstrates a deadlock during concurrent relationship creation.")
@EphemeralTestDirectoryExtension
class RelationshipsDeadlockTest {
    private static final String STMT_BA = " WITH $personA as personA, $personB as personB      MATCH (target:Person { `name` : personB })       MATCH (source:Person { `name` : personA })      SET target._lock=true    SET source._lock=true WITH source, target     CREATE (source)-[rel:KNOWS]->(target)";
    private static final String STMT_AB = " WITH $personA as personA, $personB as personB      MATCH (source:Person { `name` : personA })      MATCH (target:Person { `name` : personB })       SET source._lock=true    SET target._lock=true WITH source, target     CREATE (source)-[rel:KNOWS]->(target)";
    private static final int NODES = 5;
    private static final int THREADS = 8;
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseService db;
    private DatabaseManagementService managementService;

    RelationshipsDeadlockTest() {
    }

    @BeforeEach
    void setUp() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setFileSystem(this.testDirectory.getFileSystem()).build();
        this.db = this.managementService.database("neo4j");
    }

    @AfterEach
    void tearDown() {
        this.managementService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void createRelationshipsConcurrently() throws InterruptedException {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 5; ++i) {
                tx.execute("MERGE (p:Person {name: " + i + "})");
            }
            tx.commit();
        }
        ExecutorService executorService = Executors.newFixedThreadPool(8);
        ArrayList futures = new ArrayList();
        AtomicReference error = new AtomicReference();
        try {
            List<Map<String, Object>> rels = RelationshipsDeadlockTest.generateRelationshipData();
            AtomicBoolean stop = new AtomicBoolean();
            Runnable workload = () -> {
                for (Map rel : rels) {
                    if (stop.get()) break;
                    try {
                        Transaction tx = this.db.beginTx();
                        try {
                            int a = (Integer)rel.get("personA");
                            int b = (Integer)rel.get("personB");
                            tx.execute(a > b ? STMT_AB : STMT_BA, rel);
                            tx.commit();
                        }
                        finally {
                            if (tx == null) continue;
                            tx.close();
                        }
                    }
                    catch (Exception e) {
                        if (stop.compareAndSet(false, true)) {
                            error.set(e);
                        }
                        stop.set(true);
                        throw new RuntimeException(e);
                    }
                }
            };
            for (int i = 0; i < 8; ++i) {
                futures.add(executorService.submit(workload));
            }
        }
        finally {
            executorService.shutdown();
        }
        Assertions.assertTrue((boolean)executorService.awaitTermination(10L, TimeUnit.MINUTES));
        Assertions.assertDoesNotThrow(() -> Futures.getAll((Iterable)futures));
        if (error.get() != null) {
            Assertions.fail((Throwable)((Throwable)error.get()));
        }
    }

    private static List<Map<String, Object>> generateRelationshipData() {
        Random rnd = new Random();
        ArrayList<Map<String, Object>> rels = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < 10000; ++i) {
            IntIntPair pair;
            while ((pair = PrimitiveTuples.pair((int)rnd.nextInt(5), (int)rnd.nextInt(5))).getOne() == pair.getTwo()) {
            }
            rels.add((Map<String, Object>)Maps.fixedSize.of((Object)"personA", (Object)pair.getOne(), (Object)"personB", (Object)pair.getTwo()));
        }
        return rels;
    }
}

