/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.db;

import java.io.IOException;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.snapshot.TestTransactionVersionContextSupplier;
import org.neo4j.snapshot.TestVersionContext;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class QueryRestartIT {
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseService database;
    private TestTransactionVersionContextSupplier.Factory testContextSupplierFactory;
    private Path storeDir;
    private DatabaseManagementService managementService;

    QueryRestartIT() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.storeDir = this.testDirectory.homePath();
        this.testContextSupplierFactory = new TestTransactionVersionContextSupplier.Factory();
        this.database = this.startSnapshotQueryDb();
        this.createData();
        this.checkpoint();
        this.testContextSupplierFactory.setTestVersionContextSupplier(databaseName -> TestVersionContext.testCursorContext((DatabaseManagementService)this.managementService, (String)databaseName));
    }

    private void checkpoint() throws IOException {
        ((CheckPointer)((GraphDatabaseAPI)this.database).getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Test"));
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void executeQueryWithoutRestarts() {
        try (Transaction transaction = this.database.beginTx();){
            TestVersionContext testVersionContext = QueryRestartIT.getTestVersionContext(transaction);
            testVersionContext.setWrongLastClosedTxId(false);
            Result result = transaction.execute("MATCH (n:label) RETURN n.c");
            while (result.hasNext()) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"d", result.next().get("n.c"));
            }
            if (testVersionContext.getAdditionalAttempts() > 0) {
                System.err.println("Unexpected call to markAsDirty/isDirty:");
                testVersionContext.printDirtyCalls(System.err);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)testVersionContext.getAdditionalAttempts());
            transaction.commit();
        }
    }

    @Test
    void executeQueryWithSingleRetry() {
        try (Transaction transaction = this.database.beginTx();){
            TestVersionContext testVersionContext = QueryRestartIT.getTestVersionContext(transaction);
            Result result = transaction.execute("MATCH (n) RETURN n.c");
            Assertions.assertThat((int)testVersionContext.getAdditionalAttempts()).isNotZero();
            while (result.hasNext()) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"d", result.next().get("n.c"));
            }
            transaction.commit();
        }
    }

    @Test
    void executeCountStoreQueryWithSingleRetry() {
        try (Transaction transaction = this.database.beginTx();){
            TestVersionContext testVersionContext = QueryRestartIT.getTestVersionContext(transaction);
            Result result = transaction.execute("MATCH (n:toRetry) RETURN count(n)");
            Assertions.assertThat((int)testVersionContext.getAdditionalAttempts()).isNotZero();
            while (result.hasNext()) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)1L, result.next().get("count(n)"));
            }
            transaction.commit();
        }
    }

    @Test
    void executeLabelScanQueryWithSingleRetry() {
        try (Transaction transaction = this.database.beginTx();){
            TestVersionContext testVersionContext = QueryRestartIT.getTestVersionContext(transaction);
            Result result = transaction.execute("MATCH (n:toRetry) RETURN n.c");
            Assertions.assertThat((int)testVersionContext.getAdditionalAttempts()).isNotZero();
            while (result.hasNext()) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"d", result.next().get("n.c"));
            }
            transaction.commit();
        }
    }

    @Test
    void queryThatModifiesDataAndSeesUnstableSnapshotShouldThrowException() {
        try (Transaction transaction = this.database.beginTx();){
            QueryExecutionException e = (QueryExecutionException)org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> transaction.execute("MATCH (n:toRetry) CREATE () RETURN n.c"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Unable to get clean data snapshot for query 'MATCH (n:toRetry) CREATE () RETURN n.c' that performs updates.", (Object)e.getMessage());
            transaction.commit();
        }
    }

    private GraphDatabaseService startSnapshotQueryDb() {
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{this.testContextSupplierFactory});
        this.managementService = new TestDatabaseManagementServiceBuilder(this.storeDir).setExternalDependencies((DependencyResolver)dependencies).setConfig(GraphDatabaseInternalSettings.snapshot_query, (Object)true).setConfig(GraphDatabaseSettings.index_background_sampling_enabled, (Object)false).build();
        return this.managementService.database("neo4j");
    }

    private void createData() {
        Label label = Label.label((String)"toRetry");
        try (Transaction transaction = this.database.beginTx();){
            Node node = transaction.createNode(new Label[]{label});
            node.setProperty("c", (Object)"d");
            transaction.commit();
        }
    }

    private static TestVersionContext getTestVersionContext(Transaction transaction) {
        CursorContext cursorContext = ((InternalTransaction)transaction).kernelTransaction().cursorContext();
        return (TestVersionContext)cursorContext.getVersionContext();
    }
}

