/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.server.helpers.WebContainerHelper;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;
import org.neo4j.test.server.HTTP;

class ReadOnlyIT
extends ExclusiveWebContainerTestBase {
    private TestWebContainer readOnlyContainer;
    private HTTP.Builder http;

    ReadOnlyIT() {
    }

    @BeforeEach
    void setup() throws Exception {
        WebContainerHelper.cleanTheDatabase(this.readOnlyContainer);
        this.readOnlyContainer = WebContainerHelper.createReadOnlyContainer(this.testDirectory.homePath());
        this.http = HTTP.withBaseUri((URI)this.readOnlyContainer.getBaseUri());
    }

    @AfterEach
    void teardown() {
        if (this.readOnlyContainer != null) {
            this.readOnlyContainer.shutdown();
        }
    }

    @Test
    void shouldReturnReadOnlyStatusWhenCreatingNodes() throws Exception {
        HTTP.Response response = this.http.POST(ReadOnlyIT.txEndpoint(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (node)' } ] }"));
        JsonNode error = response.get("errors").get(0);
        String code = error.get("code").asText();
        String message = error.get("message").asText();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Neo.ClientError.General.WriteOnReadOnlyAccessDatabase", (Object)code);
        Assertions.assertThat((String)message).contains(new CharSequence[]{"The database is in read-only mode on this Neo4j instance"});
    }

    @Test
    void shouldReturnReadOnlyStatusWhenCreatingNodesWhichTransitivelyCreateTokens() throws Exception {
        HTTP.Response response = this.http.POST(ReadOnlyIT.txEndpoint(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (node:Node)' } ] }"));
        JsonNode error = response.get("errors").get(0);
        String code = error.get("code").asText();
        String message = error.get("message").asText();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Neo.ClientError.General.WriteOnReadOnlyAccessDatabase", (Object)code);
        Assertions.assertThat((String)message).contains(new CharSequence[]{"The database is in read-only mode on this Neo4j instance"});
    }
}

