/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.http.cypher.integration.TransactionConditions;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;

public class QueryResultsSerializationTest
extends AbstractRestFunctionalTestBase {
    private final HTTP.Builder http = HTTP.withBaseUri((URI)QueryResultsSerializationTest.container().getBaseUri());
    private String commitResource;

    @BeforeEach
    public void setUp() {
        HTTP.Response begin = this.http.POST(QueryResultsSerializationTest.txUri());
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        QueryResultsSerializationTest.assertHasTxLocation(begin);
        try {
            this.commitResource = begin.stringFromContent("commit");
        }
        catch (JsonParseException e) {
            org.junit.jupiter.api.Assertions.fail((String)("Exception caught when setting up test: " + e.getMessage()));
        }
        Assertions.assertThat((String)this.commitResource).isEqualTo(begin.location() + "/commit");
    }

    @AfterEach
    public void tearDown() {
        this.executeTransactionally("MATCH (n) DETACH DELETE n");
    }

    @Test
    public void shouldBeAbleToReturnDeletedEntitiesGraph() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonGraph("MATCH (s:Start)-[r:R]->(e:End) DELETE s, r, e RETURN *"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.graphContainsDeletedRelationships((int)1));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.graphContainsDeletedNodes((int)2));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(0L);
    }

    @Test
    public void shouldBeAbleToReturnDeletedEntitiesRest() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRest("MATCH (s:Start)-[r:R]->(e:End) DELETE s, r, e RETURN *"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.restContainsDeletedEntities((int)3));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(0L);
    }

    @Test
    public void shouldBeAbleToReturnDeletedEntitiesRow() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRow("MATCH (s:Start)-[r:R]->(e:End) DELETE s, r, e RETURN *"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.rowContainsDeletedEntities((int)2, (int)1));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(0L);
    }

    @Test
    public void shouldNotMarkNormalEntitiesAsDeletedGraph() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonGraph("MATCH (s:Start)-[r:R]->(e:End) RETURN *"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.graphContainsNoDeletedEntities());
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
    }

    @Test
    public void shouldNotMarkNormalEntitiesAsDeletedRow() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRow("MATCH (s:Start)-[r:R]->(e:End) RETURN *"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.rowContainsNoDeletedEntities());
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
    }

    @Test
    public void shouldNotMarkNormalEntitiesAsDeletedRest() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRest("MATCH (s:Start)-[r:R]->(e:End) RETURN *"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.restContainsNoDeletedEntities());
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
    }

    @Test
    public void shouldBeAbleToReturnDeletedNodesGraph() {
        this.executeTransactionally("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonGraph("MATCH (n:NodeToDelete) DELETE n RETURN n"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.graphContainsDeletedNodes((int)1));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(0L);
    }

    @Test
    public void shouldBeAbleToReturnDeletedNodesRow() {
        this.executeTransactionally("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRow("MATCH (n:NodeToDelete) DELETE n RETURN n"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.rowContainsDeletedEntities((int)1, (int)0));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(0L);
    }

    @Test
    public void shouldBeAbleToReturnDeletedNodesRest() {
        this.executeTransactionally("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRest("MATCH (n:NodeToDelete) DELETE n RETURN n"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.restContainsDeletedEntities((int)1));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(0L);
    }

    @Test
    public void shouldBeAbleToReturnDeletedRelationshipsGraph() {
        this.executeTransactionally("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonGraph("MATCH (s)-[r:R]->(e) DELETE r RETURN r"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.graphContainsDeletedRelationships((int)1));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(2L);
    }

    @Test
    public void shouldBeAbleToReturnDeletedRelationshipsRow() {
        this.executeTransactionally("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRow("MATCH (s)-[r:R]->(e) DELETE r RETURN r"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.rowContainsDeletedEntities((int)0, (int)1));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(2L);
    }

    @Test
    public void shouldBeAbleToReturnDeletedRelationshipsRest() {
        this.executeTransactionally("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRest("MATCH (s)-[r:R]->(e) DELETE r RETURN r"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.restContainsDeletedEntities((int)1));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(2L);
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedNodeGraph() {
        this.executeTransactionally("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonGraph("MATCH (n:NodeToDelete) DELETE n RETURN n.p"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.EntityNotFound}));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(1L);
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedNodeRow() {
        this.executeTransactionally("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRow("MATCH (n:NodeToDelete) DELETE n RETURN n.p"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.EntityNotFound}));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(1L);
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedNodeRest() {
        this.executeTransactionally("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRest("MATCH (n:NodeToDelete) DELETE n RETURN n.p"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.EntityNotFound}));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(1L);
    }

    @Test
    public void shouldFailIfTryingToReturnLabelsOfDeletedNodeGraph() {
        this.executeTransactionally("CREATE (:NodeToDelete)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonGraph("MATCH (n:NodeToDelete) DELETE n RETURN labels(n)"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.EntityNotFound}));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(1L);
    }

    @Test
    public void shouldFailIfTryingToReturnLabelsOfDeletedNodeRow() {
        this.executeTransactionally("CREATE (:NodeToDelete)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRow("MATCH (n:NodeToDelete) DELETE n RETURN labels(n)"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.EntityNotFound}));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(1L);
    }

    @Test
    public void shouldFailIfTryingToReturnLabelsOfDeletedNodeRest() {
        this.executeTransactionally("CREATE (:NodeToDelete)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRest("MATCH (n:NodeToDelete) DELETE n RETURN labels(n)"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.EntityNotFound}));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(1L);
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedRelationshipGraph() {
        this.executeTransactionally("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonGraph("MATCH (s)-[r:R]->(e) DELETE r RETURN r.p"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.EntityNotFound}));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(2L);
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedRelationshipRow() {
        this.executeTransactionally("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRow("MATCH (s)-[r:R]->(e) DELETE r RETURN r.p"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.EntityNotFound}));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(2L);
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedRelationshipRest() {
        this.executeTransactionally("CREATE (:Start)-[:MARKER {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRest("MATCH (s)-[r:MARKER]->(e) DELETE r RETURN r.p"));
        ((ObjectAssert)Assertions.assertThat((Object)commit).as("Error raw response: " + commit.rawContent(), new Object[0])).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.EntityNotFound}));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(2L);
    }

    @Test
    public void returningADeletedPathGraph() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonGraph("MATCH p=(s)-[r:R]->(e) DELETE p RETURN p"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.graphContainsDeletedNodes((int)2));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.graphContainsDeletedRelationships((int)1));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(0L);
    }

    @Test
    public void returningAPartiallyDeletedPathGraph() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonGraph("MATCH p=(s)-[r:R]->(e) DELETE s,r RETURN p"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.graphContainsDeletedNodes((int)1));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.graphContainsDeletedRelationships((int)1));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(1L);
    }

    @Test
    public void returningADeletedPathRow() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRow("MATCH p=(s)-[r:R]->(e) DELETE p RETURN p"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.rowContainsDeletedEntitiesInPath((int)2, (int)1));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(0L);
    }

    @Test
    public void returningAPartiallyDeletedPathRow() {
        String query = "CREATE (:Start)-[:R]->(:End)";
        this.executeTransactionally(query);
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRow("MATCH p=(s)-[r:R]->(e) DELETE s,r RETURN p"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.rowContainsDeletedEntitiesInPath((int)1, (int)1));
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(1L);
    }

    private void executeTransactionally(String query) {
        GraphDatabaseService database = this.graphdb();
        try (Transaction transaction = database.beginTx();){
            transaction.execute(query);
            transaction.commit();
        }
    }

    @Test
    public void returningADeletedPathRest() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRest("MATCH p=(s)-[r:R]->(e) DELETE p RETURN p"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(0L);
    }

    @Test
    public void returningAPartiallyDeletedPathRest() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRest("MATCH p=(s)-[r:R]->(e) DELETE s,r RETURN p"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(1L);
    }

    @Test
    public void nestedShouldWorkGraph() {
        this.executeTransactionally("CREATE ()");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonGraph("MATCH (n) DELETE (n) RETURN [n, {someKey: n}]"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.graphContainsDeletedNodes((int)1));
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(0L);
    }

    @Test
    public void nestedShouldWorkRest() {
        this.executeTransactionally("CREATE ()");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRest("MATCH (n) DELETE (n) RETURN [n, {someKey: n}]"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((Object)commit).satisfies(QueryResultsSerializationTest.restContainsNestedDeleted());
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(0L);
    }

    @Test
    public void nestedShouldWorkRow() {
        this.executeTransactionally("CREATE ()");
        HTTP.Response commit = this.http.POST(this.commitResource, QueryResultsSerializationTest.queryAsJsonRow("MATCH (n) DELETE (n) RETURN [n, {someKey: n}]"));
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.containsNoErrors());
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((Object)commit).satisfies(TransactionConditions.rowContainsDeletedEntities((int)2, (int)0));
        Assertions.assertThat((long)this.nodesInDatabase()).isEqualTo(0L);
    }

    @Test
    public void shouldHandleTemporalArrays() throws Exception {
        GraphDatabaseAPI db = QueryResultsSerializationTest.getDefaultDatabase();
        ZonedDateTime date = ZonedDateTime.of(1980, 3, 11, 0, 0, 0, 0, ZoneId.of("Europe/Stockholm"));
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("date", (Object)new ZonedDateTime[]{date});
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", new String[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("row").get(0).get("date").get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"1980-03-11T00:00+01:00[Europe/Stockholm]\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleDurationArrays() throws Exception {
        GraphDatabaseAPI db = QueryResultsSerializationTest.getDefaultDatabase();
        Duration duration = Duration.ofSeconds(73L);
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("duration", (Object)new Duration[]{duration});
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", new String[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("row").get(0).get("duration").get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"PT1M13S\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleTemporalUsingRestResultDataContent() throws Exception {
        GraphDatabaseAPI db = QueryResultsSerializationTest.getDefaultDatabase();
        ZonedDateTime date = ZonedDateTime.of(1980, 3, 11, 0, 0, 0, 0, ZoneId.of("Europe/Stockholm"));
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("date", (Object)date);
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "rest");
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("rest").get(0).get("data").get("date");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"1980-03-11T00:00+01:00[Europe/Stockholm]\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleDurationUsingRestResultDataContent() throws Exception {
        GraphDatabaseAPI db = QueryResultsSerializationTest.getDefaultDatabase();
        Duration duration = Duration.ofSeconds(73L);
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("duration", (Object)duration);
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "rest");
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("rest").get(0).get("data").get("duration");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"PT1M13S\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleTemporalArraysUsingRestResultDataContent() throws Exception {
        GraphDatabaseAPI db = QueryResultsSerializationTest.getDefaultDatabase();
        ZonedDateTime date = ZonedDateTime.of(1980, 3, 11, 0, 0, 0, 0, ZoneId.of("Europe/Stockholm"));
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("dates", (Object)new ZonedDateTime[]{date});
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "rest");
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("rest").get(0).get("data").get("dates").get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"1980-03-11T00:00+01:00[Europe/Stockholm]\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleDurationArraysUsingRestResultDataContent() throws Exception {
        GraphDatabaseAPI db = QueryResultsSerializationTest.getDefaultDatabase();
        Duration duration = Duration.ofSeconds(73L);
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("durations", (Object)new Duration[]{duration});
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "rest");
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("rest").get(0).get("data").get("durations").get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"PT1M13S\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleTemporalUsingGraphResultDataContent() throws Exception {
        GraphDatabaseAPI db = QueryResultsSerializationTest.getDefaultDatabase();
        ZonedDateTime date = ZonedDateTime.of(1980, 3, 11, 0, 0, 0, 0, ZoneId.of("Europe/Stockholm"));
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("date", (Object)date);
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "graph");
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("graph").get("nodes").get(0).get("properties").get("date");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"1980-03-11T00:00+01:00[Europe/Stockholm]\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleDurationUsingGraphResultDataContent() throws Exception {
        GraphDatabaseAPI db = QueryResultsSerializationTest.getDefaultDatabase();
        Duration duration = Duration.ofSeconds(73L);
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("duration", (Object)duration);
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "graph");
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("graph").get("nodes").get(0).get("properties").get("duration");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"PT1M13S\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleTemporalArraysUsingGraphResultDataContent() throws Exception {
        GraphDatabaseAPI db = QueryResultsSerializationTest.getDefaultDatabase();
        ZonedDateTime date = ZonedDateTime.of(1980, 3, 11, 0, 0, 0, 0, ZoneId.of("Europe/Stockholm"));
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("dates", (Object)new ZonedDateTime[]{date});
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "graph");
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("graph").get("nodes").get(0).get("properties").get("dates").get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"1980-03-11T00:00+01:00[Europe/Stockholm]\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleDurationArraysUsingGraphResultDataContent() throws Exception {
        GraphDatabaseAPI db = QueryResultsSerializationTest.getDefaultDatabase();
        Duration duration = Duration.ofSeconds(73L);
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("durations", (Object)new Duration[]{duration});
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "graph");
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("graph").get("nodes").get(0).get("properties").get("durations").get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"PT1M13S\"", (Object)row.toString());
    }

    private static HTTP.RawPayload queryAsJsonGraph(String query) {
        return HTTP.RawPayload.quotedJson((String)("{ 'statements': [ { 'statement': '" + query + "', 'resultDataContents': [ 'graph' ] } ] }"));
    }

    private static HTTP.RawPayload queryAsJsonRest(String query) {
        return HTTP.RawPayload.quotedJson((String)("{ 'statements': [ { 'statement': '" + query + "', 'resultDataContents': [ 'rest' ] } ] }"));
    }

    private static HTTP.RawPayload queryAsJsonRow(String query) {
        return HTTP.RawPayload.quotedJson((String)("{ 'statements': [ { 'statement': '" + query + "', 'resultDataContents': [ 'row' ] } ] }"));
    }

    private long nodesInDatabase() {
        GraphDatabaseService database = this.graphdb();
        try (Transaction transaction = database.beginTx();){
            long l;
            block12: {
                Result r = transaction.execute("MATCH (n) RETURN count(n) AS c");
                try {
                    l = (Long)r.columnAs("c").next();
                    if (r == null) break block12;
                }
                catch (Throwable throwable) {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                r.close();
            }
            return l;
        }
    }

    private static GraphDatabaseAPI getDefaultDatabase() {
        return QueryResultsSerializationTest.container().getDefaultDatabase();
    }

    private static Condition<? super HTTP.Response> restContainsNestedDeleted() {
        return new Condition(response -> {
            try {
                JsonNode list = (JsonNode)TransactionConditions.getJsonNodeWithName((HTTP.Response)response, (String)"rest").iterator().next();
                Assertions.assertThat((boolean)list.get(0).get("metadata").get("deleted").asBoolean()).isEqualTo((Object)Boolean.TRUE);
                Assertions.assertThat((boolean)list.get(1).get("someKey").get("metadata").get("deleted").asBoolean()).isEqualTo((Object)Boolean.TRUE);
                return true;
            }
            catch (JsonParseException e) {
                return false;
            }
        }, "Contains deleted data.", new Object[0]);
    }
}

