/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.TestData;
import org.neo4j.test.server.HTTP;
import org.neo4j.test.server.SharedWebContainerTestBase;

public class AbstractRestFunctionalTestBase
extends SharedWebContainerTestBase
implements GraphHolder {
    @RegisterExtension
    TestData<Map<String, Node>> data = TestData.producedThrough((TestData.Producer)GraphDescription.createGraphFor((GraphHolder)this));
    @RegisterExtension
    protected TestData<RESTRequestGenerator> gen = TestData.producedThrough(RESTRequestGenerator.PRODUCER);

    public GraphDatabaseService graphdb() {
        return AbstractRestFunctionalTestBase.container().getDefaultDatabase();
    }

    public <T> T resolveDependency(Class<T> cls) {
        return (T)((GraphDatabaseAPI)this.graphdb()).getDependencyResolver().resolveDependency(cls);
    }

    private static String defaultDatabaseUri() {
        return AbstractRestFunctionalTestBase.databaseUri("neo4j");
    }

    private static String databaseUri(String databaseName) {
        return AbstractRestFunctionalTestBase.databaseUri(AbstractRestFunctionalTestBase.getLocalHttpPort(), databaseName);
    }

    private static String databaseUri(int port, String databaseName) {
        return String.format("http://localhost:%s/db/%s/", port, databaseName);
    }

    protected static String dbUri() {
        return "http://localhost:" + AbstractRestFunctionalTestBase.getLocalHttpPort() + "/db/";
    }

    protected static String txUri() {
        return AbstractRestFunctionalTestBase.defaultDatabaseUri() + "tx";
    }

    protected static String txUri(String databaseName) {
        return AbstractRestFunctionalTestBase.databaseUri(databaseName) + "tx";
    }

    protected static String txCommitUri() {
        return AbstractRestFunctionalTestBase.defaultDatabaseUri() + "tx/commit";
    }

    public static String txCommitUri(String databaseName) {
        return AbstractRestFunctionalTestBase.databaseUri(databaseName) + "tx/commit";
    }

    public static String txCommitUri(String databaseName, int port) {
        return AbstractRestFunctionalTestBase.databaseUri(port, databaseName) + "tx/commit";
    }

    protected static String txUri(long txId) {
        return AbstractRestFunctionalTestBase.defaultDatabaseUri() + "tx/" + txId;
    }

    protected static long extractTxId(HTTP.Response response) {
        int lastSlash = response.location().lastIndexOf(47);
        String txIdString = response.location().substring(lastSlash + 1);
        return Long.parseLong(txIdString);
    }

    protected static int getLocalHttpPort() {
        GraphDatabaseFacade database = AbstractRestFunctionalTestBase.container().getDefaultDatabase();
        ConnectorPortRegister connectorPortRegister = (ConnectorPortRegister)database.getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
        return connectorPortRegister.getLocalAddress("http").getPort();
    }

    protected static HTTP.Response runQuery(String query, String ... contentTypes) {
        Object resultDataContents = "";
        if (contentTypes.length > 0) {
            resultDataContents = ", 'resultDataContents': [" + Arrays.stream(contentTypes).map(unquoted -> String.format("'%s'", unquoted)).collect(Collectors.joining(",")) + "]";
        }
        return HTTP.POST((String)AbstractRestFunctionalTestBase.txCommitUri(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)String.format("{'statements': [{'statement': '%s'%s}]}", query, resultDataContents)));
    }

    protected static void assertNoErrors(HTTP.Response response) throws JsonParseException {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"[]", (Object)response.get("errors").toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)response.get("errors").size());
    }

    protected static void assertHasTxLocation(HTTP.Response begin) {
        Assertions.assertThat((String)begin.location()).matches((CharSequence)(AbstractRestFunctionalTestBase.txUri() + "/\\d+"));
    }

    protected static void assertHasTxLocation(HTTP.Response begin, String txUri) {
        Assertions.assertThat((String)begin.location()).matches((CharSequence)String.format("http://localhost:\\d+/%s/\\d+", txUri));
    }
}

