/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import javax.ws.rs.core.MediaType;
import org.assertj.core.api.Assertions;
import org.neo4j.function.Predicates;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.test.TestData;

public class RESTRequestGenerator {
    public static final TestData.Producer<RESTRequestGenerator> PRODUCER = (graph, title, documentation) -> new RESTRequestGenerator();
    private int expectedResponseStatus = -1;
    private MediaType expectedMediaType = MediaType.valueOf((String)"application/json; charset=UTF-8");
    private MediaType payloadMediaType = MediaType.APPLICATION_JSON_TYPE;
    private final List<Pair<String, Predicate<String>>> expectedHeaderFields = new ArrayList<Pair<String, Predicate<String>>>();
    private String payload;
    private final Map<String, String> addedRequestHeaders = new TreeMap<String, String>();

    private RESTRequestGenerator() {
    }

    public RESTRequestGenerator expectedStatus(int expectedResponseStatus) {
        this.expectedResponseStatus = expectedResponseStatus;
        return this;
    }

    public RESTRequestGenerator expectedType(MediaType expectedMediaType) {
        this.expectedMediaType = expectedMediaType;
        return this;
    }

    public RESTRequestGenerator payloadType(MediaType payloadMediaType) {
        this.payloadMediaType = payloadMediaType;
        return this;
    }

    public RESTRequestGenerator withHeader(String key, String value) {
        this.addedRequestHeaders.put(key, value);
        return this;
    }

    public RESTRequestGenerator payload(String payload) {
        this.payload = payload;
        return this;
    }

    public RESTRequestGenerator expectedHeader(String expectedHeaderField) {
        this.expectedHeaderFields.add((Pair<String, Predicate<String>>)Pair.of((Object)expectedHeaderField, (Object)Predicates.notNull()));
        return this;
    }

    public RESTRequestGenerator expectedHeader(String expectedHeaderField, String expectedValue) {
        this.expectedHeaderFields.add((Pair<String, Predicate<String>>)Pair.of((Object)expectedHeaderField, Predicate.isEqual(expectedValue)));
        return this;
    }

    public ResponseEntity get(String uri) {
        return this.retrieveResponseFromRequest("GET", uri, this.expectedResponseStatus, this.expectedMediaType, this.expectedHeaderFields);
    }

    public ResponseEntity post(String uri) {
        return this.retrieveResponseFromRequest("POST", uri, this.payload, this.payloadMediaType, this.expectedResponseStatus, this.expectedMediaType, this.expectedHeaderFields);
    }

    public ResponseEntity put(String uri) {
        return this.retrieveResponseFromRequest("PUT", uri, this.payload, this.payloadMediaType, this.expectedResponseStatus, this.expectedMediaType, this.expectedHeaderFields);
    }

    public ResponseEntity delete(String uri) {
        return this.retrieveResponseFromRequest("DELETE", uri, this.payload, this.payloadMediaType, this.expectedResponseStatus, this.expectedMediaType, this.expectedHeaderFields);
    }

    private ResponseEntity retrieveResponseFromRequest(String method, String uri, int responseCode, MediaType accept, List<Pair<String, Predicate<String>>> headerFields) {
        HttpRequest request = this.newRequestBuilder(uri).method(method, HttpRequest.BodyPublishers.noBody()).header("Accept", accept.toString()).build();
        return RESTRequestGenerator.retrieveResponse(responseCode, accept, headerFields, request);
    }

    private ResponseEntity retrieveResponseFromRequest(String method, String uri, String payload, MediaType payloadType, int responseCode, MediaType accept, List<Pair<String, Predicate<String>>> headerFields) {
        HttpRequest request = payload != null ? this.newRequestBuilder(uri).method(method, HttpRequest.BodyPublishers.ofString(payload)).header("Content-Type", payloadType.toString()).header("Accept", accept.toString()).build() : this.newRequestBuilder(uri).method(method, HttpRequest.BodyPublishers.noBody()).header("Accept", accept.toString()).build();
        return RESTRequestGenerator.retrieveResponse(responseCode, accept, headerFields, request);
    }

    private HttpRequest.Builder newRequestBuilder(String uri) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(uri));
        for (Map.Entry<String, String> entry : this.addedRequestHeaders.entrySet()) {
            builder.header(entry.getKey(), entry.getValue());
        }
        return builder;
    }

    private static ResponseEntity retrieveResponse(int responseCode, MediaType type, List<Pair<String, Predicate<String>>> headerFields, HttpRequest request) {
        try {
            HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            Optional<String> responseContentType = response.headers().firstValue("Content-Type");
            responseContentType.ifPresent(responseType -> Assertions.assertThat((String)responseType).isEqualToIgnoringCase((CharSequence)type.toString()));
            HttpHeaders responseHeaders = response.headers();
            for (Pair<String, Predicate<String>> headerField : headerFields) {
                String name = (String)headerField.first();
                Predicate verifier = (Predicate)headerField.other();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)verifier.test(responseHeaders.firstValue(name).orElseThrow()), (String)("Wrong headers: " + responseHeaders));
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)responseCode, (int)response.statusCode());
            return new ResponseEntity(response);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static class ResponseEntity {
        private final String entity;
        private final JaxRsResponse response;

        ResponseEntity(HttpResponse<String> response) {
            this.response = new JaxRsResponse(response);
            this.entity = response.body();
        }

        public String entity() {
            return this.entity;
        }

        public JaxRsResponse response() {
            return this.response;
        }
    }
}

