/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.recordstorage.ReadOnlyTransactionIdStore;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class ReadOnlyTransactionIdStoreIT {
    @Inject
    private PageCache pageCache;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private FileSystemAbstraction fs;

    ReadOnlyTransactionIdStoreIT() {
    }

    @Test
    void testPageCacheAccessOnTransactionIdStoreConstruction() throws IOException {
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer("testPageCacheAccessOnTransactionIdStoreConstruction"));
        new ReadOnlyTransactionIdStore(this.fs, this.pageCache, this.databaseLayout, cursorContext);
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(4L);
        Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(4L);
        Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(4L);
    }
}

