/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Supplier;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.Barrier;
import org.neo4j.test.Race;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@EphemeralTestDirectoryExtension
class RollbackIdLeakIT {
    @Inject
    private TestDirectory directory;
    @Inject
    private EphemeralFileSystemAbstraction fs;

    RollbackIdLeakIT() {
    }

    @Test
    void shouldNotLeakHighIdsOnRollbackAfterCleanRestart() throws IOException {
        RollbackIdLeakIT.shouldNotLeakHighIdsOnRollback(this::clean);
    }

    @Test
    void shouldNotLeakHighIdsOnRollbackAfterCrashAndRecovery() throws IOException {
        RollbackIdLeakIT.shouldNotLeakHighIdsOnRollback(this::nonClean);
    }

    private static void shouldNotLeakHighIdsOnRollback(Supplier<DbRestarter> restarterSupplier) throws IOException {
        LongHashSet rolledBackNodeIds = new LongHashSet();
        LongHashSet rolledBackRelationshipIds = new LongHashSet();
        LongHashSet committedNodeIds = new LongHashSet();
        LongHashSet committedRelationshipIds = new LongHashSet();
        try (DbRestarter restarter = restarterSupplier.get();){
            GraphDatabaseService db = restarter.start();
            Barrier.Control flowControl = new Barrier.Control();
            Race race = new Race();
            race.addContestant(() -> RollbackIdLeakIT.lambda$shouldNotLeakHighIdsOnRollback$0(db, (MutableLongSet)rolledBackNodeIds, (MutableLongSet)rolledBackRelationshipIds, flowControl), 1);
            race.addContestant(Race.throwing(() -> RollbackIdLeakIT.lambda$shouldNotLeakHighIdsOnRollback$1(flowControl, db, (MutableLongSet)committedNodeIds, (MutableLongSet)committedRelationshipIds)), 1);
            race.goUnchecked();
            try (Transaction tx = db.beginTx();){
                committedNodeIds.forEach((LongProcedure & Serializable)nodeId -> tx.getNodeById(nodeId).delete());
                committedRelationshipIds.forEach((LongProcedure & Serializable)relationshipId -> tx.getRelationshipById(relationshipId).delete());
                tx.commit();
            }
            LongHashSet nodeIds = new LongHashSet();
            nodeIds.addAll((LongIterable)rolledBackNodeIds);
            nodeIds.addAll((LongIterable)committedNodeIds);
            LongHashSet relationshipIds = new LongHashSet();
            relationshipIds.addAll((LongIterable)rolledBackRelationshipIds);
            relationshipIds.addAll((LongIterable)committedRelationshipIds);
            RollbackIdLeakIT.assertAllocateIds(restarter.restart(), (MutableLongSet)nodeIds, (MutableLongSet)relationshipIds);
        }
    }

    @Test
    void shouldNotLeakHighIdsOnCreateDeleteInSameTxAfterCleanRestart() throws IOException {
        RollbackIdLeakIT.shouldNotLeakHighIdsOnCreateDeleteInSameTx(this::clean);
    }

    @Test
    void shouldNotLeakHighIdsOnCreateDeleteInSameTxAfterCrashAndRecovery() throws IOException {
        RollbackIdLeakIT.shouldNotLeakHighIdsOnCreateDeleteInSameTx(this::nonClean);
    }

    private static void shouldNotLeakHighIdsOnCreateDeleteInSameTx(Supplier<DbRestarter> restarterSupplier) throws IOException {
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relationshipIds = new LongHashSet();
        try (DbRestarter restarter = restarterSupplier.get();){
            Relationship relationship2;
            Node node2;
            GraphDatabaseService db = restarter.start();
            try (Transaction tx = db.beginTx();){
                Node node1 = tx.createNode();
                Relationship relationship1 = node1.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
                node2 = tx.createNode();
                relationship2 = node2.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
                nodeIds.add(node2.getId());
                relationshipIds.add(relationship2.getId());
                node1.delete();
                nodeIds.add(node1.getId());
                relationship1.delete();
                relationshipIds.add(relationship1.getId());
                tx.commit();
            }
            tx = db.beginTx();
            try {
                tx.getNodeById(node2.getId()).delete();
                tx.getRelationshipById(relationship2.getId()).delete();
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            RollbackIdLeakIT.assertAllocateIds(restarter.restart(), (MutableLongSet)nodeIds, (MutableLongSet)relationshipIds);
        }
    }

    private static void assertAllocateIds(GraphDatabaseService db, MutableLongSet nodeIds, MutableLongSet relationshipIds) {
        try (Transaction tx = db.beginTx();){
            int i;
            int nodes = nodeIds.size();
            int relationships = relationshipIds.size();
            for (i = 0; i < nodes; ++i) {
                Node node = tx.createNode();
                Assertions.assertTrue((boolean)nodeIds.remove(node.getId()));
            }
            for (i = 0; i < relationships; ++i) {
                Relationship relationship = tx.createNode().createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
                Assertions.assertTrue((boolean)relationshipIds.remove(relationship.getId()));
            }
            tx.commit();
        }
        Assertions.assertTrue((boolean)nodeIds.isEmpty());
        Assertions.assertTrue((boolean)relationshipIds.isEmpty());
    }

    private DbRestarter clean() {
        return new DbRestarter(){
            private DatabaseManagementService dbms;

            @Override
            public GraphDatabaseService start() {
                this.dbms = new TestDatabaseManagementServiceBuilder(RollbackIdLeakIT.this.directory.homePath()).build();
                return this.dbms.database("neo4j");
            }

            @Override
            public GraphDatabaseService restart() {
                this.close();
                return this.start();
            }

            @Override
            public void close() {
                this.dbms.shutdown();
            }
        };
    }

    private DbRestarter nonClean() {
        return new DbRestarter(){
            private DatabaseManagementService dbms;
            private EphemeralFileSystemAbstraction fsSnapshot;

            @Override
            public GraphDatabaseService start() {
                return this.start(RollbackIdLeakIT.this.fs);
            }

            @Override
            public GraphDatabaseService restart() {
                this.fsSnapshot = RollbackIdLeakIT.this.fs.snapshot();
                this.dbms.shutdown();
                return this.start(this.fsSnapshot);
            }

            @Override
            public void close() throws IOException {
                this.dbms.shutdown();
                this.fsSnapshot.close();
            }

            private GraphDatabaseService start(EphemeralFileSystemAbstraction fs) {
                this.dbms = new TestDatabaseManagementServiceBuilder(RollbackIdLeakIT.this.directory.homePath()).setFileSystem((FileSystemAbstraction)fs).build();
                return this.dbms.database("neo4j");
            }
        };
    }

    private static /* synthetic */ void lambda$shouldNotLeakHighIdsOnRollback$1(Barrier.Control flowControl, GraphDatabaseService db, MutableLongSet committedNodeIds, MutableLongSet committedRelationshipIds) throws Throwable {
        flowControl.await();
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            Relationship relationship = node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            committedNodeIds.add(node.getId());
            committedRelationshipIds.add(relationship.getId());
            tx.commit();
        }
        flowControl.release();
    }

    private static /* synthetic */ void lambda$shouldNotLeakHighIdsOnRollback$0(GraphDatabaseService db, MutableLongSet rolledBackNodeIds, MutableLongSet rolledBackRelationshipIds, Barrier.Control flowControl) {
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            Relationship relationship = node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            rolledBackNodeIds.add(node.getId());
            rolledBackRelationshipIds.add(relationship.getId());
            flowControl.reached();
        }
    }

    private static interface DbRestarter
    extends Closeable {
        public GraphDatabaseService start();

        public GraphDatabaseService restart() throws IOException;
    }
}

