/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.test.PortUtils;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;

class WebContainerConfigIT
extends ExclusiveWebContainerTestBase {
    private TestWebContainer testWebContainer;

    WebContainerConfigIT() {
    }

    @AfterEach
    void stopTheServer() {
        this.testWebContainer.shutdown();
    }

    @Test
    void shouldRequireAuth() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).withProperty(ServerSettings.http_auth_allowlist.name(), "").withProperty(GraphDatabaseSettings.auth_enabled.name(), "true").build();
        HttpRequest request = HttpRequest.newBuilder(this.testWebContainer.getBaseUri()).GET().build();
        HttpResponse<Void> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.discarding());
        Assertions.assertThat((int)response.statusCode()).isEqualTo(401);
    }

    @Test
    void shouldWhitelist() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).withProperty(ServerSettings.http_auth_allowlist.name(), "/").withProperty(GraphDatabaseSettings.auth_enabled.name(), "true").build();
        HttpRequest request = HttpRequest.newBuilder(this.testWebContainer.getBaseUri()).GET().build();
        HttpResponse<Void> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.discarding());
        Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
    }

    @Test
    void shouldBlacklistPaths() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).withProperty(ServerSettings.http_paths_blacklist.name(), "/*").build();
        HttpRequest request = HttpRequest.newBuilder(this.testWebContainer.getBaseUri()).GET().build();
        HttpResponse<Void> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.discarding());
        Assertions.assertThat((int)response.statusCode()).isEqualTo(403);
    }

    @Test
    void shouldPickUpAddressFromConfig() throws Exception {
        SocketAddress nonDefaultAddress = new SocketAddress("0.0.0.0", 0);
        this.testWebContainer = CommunityWebContainerBuilder.builder().onAddress(nonDefaultAddress).usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).build();
        GraphDatabaseFacade database = this.testWebContainer.getDefaultDatabase();
        HostnamePort localHttpAddress = PortUtils.getConnectorAddress((GraphDatabaseAPI)database, (String)"http");
        org.junit.jupiter.api.Assertions.assertNotEquals((int)7474, (int)localHttpAddress.getPort());
        org.junit.jupiter.api.Assertions.assertEquals((Object)nonDefaultAddress.getHostname(), (Object)localHttpAddress.getHost());
        HttpRequest request = HttpRequest.newBuilder(this.testWebContainer.getBaseUri()).GET().build();
        HttpResponse<Void> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.discarding());
        Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
    }

    @Test
    void shouldPickupRelativeUrisForDatabaseApi() throws Exception {
        String dbUri = "a/different/db/uri";
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).withRelativeDatabaseApiPath("/" + dbUri).build();
        String uri = this.testWebContainer.getBaseUri() + dbUri + "/neo4j/tx/commit";
        HttpRequest txRequest = HttpRequest.newBuilder(URI.create(uri)).header("Accept", "application/json").header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString("{ 'statements': [ { 'statement': 'CREATE ()' } ] }")).build();
        HttpResponse<Void> txResponse = HttpClient.newHttpClient().send(txRequest, HttpResponse.BodyHandlers.discarding());
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)txResponse.statusCode());
        HttpRequest discoveryRequest = HttpRequest.newBuilder(this.testWebContainer.getBaseUri()).GET().build();
        HttpResponse<String> discoveryResponse = HttpClient.newHttpClient().send(discoveryRequest, HttpResponse.BodyHandlers.ofString());
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)txResponse.statusCode());
        Assertions.assertThat((String)discoveryResponse.body()).contains(new CharSequence[]{dbUri});
    }

    @Test
    void shouldPickupRelativeUrisForRestApi() throws Exception {
        String dbUri = "a/different/rest/api/path";
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).withRelativeRestApiPath("/" + dbUri).build();
        String uri = this.testWebContainer.getBaseUri() + dbUri + "/transaction/commit";
        HttpRequest txRequest = HttpRequest.newBuilder(URI.create(uri)).header("Accept", "application/json").header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString("{ 'statements': [ { 'statement': 'CREATE ()' } ] }")).build();
        HttpResponse<Void> txResponse = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build().send(txRequest, HttpResponse.BodyHandlers.discarding());
        System.out.println(txResponse);
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)txResponse.statusCode());
        HttpRequest discoveryRequest = HttpRequest.newBuilder(this.testWebContainer.getBaseUri()).GET().build();
        HttpResponse<String> discoveryResponse = HttpClient.newHttpClient().send(discoveryRequest, HttpResponse.BodyHandlers.ofString());
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)txResponse.statusCode());
        Assertions.assertThat((String)discoveryResponse.body()).doesNotContain(new CharSequence[]{dbUri});
    }

    @Test
    void shouldGenerateWADLWhenExplicitlyEnabledInConfig() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(ServerSettings.wadl_enabled.name(), "true").usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).build();
        URI wadlUri = URI.create(this.testWebContainer.getBaseUri() + "application.wadl");
        HttpRequest request = HttpRequest.newBuilder(wadlUri).GET().header("Content-Type", "*/*").build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response.statusCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/vnd.sun.wadl+xml", (Object)response.headers().allValues("Content-Type").iterator().next());
        Assertions.assertThat((String)response.body()).contains(new CharSequence[]{"<application xmlns=\"http://wadl.dev.java.net/2009/02\">"});
    }

    @Test
    void shouldNotGenerateWADLWhenNotExplicitlyEnabledInConfig() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).build();
        URI uri = URI.create(this.testWebContainer.getBaseUri() + "application.wadl");
        HttpRequest request = HttpRequest.newBuilder(uri).GET().header("Content-Type", "*/*").build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        org.junit.jupiter.api.Assertions.assertEquals((int)404, (int)response.statusCode());
    }

    @Test
    void shouldNotGenerateWADLWhenExplicitlyDisabledInConfig() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(ServerSettings.wadl_enabled.name(), "false").usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).build();
        URI warlUri = URI.create(this.testWebContainer.getBaseUri() + "application.wadl");
        HttpRequest request = HttpRequest.newBuilder(warlUri).GET().header("Content-Type", "*/*").build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        org.junit.jupiter.api.Assertions.assertEquals((int)404, (int)response.statusCode());
    }
}

