/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.concurrent.Callable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.locking.LockCountVisitor;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThread;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.server.HTTP;

@ExtendWith(value={OtherThreadExtension.class})
class DeadlockIT
extends AbstractRestFunctionalTestBase {
    private final HTTP.Builder http = HTTP.withBaseUri((URI)DeadlockIT.container().getBaseUri());
    @Inject
    private OtherThread otherThread;

    DeadlockIT() {
    }

    @Test
    void shouldReturnCorrectStatusCodeOnDeadlock() throws Exception {
        try (Transaction tx = this.graphdb().beginTx();){
            tx.createNode(new Label[]{Label.label((String)"First")});
            tx.createNode(new Label[]{Label.label((String)"Second")});
            tx.createNode(new Label[]{Label.label((String)"Second")});
            tx.commit();
        }
        HTTP.Response begin = this.http.POST(DeadlockIT.txUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:First) SET n.prop=1' } ] }"));
        this.otherThread.execute(this.writeToFirstAndSecond());
        this.waitForLocksToBeAquired();
        HTTP.Response deadlock = this.http.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:Second) SET n.prop=1' } ] }"));
        JsonNode errors = deadlock.get("errors").get(0);
        Assertions.assertThat((String)errors.get("code").asText()).isEqualTo(Status.Transaction.DeadlockDetected.code().serialize());
    }

    private void waitForLocksToBeAquired() {
        LockCountVisitor lockCountVisitor;
        do {
            lockCountVisitor = new LockCountVisitor();
            ((Locks)((GraphDatabaseAPI)this.graphdb()).getDependencyResolver().resolveDependency(Locks.class)).accept((Locks.Visitor)lockCountVisitor);
        } while (lockCountVisitor.getLockCount() < 5);
    }

    private Callable<Void> writeToFirstAndSecond() {
        return () -> {
            HTTP.Response post = this.http.POST(DeadlockIT.txUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:Second) SET n.prop=1' } ] }"));
            this.http.POST(post.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:First) SET n.prop=1' } ] }"));
            return null;
        };
    }
}

