/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.procedures;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.collection.RawIterator;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.CommunityDatabaseState;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.StubDatabaseStateService;
import org.neo4j.dbms.procedures.StandaloneDatabaseStateProcedure;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

class CommunityDatabaseStateProcedureTest {
    private final TestDatabaseIdRepository.Caching idRepository = new TestDatabaseIdRepository.Caching();

    CommunityDatabaseStateProcedureTest() {
    }

    @Test
    void shouldThrowWithInvalidInput() {
        StandaloneDatabaseStateProcedure procedure = this.procedure((DatabaseStateService)new StubDatabaseStateService(CommunityDatabaseState::unknown));
        Assertions.assertThrows(IllegalArgumentException.class, () -> procedure.apply((Context)Mockito.mock(Context.class), new AnyValue[0], (ResourceTracker)Mockito.mock(ResourceTracker.class)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> procedure.apply((Context)Mockito.mock(Context.class), new AnyValue[]{null}, (ResourceTracker)Mockito.mock(ResourceTracker.class)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> procedure.apply((Context)Mockito.mock(Context.class), new AnyValue[]{Values.intValue((int)42), Values.stringValue((String)"The answer")}, (ResourceTracker)Mockito.mock(ResourceTracker.class)));
    }

    @Test
    void shouldThrowWhenDatabaseNotFound() throws ProcedureException {
        NamedDatabaseId existing = this.idRepository.getRaw("existing");
        NamedDatabaseId nonExisting = this.idRepository.getRaw("nonExisting");
        this.idRepository.filter(nonExisting.name());
        Map<NamedDatabaseId, CommunityDatabaseState> states = Map.of(existing, new CommunityDatabaseState(existing, true, false, null));
        StubDatabaseStateService stateService = new StubDatabaseStateService(states, CommunityDatabaseState::unknown);
        StandaloneDatabaseStateProcedure procedure = this.procedure((DatabaseStateService)stateService);
        procedure.apply((Context)Mockito.mock(Context.class), new AnyValue[]{Values.stringValue((String)existing.name())}, (ResourceTracker)Mockito.mock(ResourceTracker.class));
        Assertions.assertThrows(ProcedureException.class, () -> procedure.apply((Context)Mockito.mock(Context.class), new AnyValue[]{Values.stringValue((String)nonExisting.name())}, (ResourceTracker)Mockito.mock(ResourceTracker.class)));
    }

    @Test
    void shouldReturnEmptyErrorForNoError() throws ProcedureException {
        NamedDatabaseId existing = this.idRepository.getRaw("existing");
        Map<NamedDatabaseId, CommunityDatabaseState> states = Map.of(existing, new CommunityDatabaseState(existing, true, false, null));
        StubDatabaseStateService stateService = new StubDatabaseStateService(states, CommunityDatabaseState::unknown);
        StandaloneDatabaseStateProcedure procedure = this.procedure((DatabaseStateService)stateService);
        RawIterator result = procedure.apply((Context)Mockito.mock(Context.class), new AnyValue[]{Values.stringValue((String)existing.name())}, (ResourceTracker)Mockito.mock(ResourceTracker.class));
        List<AnyValue> returned = Arrays.asList((AnyValue[])result.next());
        Assertions.assertEquals((int)4, (int)returned.size(), (String)"Procedure result should have 4 columns: role, address, state and error message");
        TextValue roleColumn = Values.stringValue((String)"standalone");
        TextValue addressColumn = Values.stringValue((String)"localhost:7687");
        TextValue statusColumn = Values.stringValue((String)"online");
        TextValue errorColumn = Values.stringValue((String)"");
        Assertions.assertEquals(Arrays.asList(roleColumn, addressColumn, statusColumn, errorColumn), returned, (String)"Error column should be empty");
    }

    private StandaloneDatabaseStateProcedure procedure(DatabaseStateService stateService) {
        return new StandaloneDatabaseStateProcedure(stateService, (DatabaseIdRepository)this.idRepository, ((SocketAddress)Config.defaults().get(BoltConnector.advertised_address)).toString());
    }
}

