/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;

class BoltIT
extends ExclusiveWebContainerTestBase {
    private TestWebContainer testWebContainer;

    BoltIT() {
    }

    @AfterEach
    void stopTheServer() {
        if (this.testWebContainer != null) {
            this.testWebContainer.shutdown();
        }
    }

    @Test
    void shouldLaunchBolt() throws Throwable {
        this.startServerWithBoltEnabled();
        ConnectorPortRegister connectorPortRegister = this.getDependency(ConnectorPortRegister.class);
        BoltIT.assertEventuallyServerResponds("localhost", connectorPortRegister.getLocalAddress("bolt").getPort());
    }

    @Test
    void shouldBeAbleToSpecifyHostAndPort() throws Throwable {
        this.startServerWithBoltEnabled();
        ConnectorPortRegister connectorPortRegister = this.getDependency(ConnectorPortRegister.class);
        BoltIT.assertEventuallyServerResponds("localhost", connectorPortRegister.getLocalAddress("bolt").getPort());
    }

    @Test
    void boltAddressShouldComeFromConnectorAdvertisedAddress() throws Throwable {
        String host = "neo4j.com";
        this.startServerWithBoltEnabled(host, 9999, "localhost", 0);
        HttpRequest request = HttpRequest.newBuilder(this.testWebContainer.getBaseUri()).GET().build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        Map map = JsonHelper.jsonToMap((String)response.body());
        Assertions.assertThat((String)String.valueOf(map.get("bolt_direct"))).contains(new CharSequence[]{"bolt://" + host + ":9999"});
    }

    private void startServerWithBoltEnabled() throws IOException {
        this.startServerWithBoltEnabled("localhost", 7687, "localhost", 7687);
    }

    private void startServerWithBoltEnabled(String advertisedHost, int advertisedPort, String listenHost, int listenPort) throws IOException {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(BoltConnector.enabled.name(), "true").withProperty(BoltConnector.encryption_level.name(), "DISABLED").withProperty(BoltConnector.advertised_address.name(), advertisedHost + ":" + advertisedPort).withProperty(BoltConnector.listen_address.name(), listenHost + ":" + listenPort).usingDataDir(this.testDirectory.homePath().toString()).build();
    }

    private static void assertEventuallyServerResponds(String host, int port) throws Exception {
        SocketConnection conn = new SocketConnection();
        conn.connect(new HostnamePort(host, port));
        conn.send(new byte[]{96, 96, -80, 23, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        Assertions.assertThat((byte[])conn.recv(4)).isEqualTo((Object)new byte[]{0, 0, 0, 4});
    }

    private <T> T getDependency(Class<T> clazz) {
        return this.testWebContainer.resolveDependency(clazz);
    }
}

