/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.upgrade;

import java.io.IOException;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.store.StoreAssertions;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_4;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.RecordStoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreUpgraderTest;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;

@PageCacheExtension
public class StoreUpgradeOnStartupTest {
    @Inject
    private TestDirectory testDir;
    @Inject
    private PageCache pageCache;
    @Inject
    private FileSystemAbstraction fileSystem;
    private RecordDatabaseLayout workingDatabaseLayout;
    private StoreVersionCheck check;
    private Path workingHomeDir;
    private DatabaseManagementService managementService;
    private RecordFormats successorFormat;

    private static Stream<Arguments> versions() {
        return Stream.of(Arguments.of((Object[])new Object[]{StandardV3_4.STORE_VERSION}));
    }

    private void init(String version) throws IOException {
        this.workingHomeDir = this.testDir.homePath("working_" + version);
        this.workingDatabaseLayout = RecordDatabaseLayout.of((Neo4jLayout)Neo4jLayout.of((Path)this.workingHomeDir), (String)"neo4j");
        this.check = new RecordStoreVersionCheck(this.fileSystem, this.pageCache, this.workingDatabaseLayout, (LogProvider)NullLogProvider.getInstance(), Config.defaults(), PageCacheTracer.NULL);
        Path prepareDirectory = this.testDir.directory("prepare_" + version);
        MigrationTestUtils.prepareSampleLegacyDatabase((String)version, (FileSystemAbstraction)this.fileSystem, (Path)this.workingDatabaseLayout.databaseDirectory(), (Path)prepareDirectory);
        RecordFormats baselineFormat = RecordFormatSelector.selectForVersion((String)version);
        this.successorFormat = RecordFormatSelector.findLatestFormatInFamily((RecordFormats)baselineFormat).orElse(baselineFormat);
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    public void shouldUpgradeAutomaticallyOnDatabaseStartup(String version) throws ConsistencyCheckIncompleteException, IOException {
        this.init(version);
        this.createGraphDatabaseService();
        this.managementService.shutdown();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasFormatVersion((StoreVersionCheck)this.check, (RecordFormats)this.successorFormat), (String)"Some store files did not have the correct version");
        StoreAssertions.assertConsistentStore((DatabaseLayout)this.workingDatabaseLayout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"versions"})
    public void shouldAbortOnNonCleanlyShutdown(String version) throws Throwable {
        this.init(version);
        StoreUpgraderTest.removeCheckPointFromTxLog((FileSystemAbstraction)this.fileSystem, (Path)this.workingDatabaseLayout.databaseDirectory());
        GraphDatabaseAPI database = this.createGraphDatabaseService();
        try {
            DatabaseStateService databaseStateService = (DatabaseStateService)database.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)databaseStateService.causeOfFailure(database.databaseId()).isPresent());
            Assertions.assertThat((Throwable)ExceptionUtils.getRootCause((Throwable)((Throwable)databaseStateService.causeOfFailure(database.databaseId()).get()))).isInstanceOf(StoreUpgrader.UnableToUpgradeException.class);
        }
        finally {
            this.managementService.shutdown();
        }
    }

    private GraphDatabaseAPI createGraphDatabaseService() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.workingHomeDir).setConfig(GraphDatabaseSettings.allow_upgrade, (Object)true).build();
        return (GraphDatabaseAPI)this.managementService.database("neo4j");
    }
}

