/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.dbms.systemgraph.DriverSettings;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
public abstract class BaseTopologyGraphDbmsModelTest {
    @Inject
    protected DatabaseManagementService managementService;
    @Inject
    protected GraphDatabaseService db;
    protected Transaction tx;

    @BeforeEach
    public void before() {
        this.tx = this.db.beginTx();
        this.createModel(this.tx);
    }

    @AfterEach
    public void after() {
        this.tx.commit();
        this.tx.close();
    }

    protected abstract void createModel(Transaction var1);

    protected ServerId newInstance(Consumer<InstanceNodeBuilder> setup) {
        return this.newInstance(setup, false);
    }

    protected ServerId newRemovedInstance(Consumer<InstanceNodeBuilder> setup) {
        return this.newInstance(setup, true);
    }

    protected NamedDatabaseId newDatabase(Consumer<DatabaseNodeBuilder> setup) {
        return this.newDatabase(setup, false);
    }

    protected NamedDatabaseId newDeletedDatabase(Consumer<DatabaseNodeBuilder> setup) {
        return this.newDatabase(setup, true);
    }

    public static ServerId serverId(int seed) {
        Random rng = new Random(seed);
        return new ServerId(new UUID(rng.nextLong(), rng.nextLong()));
    }

    public static Set<ServerId> serverIds(int from, int until) {
        return IntStream.range(from, until).mapToObj(BaseTopologyGraphDbmsModelTest::serverId).collect(Collectors.toSet());
    }

    protected void connect(NamedDatabaseId databaseId, ServerId serverId, TopologyGraphDbmsModel.HostedOnMode mode, boolean bootstrapper, boolean was) {
        try (Transaction tx = this.db.beginTx();){
            Node database = this.findDatabase(databaseId, tx);
            Node instance = this.findInstance(serverId, tx);
            Relationship relationship = this.mergeHostOn(was, database, instance);
            relationship.setProperty("mode", (Object)mode.name());
            if (bootstrapper) {
                relationship.setProperty("bootstrapper", (Object)true);
            }
            tx.commit();
        }
    }

    private Relationship mergeHostOn(boolean wasHostedOn, Node database, Node instance) {
        StreamSupport.stream(database.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.HOSTED_ON_RELATIONSHIP, TopologyGraphDbmsModel.WAS_HOSTED_ON_RELATIONSHIP}).spliterator(), false).filter(rel -> Objects.equals(rel.getEndNode(), instance)).forEach(Relationship::delete);
        RelationshipType nextRelLabel = wasHostedOn ? TopologyGraphDbmsModel.WAS_HOSTED_ON_RELATIONSHIP : TopologyGraphDbmsModel.HOSTED_ON_RELATIONSHIP;
        return database.createRelationshipTo(instance, nextRelLabel);
    }

    protected void disconnect(NamedDatabaseId databaseId, ServerId serverId, boolean replaceWithWas) {
        try (Transaction tx = this.db.beginTx();){
            Node database = this.findDatabase(databaseId, tx);
            Node instance = this.findInstance(serverId, tx);
            StreamSupport.stream(database.getRelationships(new RelationshipType[]{TopologyGraphDbmsModel.HOSTED_ON_RELATIONSHIP}).spliterator(), false).filter(rel -> rel.getEndNode().equals(instance)).forEach(rel -> {
                if (replaceWithWas) {
                    Relationship was = database.createRelationshipTo(instance, TopologyGraphDbmsModel.WAS_HOSTED_ON_RELATIONSHIP);
                    was.setProperty("mode", rel.getProperty("mode"));
                }
                rel.delete();
            });
            tx.commit();
        }
    }

    protected void databaseDelete(NamedDatabaseId id) {
        try (Transaction tx = this.db.beginTx();){
            Node database = this.findDatabase(id, tx);
            database.setProperty("update_id", (Object)((Long)database.getProperty("update_id") + 1L));
            database.addLabel(TopologyGraphDbmsModel.DELETED_DATABASE_LABEL);
            database.removeLabel(TopologyGraphDbmsModel.DATABASE_LABEL);
            tx.commit();
        }
    }

    protected void databaseSetState(NamedDatabaseId id, TopologyGraphDbmsModel.DatabaseStatus state) {
        try (Transaction tx = this.db.beginTx();){
            Node database = this.findDatabase(id, tx);
            database.setProperty("update_id", (Object)((Long)database.getProperty("update_id") + 1L));
            database.setProperty("status", (Object)state.name());
            tx.commit();
        }
    }

    protected void databaseIncreaseUpdateId(NamedDatabaseId ... ids) {
        try (Transaction tx = this.db.beginTx();){
            for (NamedDatabaseId id : ids) {
                Node database = this.findDatabase(id, tx);
                database.setProperty("update_id", (Object)((Long)database.getProperty("update_id") + 1L));
            }
            tx.commit();
        }
    }

    private NamedDatabaseId newDatabase(Consumer<DatabaseNodeBuilder> setup, boolean deleted) {
        try (Transaction tx = this.db.beginTx();){
            DatabaseNodeBuilder builder = new DatabaseNodeBuilder(tx, deleted);
            setup.accept(builder);
            NamedDatabaseId namedDatabaseId = builder.commit();
            return namedDatabaseId;
        }
    }

    private ServerId newInstance(Consumer<InstanceNodeBuilder> setup, boolean removed) {
        try (Transaction tx = this.db.beginTx();){
            InstanceNodeBuilder builder = new InstanceNodeBuilder(tx, removed);
            setup.accept(builder);
            ServerId serverId = builder.commit();
            return serverId;
        }
    }

    private Node findInstance(ServerId serverId, Transaction tx) {
        return Optional.ofNullable(tx.findNode(TopologyGraphDbmsModel.INSTANCE_LABEL, "uuid", (Object)serverId.uuid().toString())).orElseGet(() -> tx.findNode(TopologyGraphDbmsModel.REMOVED_INSTANCE_LABEL, "uuid", (Object)serverId.uuid().toString()));
    }

    private Node findDatabase(NamedDatabaseId databaseId, Transaction tx) {
        return Optional.ofNullable(tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, "uuid", (Object)databaseId.databaseId().uuid().toString())).orElseGet(() -> tx.findNode(TopologyGraphDbmsModel.DELETED_DATABASE_LABEL, "uuid", (Object)databaseId.databaseId().uuid().toString()));
    }

    protected Node createInternalReferenceForDatabase(Transaction tx, String name, boolean primary, NamedDatabaseId databaseId) {
        Node databaseNode = this.findDatabase(databaseId, tx);
        Node referenceNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.DATABASE_NAME_LABEL});
        referenceNode.setProperty("primary", (Object)primary);
        referenceNode.setProperty("name", (Object)name);
        referenceNode.createRelationshipTo(databaseNode, TopologyGraphDbmsModel.TARGETS_RELATIONSHIP);
        return referenceNode;
    }

    protected Node createExternalReferenceForDatabase(Transaction tx, String name, String targetName, RemoteUri uri, UUID uuid) {
        Node referenceNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.REMOTE_DATABASE_LABEL, TopologyGraphDbmsModel.DATABASE_NAME_LABEL});
        referenceNode.setProperty("primary", (Object)false);
        referenceNode.setProperty("name", (Object)name);
        referenceNode.setProperty("target_name", (Object)targetName);
        String uriString = String.format("%s://%s", uri.getScheme(), uri.getAddresses().get(0));
        referenceNode.setProperty("url", (Object)uriString);
        referenceNode.setProperty("version", (Object)uuid.toString());
        return referenceNode;
    }

    protected Node createDriverSettingsForExternalAlias(Transaction tx, Node externalRefNode, DriverSettings driverSettings) {
        Node settingsNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.DRIVER_SETTINGS_LABEL});
        driverSettings.isSslEnforced().ifPresent(enabled -> settingsNode.setProperty(DriverSettings.Keys.SSL_ENFORCED.toString(), enabled));
        driverSettings.connectionTimeout().ifPresent(timeout -> settingsNode.setProperty(DriverSettings.Keys.CONNECTION_TIMEOUT.toString(), timeout));
        driverSettings.connectionMaxLifetime().ifPresent(lifetime -> settingsNode.setProperty(DriverSettings.Keys.CONNECTION_MAX_LIFETIME.toString(), lifetime));
        driverSettings.connectionPoolAcquisitionTimeout().ifPresent(timeout -> settingsNode.setProperty(DriverSettings.Keys.CONNECTION_POOL_ACQUISITION_TIMEOUT.toString(), timeout));
        driverSettings.connectionPoolIdleTest().ifPresent(test -> settingsNode.setProperty(DriverSettings.Keys.CONNECTION_POOL_IDLE_TEST.toString(), test));
        driverSettings.connectionPoolMaxSize().ifPresent(size -> settingsNode.setProperty(DriverSettings.Keys.CONNECTION_POOL_MAX_SIZE.toString(), size));
        driverSettings.loggingLevel().ifPresent(level -> settingsNode.setProperty(DriverSettings.Keys.LOGGING_LEVEL.toString(), (Object)level.toString()));
        externalRefNode.createRelationshipTo(settingsNode, TopologyGraphDbmsModel.CONNECTS_WITH_RELATIONSHIP);
        return settingsNode;
    }

    protected static class InstanceNodeBuilder {
        Transaction tx;
        Node node;

        public InstanceNodeBuilder(Transaction tx, boolean removed) {
            this.tx = tx;
            this.node = tx.createNode(new Label[]{removed ? TopologyGraphDbmsModel.REMOVED_INSTANCE_LABEL : TopologyGraphDbmsModel.INSTANCE_LABEL});
        }

        public InstanceNodeBuilder withInstance() {
            return this.withInstance(new ServerId(UUID.randomUUID()));
        }

        public InstanceNodeBuilder withInstance(ServerId serverId) {
            this.node.setProperty("uuid", (Object)serverId.uuid().toString());
            this.node.setProperty("mode", (Object)GraphDatabaseSettings.Mode.CORE.name());
            this.node.setProperty("status", (Object)TopologyGraphDbmsModel.InstanceStatus.active.name());
            return this;
        }

        public InstanceNodeBuilder withMode(GraphDatabaseSettings.Mode mode) {
            this.node.setProperty("mode", (Object)mode.name());
            return this;
        }

        public InstanceNodeBuilder asDraining() {
            this.node.setProperty("status", (Object)TopologyGraphDbmsModel.InstanceStatus.draining.name());
            return this;
        }

        public ServerId commit() {
            this.node.setProperty("discovered_at", (Object)ZonedDateTime.now());
            ServerId id = new ServerId(UUID.fromString((String)this.node.getProperty("uuid")));
            this.tx.commit();
            return id;
        }
    }

    protected static class DatabaseNodeBuilder {
        Transaction tx;
        Node node;

        public DatabaseNodeBuilder(Transaction tx, boolean deleted) {
            this.tx = tx;
            this.node = tx.createNode(new Label[]{deleted ? TopologyGraphDbmsModel.DELETED_DATABASE_LABEL : TopologyGraphDbmsModel.DATABASE_LABEL});
        }

        public DatabaseNodeBuilder withDatabase(String databaseName) {
            return this.withDatabase(DatabaseIdFactory.from((String)databaseName, (UUID)UUID.randomUUID()));
        }

        public DatabaseNodeBuilder withDatabase(NamedDatabaseId namedDatabaseId) {
            this.node.setProperty("name", (Object)namedDatabaseId.name());
            this.node.setProperty("uuid", (Object)namedDatabaseId.databaseId().uuid().toString());
            this.node.setProperty("status", (Object)TopologyGraphDbmsModel.DatabaseStatus.online.name());
            this.node.setProperty("update_id", (Object)0L);
            return this;
        }

        public DatabaseNodeBuilder withStorageEngine(String storageEngine) {
            this.node.setProperty("storage_engine", (Object)storageEngine);
            return this;
        }

        public DatabaseNodeBuilder asStopped() {
            this.node.setProperty("status", (Object)TopologyGraphDbmsModel.DatabaseStatus.offline.name());
            return this;
        }

        public DatabaseNodeBuilder withDump() {
            this.node.setProperty("dump_data", (Object)true);
            return this;
        }

        public DatabaseNodeBuilder withInitialMembers(Set<ServerId> initialMembers) {
            this.node.setProperty("initial_members", initialMembers.stream().map(server -> server.uuid().toString()).toArray(String[]::new));
            return this;
        }

        public DatabaseNodeBuilder withStoreId(StoreId storeId) {
            this.node.setProperty("created_at", (Object)ZonedDateTime.ofInstant(Instant.ofEpochMilli(storeId.getCreationTime()), ZoneId.systemDefault()));
            this.node.setProperty("store_creation_time", (Object)storeId.getCreationTime());
            this.node.setProperty("store_random_id", (Object)storeId.getRandomId());
            this.node.setProperty("store_version", (Object)MetaDataStore.versionLongToString((long)storeId.getStoreVersion()));
            return this;
        }

        public DatabaseNodeBuilder withNumbers(int primaries, int secondaries) {
            this.node.setProperty("primaries", (Object)primaries);
            this.node.setProperty("secondaries", (Object)secondaries);
            return this;
        }

        public DatabaseNodeBuilder withDesignatedSeeder(ServerId designatedSeeder) {
            this.node.setProperty("designated_seeder", (Object)designatedSeeder.uuid().toString());
            return this;
        }

        public NamedDatabaseId commit() {
            NamedDatabaseId id = DatabaseIdFactory.from((String)((String)this.node.getProperty("name")), (UUID)UUID.fromString((String)this.node.getProperty("uuid")));
            this.tx.commit();
            return id;
        }
    }
}

