/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.net;

import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.StreamConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.harness.Neo4jBuilder;
import org.neo4j.harness.internal.InProcessNeo4j;
import org.neo4j.harness.internal.InProcessNeo4jBuilder;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.server.HTTP;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.Values;

@TestDirectoryExtension
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class ConnectionTrackingIT {
    private static final String NEO4J_USER_PWD = "test";
    private static final String OTHER_USER = "otherUser";
    private static final String OTHER_USER_PWD = "test";
    private static final List<String> LIST_CONNECTIONS_PROCEDURE_COLUMNS = Arrays.asList("connectionId", "connectTime", "connector", "username", "userAgent", "serverAddress", "clientAddress");
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final Set<TransportConnection> connections = ConcurrentHashMap.newKeySet();
    private final Set<HttpClient> httpClients = ConcurrentHashMap.newKeySet();
    private final TransportTestUtil util = new TransportTestUtil();
    @Inject
    private TestDirectory dir;
    private GraphDatabaseAPI db;
    private InProcessNeo4j neo4j;
    private long dummyNodeId;

    ConnectionTrackingIT() {
    }

    @BeforeAll
    void beforeAll() {
        this.neo4j = (InProcessNeo4j)((Neo4jBuilder)((Neo4jBuilder)((Neo4jBuilder)((Neo4jBuilder)new InProcessNeo4jBuilder(this.dir.homePath()).withConfig(GraphDatabaseSettings.neo4j_home, (Object)this.dir.absolutePath()).withConfig(GraphDatabaseSettings.auth_enabled, (Object)true)).withConfig(HttpConnector.enabled, (Object)true)).withConfig(HttpsConnector.enabled, (Object)true)).withConfig(ServerSettings.webserver_max_threads, (Object)50)).build();
        this.neo4j.start();
        this.db = (GraphDatabaseAPI)this.neo4j.defaultDatabaseService();
        this.changeDefaultPasswordForUserNeo4j("test");
        this.createNewUser(OTHER_USER, "test");
        this.dummyNodeId = this.createDummyNode();
        IOUtils.closeAllSilently(this.acceptedConnectionsFromConnectionTracker());
    }

    @AfterAll
    void afterAll() {
        this.executor.shutdownNow();
        this.neo4j.close();
    }

    @AfterEach
    void afterEach() {
        for (TransportConnection connection : this.connections) {
            try {
                connection.disconnect();
            }
            catch (Exception exception) {}
        }
        this.httpClients.clear();
        IOUtils.closeAllSilently(this.acceptedConnectionsFromConnectionTracker());
        this.terminateAllTransactions();
        this.awaitNumberOfAcceptedConnectionsToBe(0);
    }

    @Test
    void shouldListNoConnectionsWhenIdle() {
        this.verifyConnectionCount(TestConnector.HTTP, null, 0);
        this.verifyConnectionCount(TestConnector.HTTPS, null, 0);
        this.verifyConnectionCount(TestConnector.BOLT, null, 0);
    }

    @Test
    void shouldListUnauthenticatedHttpConnections() throws Exception {
        this.testListingOfUnauthenticatedConnections(5, 0, 0);
    }

    @Test
    void shouldListUnauthenticatedHttpsConnections() throws Exception {
        this.testListingOfUnauthenticatedConnections(0, 2, 0);
    }

    @Test
    void shouldListUnauthenticatedBoltConnections() throws Exception {
        this.testListingOfUnauthenticatedConnections(0, 0, 4);
    }

    @Test
    void shouldListUnauthenticatedConnections() throws Exception {
        this.testListingOfUnauthenticatedConnections(3, 2, 7);
    }

    @Test
    void shouldListAuthenticatedHttpConnections() throws Exception {
        this.lockNodeAndExecute(this.dummyNodeId, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            int i;
            for (i = 0; i < 4; ++i) {
                this.updateNodeViaHttp(this.dummyNodeId, "neo4j", "test");
            }
            for (i = 0; i < 3; ++i) {
                this.updateNodeViaHttp(this.dummyNodeId, OTHER_USER, "test");
            }
        }));
        this.awaitNumberOfAuthenticatedConnectionsToBe(7);
        this.verifyAuthenticatedConnectionCount(TestConnector.HTTP, "neo4j", 4);
        this.verifyAuthenticatedConnectionCount(TestConnector.HTTP, OTHER_USER, 3);
    }

    @Test
    void shouldListAuthenticatedHttpsConnections() throws Exception {
        this.lockNodeAndExecute(this.dummyNodeId, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            int i;
            for (i = 0; i < 4; ++i) {
                this.updateNodeViaHttps(this.dummyNodeId, "neo4j", "test");
            }
            for (i = 0; i < 5; ++i) {
                this.updateNodeViaHttps(this.dummyNodeId, OTHER_USER, "test");
            }
            this.awaitNumberOfAuthenticatedConnectionsToBe(9);
        }));
        this.verifyAuthenticatedConnectionCount(TestConnector.HTTPS, "neo4j", 4);
        this.verifyAuthenticatedConnectionCount(TestConnector.HTTPS, OTHER_USER, 5);
    }

    @Test
    void shouldListAuthenticatedBoltConnections() throws Exception {
        this.lockNodeAndExecute(this.dummyNodeId, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            int i;
            for (i = 0; i < 2; ++i) {
                this.updateNodeViaBolt(this.dummyNodeId, "neo4j", "test");
            }
            for (i = 0; i < 5; ++i) {
                this.updateNodeViaBolt(this.dummyNodeId, OTHER_USER, "test");
            }
        }));
        this.awaitNumberOfAuthenticatedConnectionsToBe(7);
        this.verifyAuthenticatedConnectionCount(TestConnector.BOLT, "neo4j", 2);
        this.verifyAuthenticatedConnectionCount(TestConnector.BOLT, OTHER_USER, 5);
    }

    @Test
    void shouldListAuthenticatedConnections() throws Exception {
        this.lockNodeAndExecute(this.dummyNodeId, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            int i;
            for (i = 0; i < 4; ++i) {
                this.updateNodeViaBolt(this.dummyNodeId, OTHER_USER, "test");
            }
            for (i = 0; i < 1; ++i) {
                this.updateNodeViaHttp(this.dummyNodeId, "neo4j", "test");
            }
            for (i = 0; i < 5; ++i) {
                this.updateNodeViaHttps(this.dummyNodeId, "neo4j", "test");
            }
            this.awaitNumberOfAuthenticatedConnectionsToBe(10);
        }));
        this.verifyConnectionCount(TestConnector.BOLT, OTHER_USER, 4);
        this.verifyConnectionCount(TestConnector.HTTP, "neo4j", 1);
        this.verifyConnectionCount(TestConnector.HTTPS, "neo4j", 5);
    }

    @Test
    void shouldKillHttpConnection() throws Exception {
        this.testKillingOfConnections(this.neo4j.httpURI(), TestConnector.HTTP, 4);
    }

    @Test
    void shouldKillHttpsConnection() throws Exception {
        this.testKillingOfConnections(this.neo4j.httpsURI(), TestConnector.HTTPS, 2);
    }

    @Test
    void shouldKillBoltConnection() throws Exception {
        this.testKillingOfConnections(this.neo4j.boltURI(), TestConnector.BOLT, 3);
    }

    private void testListingOfUnauthenticatedConnections(int httpCount, int httpsCount, int boltCount) throws Exception {
        int i;
        for (i = 0; i < httpCount; ++i) {
            this.connectSocketTo(this.neo4j.httpURI());
        }
        for (i = 0; i < httpsCount; ++i) {
            this.connectSocketTo(this.neo4j.httpsURI());
        }
        for (i = 0; i < boltCount; ++i) {
            this.connectSocketTo(this.neo4j.boltURI());
        }
        this.awaitNumberOfAcceptedConnectionsToBe(httpCount + httpsCount + boltCount);
        this.verifyConnectionCount(TestConnector.HTTP, null, httpCount);
        this.verifyConnectionCount(TestConnector.HTTPS, null, httpsCount);
        this.verifyConnectionCount(TestConnector.BOLT, null, boltCount);
    }

    private void testKillingOfConnections(URI uri, TestConnector connector, int count) throws Exception {
        ArrayList<TransportConnection> socketConnections = new ArrayList<TransportConnection>();
        for (int i = 0; i < count; ++i) {
            socketConnections.add(this.connectSocketTo(uri));
        }
        this.awaitNumberOfAcceptedConnectionsToBe(count);
        this.verifyConnectionCount(connector, null, count);
        this.killAcceptedConnectionViaBolt();
        this.verifyConnectionCount(connector, null, 0);
        for (TransportConnection socketConnection : socketConnections) {
            ConnectionTrackingIT.assertConnectionBreaks(socketConnection);
        }
    }

    private TransportConnection connectSocketTo(URI uri) throws IOException {
        SocketConnection connection = new SocketConnection();
        this.connections.add((TransportConnection)connection);
        connection.connect(new HostnamePort(uri.getHost(), uri.getPort()));
        return connection;
    }

    private void awaitNumberOfAuthenticatedConnectionsToBe(int n) {
        Assert.assertEventually((String)"Unexpected number of authenticated connections", this::authenticatedConnectionsFromConnectionTracker, (Condition)new HamcrestCondition(Matchers.hasSize((int)n)), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private void awaitNumberOfAcceptedConnectionsToBe(int n) {
        Assert.assertEventually(connections -> "Unexpected number of accepted connections: " + connections, this::acceptedConnectionsFromConnectionTracker, (Condition)new HamcrestCondition(Matchers.hasSize((int)n)), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private void verifyConnectionCount(TestConnector connector, String username, int expectedCount) {
        this.verifyConnectionCount(connector, username, expectedCount, false);
    }

    private void verifyAuthenticatedConnectionCount(TestConnector connector, String username, int expectedCount) {
        this.verifyConnectionCount(connector, username, expectedCount, true);
    }

    private void verifyConnectionCount(TestConnector connector, String username, int expectedCount, boolean expectAuthenticated) {
        Assert.assertEventually(connections -> "Unexpected number of listed connections: " + connections, () -> this.listMatchingConnection(connector, username, expectAuthenticated), (Condition)new HamcrestCondition(Matchers.hasSize((int)expectedCount)), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private List<Map<String, Object>> listMatchingConnection(TestConnector connector, String username, boolean expectAuthenticated) {
        ArrayList<Map<String, Object>> matchingRecords = new ArrayList<Map<String, Object>>();
        try (Transaction transaction = this.db.beginTx();){
            Result result = transaction.execute("CALL dbms.listConnections()");
            org.junit.jupiter.api.Assertions.assertEquals(LIST_CONNECTIONS_PROCEDURE_COLUMNS, (Object)result.columns());
            List records = result.stream().collect(Collectors.toList());
            for (Map record : records) {
                String actualConnector = record.get("connector").toString();
                org.junit.jupiter.api.Assertions.assertNotNull((Object)actualConnector);
                Object actualUsername = record.get("username");
                if (Objects.equals(connector.name, actualConnector) && Objects.equals(username, actualUsername)) {
                    if (expectAuthenticated) {
                        org.junit.jupiter.api.Assertions.assertEquals((Object)connector.userAgent, record.get("userAgent"));
                    }
                    matchingRecords.add(record);
                }
                Assertions.assertThat((String)record.get("connectionId").toString()).startsWith((CharSequence)actualConnector);
                OffsetDateTime connectTime = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)record.get("connectTime").toString(), OffsetDateTime::from);
                org.junit.jupiter.api.Assertions.assertNotNull((Object)connectTime);
                Assertions.assertThat(record.get("serverAddress")).isInstanceOf(String.class);
                Assertions.assertThat(record.get("clientAddress")).isInstanceOf(String.class);
            }
            transaction.commit();
        }
        return matchingRecords;
    }

    private List<TrackedNetworkConnection> authenticatedConnectionsFromConnectionTracker() {
        return this.acceptedConnectionsFromConnectionTracker().stream().filter(connection -> connection.username() != null).collect(Collectors.toList());
    }

    private List<TrackedNetworkConnection> acceptedConnectionsFromConnectionTracker() {
        NetworkConnectionTracker connectionTracker = (NetworkConnectionTracker)this.db.getDependencyResolver().resolveDependency(NetworkConnectionTracker.class);
        return connectionTracker.activeConnections();
    }

    private void changeDefaultPasswordForUserNeo4j(String newPassword) {
        String uri = this.neo4j.httpURI().resolve("db/system/tx/commit").toString();
        HTTP.Response response = HTTP.withBasicAuth((String)"neo4j", (String)"neo4j").POST(uri, ConnectionTrackingIT.query(String.format("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO '%s'", newPassword)));
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response.status());
    }

    private void createNewUser(String username, String password) {
        String uri = this.neo4j.httpURI().resolve("db/system/tx/commit").toString();
        HTTP.Response response1 = HTTP.withBasicAuth((String)"neo4j", (String)"test").POST(uri, ConnectionTrackingIT.query("CALL dbms.security.createUser(\\\"" + username + "\\\", \\\"" + password + "\\\", false)"));
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response1.status());
        HTTP.Response response2 = HTTP.withBasicAuth((String)"neo4j", (String)"test").POST(uri, ConnectionTrackingIT.query("CALL dbms.security.addRoleToUser(\\\"admin\\\", \\\"" + username + "\\\")"));
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response2.status());
    }

    private long createDummyNode() {
        try (Transaction transaction = this.db.beginTx();){
            long id;
            try (Result result = transaction.execute("CREATE (n:Dummy) RETURN id(n) AS i");){
                Map record = (Map)Iterators.single((Iterator)result);
                id = (Long)record.get("i");
            }
            transaction.commit();
            long l = id;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockNodeAndExecute(long id, ThrowingAction<Exception> action) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.getNodeById(id);
            Lock lock = tx.acquireWriteLock((Entity)node);
            try {
                action.apply();
            }
            finally {
                lock.release();
            }
            tx.rollback();
        }
    }

    private Future<HttpResponse<String>> updateNodeViaHttp(long id, String username, String password) {
        return this.updateNodeViaHttp(id, false, username, password);
    }

    private Future<HttpResponse<String>> updateNodeViaHttps(long id, String username, String password) {
        return this.updateNodeViaHttp(id, true, username, password);
    }

    private Future<HttpResponse<String>> updateNodeViaHttp(long id, boolean encrypted, String username, String password) {
        URI uri = this.txCommitUri(encrypted);
        String userAgent = encrypted ? TestConnector.HTTPS.userAgent : TestConnector.HTTP.userAgent;
        return this.executor.submit(() -> {
            HttpClient httpClient = HTTP.newClient();
            this.httpClients.add(httpClient);
            HttpRequest httpRequest = HttpRequest.newBuilder(uri).header("User-Agent", userAgent).header("Authorization", HTTP.basicAuthHeader((String)username, (String)password)).POST(HttpRequest.BodyPublishers.ofString(ConnectionTrackingIT.query("MATCH (n) WHERE id(n) = " + id + " SET n.prop = 42").get(), StandardCharsets.UTF_8)).build();
            return httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        });
    }

    private Future<Void> updateNodeViaBolt(long id, String username, String password) {
        return this.executor.submit(() -> {
            ConnectionTrackingIT connectionTrackingIT = this;
            this.connectSocketTo(this.neo4j.boltURI()).send(connectionTrackingIT.util.defaultAcceptedVersions()).send(this.auth(username, password)).send(this.util.defaultRunAutoCommitTx("MATCH (n) WHERE id(n) = " + id + " SET n.prop = 42"));
            return null;
        });
    }

    private void killAcceptedConnectionViaBolt() throws Exception {
        for (TrackedNetworkConnection connection : this.acceptedConnectionsFromConnectionTracker()) {
            this.killConnectionViaBolt(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killConnectionViaBolt(TrackedNetworkConnection trackedConnection) throws Exception {
        String id = trackedConnection.id();
        String user = trackedConnection.username();
        TransportConnection connection = this.connectSocketTo(this.neo4j.boltURI());
        try {
            ConnectionTrackingIT connectionTrackingIT = this;
            connection.send(connectionTrackingIT.util.defaultAcceptedVersions()).send(this.auth("neo4j", "test")).send(this.util.defaultRunAutoCommitTx("CALL dbms.killConnection('" + id + "')"));
            Assertions.assertThat((Object)connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
            Assertions.assertThat((Object)connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{new Condition(anyValue -> true, "any value", new Object[0]), new Condition(v -> v.equals((Object)Values.stringOrNoValue((String)user)), "user value", new Object[0]), new Condition(v -> v.equals((Object)Values.stringValue((String)"Connection found")), "connection", new Object[0])})), MessageConditions.msgSuccess()}));
        }
        finally {
            connection.disconnect();
        }
    }

    private static void assertConnectionBreaks(TransportConnection connection) throws TimeoutException {
        Predicates.await(() -> ConnectionTrackingIT.connectionIsBroken(connection), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private static boolean connectionIsBroken(TransportConnection connection) {
        try {
            connection.send(new byte[]{1});
            connection.recv(1);
            return false;
        }
        catch (SocketException e) {
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void terminateAllTransactions() {
        KernelTransactions kernelTransactions = (KernelTransactions)this.db.getDependencyResolver().resolveDependency(KernelTransactions.class);
        kernelTransactions.activeTransactions().forEach(h -> h.markForTermination((Status)Status.Transaction.Terminated));
    }

    private URI txCommitUri(boolean encrypted) {
        URI baseUri = encrypted ? this.neo4j.httpsURI() : this.neo4j.httpURI();
        return baseUri.resolve("db/neo4j/tx/commit");
    }

    private static HTTP.RawPayload query(String statement) {
        return HTTP.RawPayload.rawPayload((String)("{\"statements\":[{\"statement\":\"" + statement + "\"}]}"));
    }

    private byte[] auth(String username, String password) throws IOException {
        Map authToken = MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", username, "credentials", password, "user_agent", TestConnector.BOLT.userAgent});
        return this.util.defaultAuth(authToken);
    }

    static enum TestConnector {
        HTTP("http", "http-user-agent"),
        HTTPS("https", "https-user-agent"),
        BOLT("bolt", "bolt-user-agent");

        final String name;
        final String userAgent;

        private TestConnector(String name, String userAgent) {
            this.name = name;
            this.userAgent = userAgent;
        }
    }
}

