/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.server.helpers.WebContainerHelper;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;

class RedirectToBrowserTestIT
extends ExclusiveWebContainerTestBase {
    private static TestWebContainer webContainer;

    RedirectToBrowserTestIT() {
    }

    @BeforeAll
    static void startServer() throws Exception {
        webContainer = WebContainerHelper.createNonPersistentContainer();
    }

    @AfterAll
    static void stopServer() {
        if (webContainer != null) {
            webContainer.shutdown();
        }
    }

    @Test
    void shouldRedirectToBrowser() throws Exception {
        HttpResponse<Void> response = RedirectToBrowserTestIT.sendGetRequest("Accept", "text/html");
        Assertions.assertEquals((int)303, (int)response.statusCode());
        Assertions.assertEquals(List.of(webContainer.getBaseUri() + "browser/"), response.headers().allValues("Location"));
    }

    @Test
    void shouldRedirectToBrowserUsingXForwardedHeaders() throws Exception {
        HttpResponse<Void> response = RedirectToBrowserTestIT.sendGetRequest("Accept", "text/html", "X-Forwarded-Host", "foo.bar:8734", "X-Forwarded-Proto", "https");
        Assertions.assertEquals((int)303, (int)response.statusCode());
        Assertions.assertEquals(List.of("https://foo.bar:8734/browser/"), response.headers().allValues("Location"));
    }

    private static HttpResponse<Void> sendGetRequest(String ... headers) throws Exception {
        HttpRequest request = HttpRequest.newBuilder(webContainer.getBaseUri()).headers(headers).GET().build();
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build();
        return client.send(request, HttpResponse.BodyHandlers.discarding());
    }
}

