/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.upgrade;

import java.io.IOException;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.store.StoreAssertions;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.recordstorage.RecordStorageEngineFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_4;
import org.neo4j.kernel.impl.storemigration.IdGeneratorMigrator;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.kernel.impl.storemigration.LogsUpgrader;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.RecordStorageMigrator;
import org.neo4j.kernel.impl.storemigration.RecordStoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Monitors;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.migration.MigrationProgressMonitor;
import org.neo4j.storageengine.migration.SchemaIndexMigrator;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheSupportExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
public class StoreUpgraderInterruptionTestIT {
    private static final Config CONFIG = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (Object)"8m");
    private final BatchImporterFactory batchImporterFactory = BatchImporterFactory.withHighestPriority();
    @RegisterExtension
    static PageCacheSupportExtension pageCacheExtension = new PageCacheSupportExtension();
    @Inject
    private TestDirectory directory;
    @Inject
    private FileSystemAbstraction fs;
    private JobScheduler jobScheduler;
    private Neo4jLayout neo4jLayout;
    private RecordDatabaseLayout workingDatabaseLayout;
    private Path prepareDirectory;
    private LegacyTransactionLogsLocator legacyTransactionLogsLocator;
    private PageCache pageCache;
    private RecordFormats baselineFormat;
    private RecordFormats successorFormat;

    private static Stream<Arguments> versions() {
        return Stream.of(Arguments.of((Object[])new Object[]{StandardV3_4.STORE_VERSION}));
    }

    public void init(String version) {
        this.jobScheduler = new ThreadPoolJobScheduler();
        this.neo4jLayout = Neo4jLayout.of((Path)this.directory.homePath());
        this.workingDatabaseLayout = RecordDatabaseLayout.of((Neo4jLayout)this.neo4jLayout, (String)"neo4j");
        this.prepareDirectory = this.directory.directory("prepare");
        this.legacyTransactionLogsLocator = new LegacyTransactionLogsLocator(Config.defaults(), (DatabaseLayout)this.workingDatabaseLayout);
        this.pageCache = pageCacheExtension.getPageCache(this.fs);
        this.baselineFormat = RecordFormatSelector.selectForVersion((String)version);
        this.successorFormat = RecordFormatSelector.findLatestFormatInFamily((RecordFormats)this.baselineFormat).orElse(this.baselineFormat);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    public void shouldSucceedWithUpgradeAfterPreviousAttemptDiedDuringMigration(String version) throws IOException, ConsistencyCheckIncompleteException {
        this.init(version);
        MigrationTestUtils.prepareSampleLegacyDatabase((String)version, (FileSystemAbstraction)this.fs, (Path)this.workingDatabaseLayout.databaseDirectory(), (Path)this.prepareDirectory);
        RecordStoreVersionCheck versionCheck = new RecordStoreVersionCheck(this.fs, this.pageCache, this.workingDatabaseLayout, (LogProvider)NullLogProvider.getInstance(), Config.defaults(), PageCacheTracer.NULL);
        MigrationProgressMonitor progressMonitor = MigrationProgressMonitor.SILENT;
        NullLogService logService = NullLogService.getInstance();
        RecordStorageMigrator failingStoreMigrator = new RecordStorageMigrator(this.fs, this.pageCache, CONFIG, (LogService)logService, this.jobScheduler, PageCacheTracer.NULL, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE){

            public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progressReporter, String versionToMigrateFrom, String versionToMigrateTo, IndexImporterFactory indexImporterFactory) throws IOException, KernelException {
                super.migrate(directoryLayout, migrationLayout, progressReporter, versionToMigrateFrom, versionToMigrateTo, indexImporterFactory);
                throw new RuntimeException("This upgrade is failing");
            }
        };
        try {
            this.newUpgrader((StoreVersionCheck)versionCheck, progressMonitor, new StoreMigrationParticipant[]{this.createIndexMigrator(), failingStoreMigrator}).migrateIfNeeded((DatabaseLayout)this.workingDatabaseLayout, false);
            Assertions.fail((String)"Should throw exception");
        }
        catch (RuntimeException e) {
            Assertions.assertEquals((Object)"This upgrade is failing", (Object)e.getMessage());
        }
        Assertions.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasFormatVersion((StoreVersionCheck)versionCheck, (RecordFormats)this.baselineFormat));
        RecordStorageMigrator migrator = new RecordStorageMigrator(this.fs, this.pageCache, CONFIG, (LogService)logService, this.jobScheduler, PageCacheTracer.NULL, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        IdGeneratorMigrator idMigrator = new IdGeneratorMigrator(this.fs, this.pageCache, CONFIG, PageCacheTracer.NULL);
        SchemaIndexMigrator indexMigrator = this.createIndexMigrator();
        this.newUpgrader((StoreVersionCheck)versionCheck, progressMonitor, new StoreMigrationParticipant[]{indexMigrator, migrator, idMigrator}).migrateIfNeeded((DatabaseLayout)this.workingDatabaseLayout, false);
        Assertions.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasFormatVersion((StoreVersionCheck)versionCheck, (RecordFormats)this.successorFormat));
        StoreUpgraderInterruptionTestIT.startStopDatabase(this.neo4jLayout.homeDirectory());
        StoreAssertions.assertConsistentStore((DatabaseLayout)this.workingDatabaseLayout);
    }

    private SchemaIndexMigrator createIndexMigrator() {
        return new SchemaIndexMigrator("upgrade test indexes", this.fs, this.pageCache, IndexProvider.EMPTY.directoryStructure(), StorageEngineFactory.defaultStorageEngine(), true);
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    public void tracePageCacheAccessOnIdStoreUpgrade(String version) throws IOException, ConsistencyCheckIncompleteException {
        this.init(version);
        MigrationTestUtils.prepareSampleLegacyDatabase((String)version, (FileSystemAbstraction)this.fs, (Path)this.workingDatabaseLayout.databaseDirectory(), (Path)this.prepareDirectory);
        RecordStoreVersionCheck versionCheck = new RecordStoreVersionCheck(this.fs, this.pageCache, this.workingDatabaseLayout, (LogProvider)NullLogProvider.getInstance(), Config.defaults(), PageCacheTracer.NULL);
        MigrationProgressMonitor progressMonitor = MigrationProgressMonitor.SILENT;
        NullLogService logService = NullLogService.getInstance();
        DefaultPageCacheTracer idMigratorTracer = new DefaultPageCacheTracer();
        DefaultPageCacheTracer recordMigratorTracer = new DefaultPageCacheTracer();
        IdGeneratorMigrator idMigrator = new IdGeneratorMigrator(this.fs, this.pageCache, CONFIG, (PageCacheTracer)idMigratorTracer);
        Assertions.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasFormatVersion((StoreVersionCheck)versionCheck, (RecordFormats)this.baselineFormat));
        RecordStorageMigrator migrator = new RecordStorageMigrator(this.fs, this.pageCache, CONFIG, (LogService)logService, this.jobScheduler, (PageCacheTracer)recordMigratorTracer, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.newUpgrader((StoreVersionCheck)versionCheck, progressMonitor, new StoreMigrationParticipant[]{this.createIndexMigrator(), migrator, idMigrator}).migrateIfNeeded((DatabaseLayout)this.workingDatabaseLayout, false);
        Assertions.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasFormatVersion((StoreVersionCheck)versionCheck, (RecordFormats)this.successorFormat));
        StoreUpgraderInterruptionTestIT.startStopDatabase(this.neo4jLayout.homeDirectory());
        StoreAssertions.assertConsistentStore((DatabaseLayout)this.workingDatabaseLayout);
        Assertions.assertEquals((long)126L, (long)idMigratorTracer.pins());
        Assertions.assertEquals((long)126L, (long)idMigratorTracer.unpins());
        Assertions.assertEquals((long)231L, (long)recordMigratorTracer.pins());
        Assertions.assertEquals((long)231L, (long)recordMigratorTracer.unpins());
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    public void shouldSucceedWithUpgradeAfterPreviousAttemptDiedDuringMovingFiles(String version) throws IOException, ConsistencyCheckIncompleteException {
        this.init(version);
        MigrationTestUtils.prepareSampleLegacyDatabase((String)version, (FileSystemAbstraction)this.fs, (Path)this.workingDatabaseLayout.databaseDirectory(), (Path)this.prepareDirectory);
        RecordStoreVersionCheck versionCheck = new RecordStoreVersionCheck(this.fs, this.pageCache, this.workingDatabaseLayout, (LogProvider)NullLogProvider.getInstance(), Config.defaults(), PageCacheTracer.NULL);
        MigrationProgressMonitor progressMonitor = MigrationProgressMonitor.SILENT;
        NullLogService logService = NullLogService.getInstance();
        RecordStorageMigrator failingStoreMigrator = new RecordStorageMigrator(this.fs, this.pageCache, CONFIG, (LogService)logService, this.jobScheduler, PageCacheTracer.NULL, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE){

            public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToUpgradeFrom, String versionToMigrateTo) throws IOException {
                super.moveMigratedFiles(migrationLayout, directoryLayout, versionToUpgradeFrom, versionToMigrateTo);
                throw new RuntimeException("This upgrade is failing");
            }
        };
        IdGeneratorMigrator idMigrator = new IdGeneratorMigrator(this.fs, this.pageCache, CONFIG, PageCacheTracer.NULL);
        Assertions.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasFormatVersion((StoreVersionCheck)versionCheck, (RecordFormats)this.baselineFormat));
        try {
            this.newUpgrader((StoreVersionCheck)versionCheck, progressMonitor, new StoreMigrationParticipant[]{this.createIndexMigrator(), failingStoreMigrator, idMigrator}).migrateIfNeeded((DatabaseLayout)this.workingDatabaseLayout, false);
            Assertions.fail((String)"Should throw exception");
        }
        catch (RuntimeException e) {
            Assertions.assertEquals((Object)"This upgrade is failing", (Object)e.getMessage());
        }
        RecordStorageMigrator migrator = new RecordStorageMigrator(this.fs, this.pageCache, CONFIG, (LogService)logService, this.jobScheduler, PageCacheTracer.NULL, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.newUpgrader((StoreVersionCheck)versionCheck, progressMonitor, new StoreMigrationParticipant[]{this.createIndexMigrator(), migrator, idMigrator}).migrateIfNeeded((DatabaseLayout)this.workingDatabaseLayout, false);
        Assertions.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasFormatVersion((StoreVersionCheck)versionCheck, (RecordFormats)this.successorFormat));
        this.pageCache.close();
        StoreUpgraderInterruptionTestIT.startStopDatabase(this.neo4jLayout.homeDirectory());
        StoreAssertions.assertConsistentStore((DatabaseLayout)this.workingDatabaseLayout);
    }

    private StoreUpgrader newUpgrader(StoreVersionCheck versionCheck, MigrationProgressMonitor progressMonitor, StoreMigrationParticipant ... participants) {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.allow_upgrade, (Object)true);
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{new Monitors()});
        RecordStorageEngineFactory storageEngineFactory = new RecordStorageEngineFactory();
        DatabaseHealth databaseHealth = new DatabaseHealth(PanicEventGenerator.NO_OP, (Log)NullLog.getInstance());
        LogsUpgrader logsUpgrader = new LogsUpgrader(this.fs, (StorageEngineFactory)storageEngineFactory, (DatabaseLayout)this.workingDatabaseLayout, this.pageCache, this.legacyTransactionLogsLocator, config, (DependencyResolver)dependencies, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, databaseHealth);
        StoreUpgrader upgrader = new StoreUpgrader((StorageEngineFactory)storageEngineFactory, versionCheck, progressMonitor, config, this.fs, (LogProvider)NullLogProvider.getInstance(), logsUpgrader, PageCacheTracer.NULL);
        for (StoreMigrationParticipant participant : participants) {
            upgrader.addParticipant(participant);
        }
        return upgrader;
    }

    private static void startStopDatabase(Path storeDir) {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).setConfig(GraphDatabaseSettings.allow_upgrade, (Object)true).build();
        managementService.database("neo4j");
        managementService.shutdown();
    }
}

