/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.community.edition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseInfoService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
public class StandaloneDatabaseInfoServiceIT {
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService dbms;

    @BeforeEach
    void setUp() {
        this.dbms = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).build();
    }

    @AfterEach
    void tearDown() {
        this.dbms.shutdown();
    }

    @Test
    void shouldBeAvailableInDependencyResolver() {
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)this.dbms.database("neo4j")).getDependencyResolver();
        Assertions.assertTrue((boolean)dependencyResolver.containsDependency(DatabaseInfoService.class));
    }

    @Test
    void shouldReturnInfoForAllExistingDatabases() {
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)this.dbms.database("neo4j")).getDependencyResolver();
        DatabaseInfoService databaseInfoService = (DatabaseInfoService)dependencyResolver.resolveDependency(DatabaseInfoService.class);
        String nonExistingDatabase = "foo";
        List existingDatabases = this.dbms.listDatabases();
        HashSet<String> allDatabases = new HashSet<String>(existingDatabases);
        allDatabases.add(nonExistingDatabase);
        List results = databaseInfoService.lookupCachedInfo(allDatabases);
        Set returnedDatabases = results.stream().map(databaseInfo -> databaseInfo.namedDatabaseId().name()).collect(Collectors.toSet());
        AssertionsForClassTypes.assertThat((int)returnedDatabases.size()).isEqualTo(existingDatabases.size());
        Assertions.assertTrue((boolean)returnedDatabases.containsAll(existingDatabases));
    }
}

