/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.function.IntSupplier;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.pagecache.ConfigurableIOBufferFactory;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DelegatingFileSystemAbstraction;
import org.neo4j.io.fs.DelegatingStoreChannel;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.DelegatingPageSwapper;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheTest;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.CacheLiveLockException;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCacheFixture;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.DelegatingPageCacheTracer;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionEventOpportunity;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PageReferenceTranslator;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.recording.RecordingPageCacheTracer;
import org.neo4j.io.pagecache.tracing.recording.RecordingPageCursorTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;

public class MuninnPageCacheTest
extends PageCacheTest<MuninnPageCache> {
    private final long x = -3819410105021120785L;
    private final long y = -2392823106362282833L;
    private MuninnPageCacheFixture fixture;

    @Override
    protected PageCacheTestSupport.Fixture<MuninnPageCache> createFixture() {
        ConfigurableIOBufferFactory bufferFactory = new ConfigurableIOBufferFactory(Config.defaults((Setting)GraphDatabaseSettings.pagecache_buffered_flush_enabled, (Object)true), (MemoryTracker)new ScopedMemoryTracker((MemoryTracker)EmptyMemoryTracker.INSTANCE));
        this.fixture = new MuninnPageCacheFixture();
        this.fixture.withBufferFactory((IOBufferFactory)bufferFactory);
        return this.fixture;
    }

    private PageCacheTracer blockCacheFlush(PageCacheTracer delegate) {
        this.fixture.backgroundFlushLatch = new CountDownLatch(1);
        return new DelegatingPageCacheTracer(delegate){

            @Override
            public MajorFlushEvent beginCacheFlush() {
                try {
                    MuninnPageCacheTest.this.fixture.backgroundFlushLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return super.beginCacheFlush();
            }
        };
    }

    @Test
    void countPagesToEvictOnEmptyPageCache() {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());){
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(10));
        }
    }

    @Test
    void countPagesToEvictOnAllPagesLocked() throws IOException {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            for (int i = 0; i < maxPages; ++i) {
                pageCache.grabFreeAndExclusivelyLockedPage(PageFaultEvent.NULL);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)pageCache.tryGetNumberOfPagesToEvict(12));
        }
    }

    @Test
    void countPagesToEvictWhenLiveLocked() {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            org.junit.jupiter.api.Assertions.assertThrows(CacheLiveLockException.class, () -> {
                for (int i = 0; i < maxPages + 1; ++i) {
                    pageCache.grabFreeAndExclusivelyLockedPage(PageFaultEvent.NULL);
                }
            });
            org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)pageCache.tryGetNumberOfPagesToEvict(12));
            org.junit.jupiter.api.Assertions.assertEquals((int)1024, (int)pageCache.tryGetNumberOfPagesToEvict(1024));
        }
    }

    @Test
    void countPagesToEvictWithReleasedPages() throws IOException {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            long pageRef = pageCache.grabFreeAndExclusivelyLockedPage(PageFaultEvent.NULL);
            pageCache.addFreePageToFreelist(pageRef, EvictionRunEvent.NULL);
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(12));
        }
    }

    @Test
    void countPagesToEvictWithAllPagesAcquiredAndReleased() throws IOException {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            for (int i = 0; i < maxPages; ++i) {
                long pageRef = pageCache.grabFreeAndExclusivelyLockedPage(PageFaultEvent.NULL);
                pageCache.addFreePageToFreelist(pageRef, EvictionRunEvent.NULL);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(12));
        }
    }

    @Test
    void countPagesToEvictWithPagesAcquiredSomeReleased() throws IOException {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            int i;
            for (i = 0; i < maxPages - 20; ++i) {
                pageCache.grabFreeAndExclusivelyLockedPage(PageFaultEvent.NULL);
            }
            for (i = maxPages - 20; i < maxPages; ++i) {
                long page = pageCache.grabFreeAndExclusivelyLockedPage(PageFaultEvent.NULL);
                pageCache.addFreePageToFreelist(page, EvictionRunEvent.NULL);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(12));
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(20));
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)pageCache.tryGetNumberOfPagesToEvict(21));
        }
    }

    @Test
    void countPagesToEvictWithPagesAcquiredOneReleasedInLoop() throws IOException {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            int i;
            for (i = 0; i < maxPages - 5; ++i) {
                pageCache.grabFreeAndExclusivelyLockedPage(PageFaultEvent.NULL);
            }
            for (i = maxPages - 5; i < maxPages; ++i) {
                long page = pageCache.grabFreeAndExclusivelyLockedPage(PageFaultEvent.NULL);
                pageCache.addFreePageToFreelist(page, EvictionRunEvent.NULL);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)pageCache.tryGetNumberOfPagesToEvict(12));
            org.junit.jupiter.api.Assertions.assertEquals((int)(maxPages - 5), (int)pageCache.tryGetNumberOfPagesToEvict(maxPages));
        }
    }

    @Test
    void countPagesToEvictWithAllPagesAcquiredAndReleasedLater() throws IOException {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            MutableLongList pages = LongLists.mutable.withInitialCapacity(maxPages);
            for (int i = 0; i < maxPages; ++i) {
                pages.add(pageCache.grabFreeAndExclusivelyLockedPage(PageFaultEvent.NULL));
            }
            pages.forEach((LongProcedure & Serializable)page -> pageCache.addFreePageToFreelist(page, EvictionRunEvent.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(12));
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(maxPages));
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)pageCache.tryGetNumberOfPagesToEvict(maxPages + 1));
        }
    }

    @Test
    void countPagesToEvictWithAllWithExceptionPagesAcquiredAndReleased() {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            MutableLongList pages = LongLists.mutable.withInitialCapacity(maxPages);
            org.junit.jupiter.api.Assertions.assertThrows(CacheLiveLockException.class, () -> {
                for (int i = 0; i <= maxPages; ++i) {
                    pages.add(pageCache.grabFreeAndExclusivelyLockedPage(PageFaultEvent.NULL));
                }
            });
            pages.forEach((LongProcedure & Serializable)page -> pageCache.addFreePageToFreelist(page, EvictionRunEvent.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(12));
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(maxPages));
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)pageCache.tryGetNumberOfPagesToEvict(maxPages + 1));
        }
    }

    @Test
    void reuseSwapperIdOnFileClose() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 50, (PageCacheTracer)new DefaultPageCacheTracer());){
            int swapperId = this.pagedFileSwapperId(pageCache);
            for (int i = 0; i < 10; ++i) {
                org.junit.jupiter.api.Assertions.assertEquals((int)swapperId, (int)this.pagedFileSwapperId(pageCache));
            }
        }
    }

    @Test
    void doNotReuseSwapperIdWhenThereAreOpenCursors() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 50, (PageCacheTracer)new DefaultPageCacheTracer());){
            MutableIntSet swapperIds = IntSets.mutable.empty();
            ArrayList<Object> cursorWithIds = new ArrayList<Object>();
            SwapperSet swapperSet = this.extractSwapperSet(pageCache);
            while (!swapperSet.skipSweep()) {
                CursorSwapperId cursorSwapperId = this.pagedFileCursorSwapperId(pageCache);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)swapperIds.add(cursorSwapperId.cursorId), (String)"swapper id with open cursors should not be reused");
                cursorWithIds.add(cursorSwapperId);
            }
            for (CursorSwapperId cursorSwapperId : cursorWithIds) {
                cursorSwapperId.pageCursor.close();
            }
            MutableIntSet sweeppedIds = IntSets.mutable.empty();
            swapperSet.sweep(arg_0 -> ((MutableIntSet)sweeppedIds).addAll(arg_0));
            for (CursorSwapperId cursorSwapperId : cursorWithIds) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)swapperIds.contains(cursorSwapperId.cursorId));
            }
        }
    }

    @Test
    void evaluateNumberOfPagesToKeepFree() {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, (PageCacheTracer)new DefaultPageCacheTracer());){
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)pageCache.getKeepFree());
        }
        pageCache = (MuninnPageCache)this.createPageCache(this.fs, 30, (PageCacheTracer)new DefaultPageCacheTracer());
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)15, (int)pageCache.getKeepFree());
        }
        finally {
            if (pageCache != null) {
                pageCache.close();
            }
        }
        pageCache = (MuninnPageCache)this.createPageCache(this.fs, 50, (PageCacheTracer)new DefaultPageCacheTracer());
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)25, (int)pageCache.getKeepFree());
        }
        finally {
            if (pageCache != null) {
                pageCache.close();
            }
        }
        pageCache = (MuninnPageCache)this.createPageCache(this.fs, 100, (PageCacheTracer)new DefaultPageCacheTracer());
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)30, (int)pageCache.getKeepFree());
        }
        finally {
            if (pageCache != null) {
                pageCache.close();
            }
        }
        pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10000, (PageCacheTracer)new DefaultPageCacheTracer());
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)500, (int)pageCache.getKeepFree());
        }
        finally {
            if (pageCache != null) {
                pageCache.close();
            }
        }
    }

    @Test
    void countOpenedAndClosedCursors() throws IOException {
        DefaultPageCacheTracer defaultPageCacheTracer = new DefaultPageCacheTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 42, (PageCacheTracer)defaultPageCacheTracer);){
            int iterations = 14;
            for (int i = 0; i < iterations; ++i) {
                this.writeInitialDataTo(this.file("a" + i));
                try (CursorContext cursorContext = new CursorContext(defaultPageCacheTracer.createPageCursorTracer("countOpenedAndClosedCursors"));
                     PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a" + i), 8);){
                    try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 3 + 1), (long)defaultPageCacheTracer.openedCursors());
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 3), (long)defaultPageCacheTracer.closedCursors());
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                        cursor.putLong(0L);
                    }
                    cursor = pagedFile.io(0L, 2, cursorContext);
                    try {
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 3 + 2), (long)defaultPageCacheTracer.openedCursors());
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 3 + 1), (long)defaultPageCacheTracer.closedCursors());
                    }
                    finally {
                        if (cursor != null) {
                            cursor.close();
                        }
                    }
                    cursor = pagedFile.io(0L, 2, cursorContext);
                    try {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 3 + 3), (long)defaultPageCacheTracer.openedCursors());
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 3 + 2), (long)defaultPageCacheTracer.closedCursors());
                    }
                    finally {
                        if (cursor != null) {
                            cursor.close();
                        }
                    }
                    pagedFile.setDeleteOnClose(true);
                    continue;
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)(iterations * 3), (long)defaultPageCacheTracer.openedCursors());
            org.junit.jupiter.api.Assertions.assertEquals((long)(iterations * 3), (long)defaultPageCacheTracer.closedCursors());
        }
    }

    @Test
    void shouldBeAbleToSetDeleteOnCloseFileAfterItWasMapped() throws IOException {
        DefaultPageCacheTracer defaultPageCacheTracer = new DefaultPageCacheTracer();
        Path fileForDeletion = this.file("fileForDeletion");
        this.writeInitialDataTo(fileForDeletion);
        long initialFlushes = defaultPageCacheTracer.flushes();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, (PageCacheTracer)defaultPageCacheTracer);){
            try (CursorContext cursorContext = new CursorContext(defaultPageCacheTracer.createPageCursorTracer("shouldBeAbleToSetDeleteOnCloseFileAfterItWasMapped"));
                 PagedFile pagedFile = this.map((PageCache)pageCache, fileForDeletion, 8);){
                try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(0L);
                }
                pagedFile.setDeleteOnClose(true);
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fs.fileExists(fileForDeletion));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)(defaultPageCacheTracer.flushes() - initialFlushes));
        }
    }

    @Test
    void ableToEvictAllPageInAPageCache() throws IOException {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorContext = new RecordingPageCursorTracer(tracer, "ableToEvictAllPageInAPageCache");
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);
             CursorContext context = new CursorContext((PageCursorTracer)cursorContext);){
            try (PageCursor cursor = pagedFile.io(0L, 1, context);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
            cursor = pagedFile.io(1L, 1, context);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            MuninnPageCacheTest.evictAllPages(pageCache);
        }
    }

    @Test
    void mustEvictCleanPageWithoutFlushing() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorContext = new RecordingPageCursorTracer(tracer, "mustEvictCleanPageWithoutFlushing");
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            try (PageCursor cursor = pagedFile.io(0L, 1, new CursorContext((PageCursorTracer)cursorContext));){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
            cursorContext.reportEvents();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)cursorContext.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)cursorContext.faults());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(1, 1, tracer.beginPageEvictions(1));
            Assertions.assertThat((long)clockArm).isEqualTo(1L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
        }
    }

    @Test
    void mustFlushDirtyPagesOnEvictingFirstPage() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorContext = new RecordingPageCursorTracer(tracer, "mustFlushDirtyPagesOnEvictingFirstPage");
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            try (PageCursor cursor = pagedFile.io(0L, 2, new CursorContext((PageCursorTracer)cursorContext));){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
            }
            cursorContext.reportEvents();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)cursorContext.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)cursorContext.faults());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(1, 0, tracer.beginPageEvictions(1));
            Assertions.assertThat((long)clockArm).isEqualTo(1L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            ByteBuffer buf = this.readIntoBuffer("a");
            Assertions.assertThat((long)buf.getLong()).isEqualTo(0L);
            Assertions.assertThat((long)buf.getLong()).isEqualTo(-2392823106362282833L);
        }
    }

    @Test
    void mustFlushDirtyPagesOnEvictingLastPage() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorContext = new RecordingPageCursorTracer(tracer, "mustFlushDirtyPagesOnEvictingLastPage");
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            try (PageCursor cursor = pagedFile.io(1L, 2, new CursorContext((PageCursorTracer)cursorContext));){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
            }
            cursorContext.reportEvents();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)cursorContext.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)cursorContext.faults());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(1, 0, tracer.beginPageEvictions(1));
            Assertions.assertThat((long)clockArm).isEqualTo(1L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            ByteBuffer buf = this.readIntoBuffer("a");
            Assertions.assertThat((long)buf.getLong()).isEqualTo(-3819410105021120785L);
            Assertions.assertThat((long)buf.getLong()).isEqualTo(0L);
        }
    }

    @Test
    void finishPinEventWhenOpenedWithNoFaultOption() throws IOException {
        this.writeInitialDataTo(this.file("a"));
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer(true);
        PageCursorTracer pageCursorTracer = cacheTracer.createPageCursorTracer("finishPinEventWhenOpenedWithNoFaultOption");
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, (PageCacheTracer)cacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            CursorContext cursorContext = new CursorContext(pageCursorTracer);
            try (PageCursor cursor = pagedFile.io(0L, 17, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)cursorContext.getCursorTracer().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)cursorContext.getCursorTracer().unpins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFile.pageFileCounters().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFile.pageFileCounters().unpins());
        }
    }

    @Test
    void finishPinEventReportedPerFile() throws IOException {
        this.writeInitialDataTo(this.file("a"));
        this.writeInitialDataTo(this.file("b"));
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer(true);
        PageCursorTracer pageCursorTracer = cacheTracer.createPageCursorTracer("finishPinEventReportedPerFile");
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, (PageCacheTracer)cacheTracer);
             PagedFile pagedFileA = this.map((PageCache)pageCache, this.file("a"), 8);
             PagedFile pagedFileB = this.map((PageCache)pageCache, this.file("b"), 8);){
            CursorContext cursorContext = new CursorContext(pageCursorTracer);
            try (PageCursor cursor = pagedFileA.io(0L, 17, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            cursor = pagedFileB.io(0L, 17, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)cursorContext.getCursorTracer().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)cursorContext.getCursorTracer().unpins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFileA.pageFileCounters().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFileA.pageFileCounters().unpins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFileB.pageFileCounters().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFileB.pageFileCounters().unpins());
        }
    }

    @Test
    void mustFlushDirtyPagesOnEvictingAllPages() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorContext = new RecordingPageCursorTracer(tracer, "mustFlushDirtyPagesOnEvictingAllPages", RecordingPageCursorTracer.Fault.class);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            try (PageCursor cursor = pagedFile.io(0L, 6, new CursorContext((PageCursorTracer)cursorContext));){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            cursorContext.reportEvents();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)cursorContext.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)cursorContext.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)cursorContext.faults());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(2, 0, tracer.beginPageEvictions(2));
            Assertions.assertThat((long)clockArm).isEqualTo(2L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            ByteBuffer buf = this.readIntoBuffer("a");
            Assertions.assertThat((long)buf.getLong()).isEqualTo(0L);
            Assertions.assertThat((long)buf.getLong()).isEqualTo(0L);
        }
    }

    @Test
    void trackPageModificationTransactionId() throws Exception {
        TestVersionContext versionContext = new TestVersionContext(() -> 0);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);
             CursorContext cursorContext = new CursorContext(PageCursorTracer.NULL, (VersionContext)versionContext);){
            versionContext.initWrite(7L);
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(0L, 1, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                org.junit.jupiter.api.Assertions.assertEquals((long)7L, (long)PageList.getLastModifiedTxId((long)pageCursor.pinnedPageRef));
                org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)cursor.getLong());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void reportFreeListSizeToTracers() throws IOException {
        InfoTracer pageCacheTracer = new InfoTracer();
        int maxPages = 40;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 5; ++pageId) {
                CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer("test"));
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, cursorContext);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                }
                org.junit.jupiter.api.Assertions.assertEquals((int)(maxPages - (pageId + 1)), (int)pageCacheTracer.getFreeListSize());
            }
            pagedFile.flushAndForce();
        }
    }

    @Test
    void countNotModifiedPagesPerChunkWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getNotModifiedPages()).isEqualTo(0L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getNotModifiedPages()).isEqualTo(2L);
        }
    }

    @Test
    void flushFileWithSeveralChunks() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        int maxPages = 4346;
        int dirtyPages = 4106;
        MultiChunkSwapperFilePageSwapperFactory swapperFactory = new MultiChunkSwapperFilePageSwapperFactory((PageCacheTracer)pageCacheTracer);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache((PageSwapperFactory)swapperFactory, maxPages, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < dirtyPages; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(2);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getFlushPerChunk()).isGreaterThanOrEqualTo((long)(dirtyPages / (Integer)GraphDatabaseSettings.pagecache_flush_buffer_size_in_pages.defaultValue()));
            InfoTracer.ChunkInfo chunkInfo2 = observedChunks.get(1);
            Assertions.assertThat((long)chunkInfo2.getFlushPerChunk()).isGreaterThanOrEqualTo(1L);
            observedChunks.clear();
        }
    }

    @Test
    void countNotModifiedPagesPerChunkWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getNotModifiedPages()).isEqualTo(0L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getNotModifiedPages()).isEqualTo(1L);
        }
    }

    @Test
    void countFlushesPerChunkWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getFlushPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getFlushPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getFlushPerChunk()).isEqualTo(2L);
        }
    }

    @Test
    void countFlushesPerChunkWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getFlushPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getFlushPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getFlushPerChunk()).isEqualTo(1L);
        }
    }

    @Test
    void countMergesPerChunkWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getMergesPerChunk()).isEqualTo(3L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getMergesPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getMergesPerChunk()).isEqualTo(0L);
        }
    }

    @Test
    void countMergesPerChunkWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getMergesPerChunk()).isEqualTo(0L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getMergesPerChunk()).isEqualTo(0L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getMergesPerChunk()).isEqualTo(0L);
        }
    }

    @Test
    void countUsedBuffersPerChunkWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getBuffersPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getBuffersPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getBuffersPerChunk()).isEqualTo(2L);
        }
    }

    @Test
    void usedBuffersPerChunkIsAlwaysOneWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getBuffersPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getBuffersPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getBuffersPerChunk()).isEqualTo(1L);
        }
    }

    @Test
    void flushSequentialPagesOnPageFileFlushWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer(true);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pageCacheTracer.flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pageCacheTracer.merges());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFile.pageFileCounters().flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pagedFile.pageFileCounters().merges());
        }
    }

    @Test
    void flushSequentialPagesOnPageFileFlushWithNoBuffersWithMultipleFiles() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        this.writeInitialDataTo(this.file("a"));
        this.writeInitialDataTo(this.file("b"));
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer(true);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFileA = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));
             PagedFile pagedFileB = this.map((PageCache)pageCache, this.file("b"), (int)ByteUnit.kibiBytes((long)8L));){
            try (PageCursor cursor = pagedFileA.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFileA.io(2L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFileA.flushAndForce();
            cursor = pagedFileB.io(1L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFileB.flushAndForce();
            org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)pageCacheTracer.flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pageCacheTracer.merges());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFileA.pageFileCounters().flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pagedFileA.pageFileCounters().merges());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pagedFileB.pageFileCounters().flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pagedFileB.pageFileCounters().merges());
        }
    }

    @Test
    void flushSequentialPagesOnPageFileFlushWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer(true);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pageCacheTracer.flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pageCacheTracer.merges());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFile.pageFileCounters().flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pagedFile.pageFileCounters().merges());
        }
    }

    @Test
    void doNotMergeNonSequentialPageBuffersOnPageFileFlush() throws IOException {
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer(true);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 6, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pageCacheTracer.flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pageCacheTracer.merges());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFile.pageFileCounters().flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pagedFile.pageFileCounters().merges());
        }
    }

    @Test
    void pageModificationTrackingNoticeWriteFromAnotherThread() throws Exception {
        TestVersionContext versionContext = new TestVersionContext(() -> 0);
        CursorContext cursorContext = new CursorContext(PageCursorTracer.NULL, (VersionContext)versionContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            versionContext.initWrite(7L);
            Future<?> future = executor.submit(() -> {
                try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            future.get();
            try (PageCursor cursor = pagedFile.io(0L, 1, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                org.junit.jupiter.api.Assertions.assertEquals((long)7L, (long)PageList.getLastModifiedTxId((long)pageCursor.pinnedPageRef));
                org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)cursor.getLong());
            }
        }
    }

    @Test
    void pageModificationTracksHighestModifierTransactionId() throws IOException {
        TestVersionContext versionContext = new TestVersionContext(() -> 0);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);
             CursorContext cursorContext = new CursorContext(PageCursorTracer.NULL, (VersionContext)versionContext);){
            versionContext.initWrite(1L);
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            versionContext.initWrite(12L);
            cursor = pagedFile.io(0L, 2, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(2L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            versionContext.initWrite(7L);
            cursor = pagedFile.io(0L, 2, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = pagedFile.io(0L, 1, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                org.junit.jupiter.api.Assertions.assertEquals((long)12L, (long)PageList.getLastModifiedTxId((long)pageCursor.pinnedPageRef));
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void markCursorContextDirtyWhenRepositionCursorOnItsCurrentPage() throws IOException {
        TestVersionContext versionContext = new TestVersionContext(() -> 3);
        CursorContext cursorContext = new CursorContext(PageCursorTracer.NULL, (VersionContext)versionContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            versionContext.initRead();
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(0L));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)versionContext.isDirty());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                PageList.setLastModifiedTxId((long)((MuninnPageCursor)cursor).pinnedPageRef, (long)17L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(0L));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)versionContext.isDirty());
            }
        }
    }

    @Test
    void markCursorContextAsDirtyWhenReadingDataFromMoreRecentTransactions() throws IOException {
        TestVersionContext versionContext = new TestVersionContext(() -> 3);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);
             CursorContext cursorContext = new CursorContext(PageCursorTracer.NULL, (VersionContext)versionContext);){
            versionContext.initWrite(7L);
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            versionContext.initRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)versionContext.isDirty());
            cursor = pagedFile.io(0L, 1, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)versionContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void doNotMarkCursorContextAsDirtyWhenReadingDataFromOlderTransactions() throws IOException {
        TestVersionContext versionContext = new TestVersionContext(() -> 23);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);
             CursorContext cursorContext = new CursorContext(PageCursorTracer.NULL, (VersionContext)versionContext);){
            versionContext.initWrite(17L);
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            versionContext.initRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)versionContext.isDirty());
            cursor = pagedFile.io(0L, 1, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)versionContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void markContextAsDirtyWhenAnyEvictedPageHaveModificationTransactionHigherThenReader() throws IOException {
        TestVersionContext versionContext = new TestVersionContext(() -> 5);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);
             CursorContext cursorContext = new CursorContext(PageCursorTracer.NULL, (VersionContext)versionContext);){
            versionContext.initWrite(3L);
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            versionContext.initWrite(13L);
            cursor = pagedFile.io(1L, 2, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(4L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            MuninnPageCacheTest.evictAllPages(pageCache);
            versionContext.initRead();
            cursor = pagedFile.io(0L, 1, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)versionContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void doNotMarkContextAsDirtyWhenAnyEvictedPageHaveModificationTransactionLowerThenReader() throws IOException {
        TestVersionContext versionContext = new TestVersionContext(() -> 15);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);
             CursorContext cursorContext = new CursorContext(PageCursorTracer.NULL, (VersionContext)versionContext);){
            versionContext.initWrite(3L);
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            versionContext.initWrite(13L);
            cursor = pagedFile.io(1L, 2, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(4L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            MuninnPageCacheTest.evictAllPages(pageCache);
            versionContext.initRead();
            cursor = pagedFile.io(0L, 1, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)versionContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void closingTheCursorMustUnlockModifiedPage() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            Future<?> task = executor.submit(() -> {
                try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(41L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            task.get();
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                long value = cursor.getLong();
                cursor.setOffset(0);
                cursor.putLong(value + 1L);
            }
            long clockArm = pageCache.evictPages(1, 0, EvictionRunEvent.NULL);
            Assertions.assertThat((long)clockArm).isEqualTo(1L);
            ByteBuffer buf = this.readIntoBuffer("a");
            Assertions.assertThat((long)buf.getLong()).isEqualTo(42L);
            Assertions.assertThat((long)buf.getLong()).isEqualTo(-2392823106362282833L);
        }
    }

    @Test
    void mustUnblockPageFaultersWhenEvictionGetsException() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.writeInitialDataTo(this.file("a"));
            final MutableBoolean throwException = new MutableBoolean(true);
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

                public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
                    return new DelegatingStoreChannel(super.open(fileName, options)){

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            if (throwException.booleanValue()) {
                                throw new IOException("uh-oh...");
                            }
                            super.writeAll(src, position);
                        }
                    };
                }
            };
            try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache((FileSystemAbstraction)fs, 2, PageCacheTracer.NULL);
                 PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
                try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                    for (int i = 0; i < 1000; ++i) {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    }
                    org.junit.jupiter.api.Assertions.fail((String)"Expected an exception at this point");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throwException.setFalse();
            }
        });
    }

    @Test
    void pageCacheFlushAndForceMustClearBackgroundEvictionException() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            final MutableBoolean throwException = new MutableBoolean(true);
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

                public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
                    return new DelegatingStoreChannel(super.open(fileName, options)){

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            if (throwException.booleanValue()) {
                                throw new IOException("uh-oh...");
                            }
                            super.writeAll(src, position);
                        }
                    };
                }
            };
            try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache((FileSystemAbstraction)fs, 10, PageCacheTracer.NULL);
                 PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
                try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                }
                pageCache.evictPages(1, 0, EvictionRunEvent.NULL);
                throwException.setFalse();
                pageCache.flushAndForce();
                cursor = pagedFile.io(0L, 2, CursorContext.NULL);
                try {
                    for (int i = 0; i < this.maxPages * 20; ++i) {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void mustThrowIfMappingFileWouldOverflowReferenceCount() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            Path file = this.file("a");
            this.writeInitialDataTo(file);
            try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 30, PageCacheTracer.NULL);){
                int i;
                PagedFile pf = null;
                try {
                    for (i = 0; i < Integer.MAX_VALUE; ++i) {
                        pf = this.map((PageCache)pageCache, file, this.filePageSize);
                    }
                    org.junit.jupiter.api.Assertions.fail((String)"Failure was expected");
                }
                catch (IllegalStateException j) {
                    for (int j2 = 0; j2 < i; ++j2) {
                        try {
                            pf.close();
                            continue;
                        }
                        catch (Exception e) {
                            throw new AssertionError("Did not expect pf.close() to throw", e);
                        }
                    }
                }
                finally {
                    for (int j = 0; j < i; ++j) {
                        try {
                            pf.close();
                            continue;
                        }
                        catch (Exception e) {
                            throw new AssertionError("Did not expect pf.close() to throw", e);
                        }
                    }
                }
            }
        });
    }

    @Test
    void unlimitedShouldFlushInParallel() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            ArrayList<Path> mappedFiles = new ArrayList<Path>();
            mappedFiles.add(this.existingFile("a"));
            mappedFiles.add(this.existingFile("b"));
            this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)new FlushRendezvousTracer(mappedFiles.size()));
            ArrayList<PagedFile> mappedPagedFiles = new ArrayList<PagedFile>();
            for (Path mappedFile : mappedFiles) {
                PagedFile pagedFile = this.map(this.pageCache, mappedFile, this.filePageSize);
                mappedPagedFiles.add(pagedFile);
                PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putInt(1);
                }
                finally {
                    if (cursor == null) continue;
                    cursor.close();
                }
            }
            ((MuninnPageCache)this.pageCache).flushAndForce();
            IOUtils.closeAll(mappedPagedFiles);
        });
    }

    @Test
    void transientCursorShouldNotUpdateUsageCounter() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            PageList pages = pageCache.pages;
            long zeroPageRef = pages.deref(0);
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)PageList.getUsage((long)zeroPageRef)).isEqualTo(1L);
            }
            cursor = pagedFile.io(0L, 1, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)PageList.getUsage((long)zeroPageRef)).isEqualTo(2L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = pagedFile.io(0L, 34, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)PageList.getUsage((long)zeroPageRef)).isEqualTo(2L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = pagedFile.io(0L, 33, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)PageList.getUsage((long)zeroPageRef)).isEqualTo(2L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void shouldDealWithOutOfBoundsWithRetries() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());){
            Path file = this.existingFile("a");
            this.writeInitialDataTo(file);
            try (PagedFile pagedFile = this.map((PageCache)pageCache, file, 8);
                 PageCursor readCursor = pagedFile.io(0L, 1, CursorContext.NULL);){
                Assertions.assertThat((boolean)readCursor.next(0L)).isTrue();
                readCursor.setOffset(-256);
                boolean first = true;
                readCursor.mark();
                do {
                    readCursor.setOffsetToMark();
                    readCursor.getLong();
                    if (!first) continue;
                    try (PageCursor writeCursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                        writeCursor.next(0L);
                        writeCursor.putLong(1L);
                    }
                    first = false;
                } while (readCursor.shouldRetry());
                Assertions.assertThat((boolean)readCursor.checkAndClearBoundsFlag()).isTrue();
            }
        }
    }

    private static void evictAllPages(MuninnPageCache pageCache) throws IOException {
        long pageReference;
        int pageId;
        PageList pages = pageCache.pages;
        for (pageId = 0; pageId < pages.getPageCount(); ++pageId) {
            pageReference = pages.deref(pageId);
            while (PageList.isLoaded((long)pageReference)) {
                pages.tryEvict(pageReference, (EvictionEventOpportunity)EvictionRunEvent.NULL);
            }
        }
        for (pageId = 0; pageId < pages.getPageCount(); ++pageId) {
            pageReference = pages.deref(pageId);
            pageCache.addFreePageToFreelist(pageReference, EvictionRunEvent.NULL);
        }
    }

    private void writeInitialDataTo(Path path) throws IOException {
        try (StoreChannel channel = this.fs.write(path);){
            ByteBuffer buf = ByteBuffers.allocate((int)16, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            buf.putLong(-3819410105021120785L);
            buf.putLong(-2392823106362282833L);
            buf.flip();
            channel.writeAll(buf);
        }
    }

    private int pagedFileSwapperId(MuninnPageCache pageCache) throws IOException {
        try (MuninnPagedFile pagedFile = (MuninnPagedFile)this.map((PageCache)pageCache, this.file("a"), 8);){
            int n = pagedFile.swapperId;
            return n;
        }
    }

    private CursorSwapperId pagedFileCursorSwapperId(MuninnPageCache pageCache) throws IOException {
        try (MuninnPagedFile pagedFile = (MuninnPagedFile)this.map((PageCache)pageCache, this.file("a"), 8);){
            PageCursor pageCursor = pagedFile.io(0L, 2, CursorContext.NULL);
            pageCursor.next();
            CursorSwapperId cursorSwapperId = new CursorSwapperId(pageCursor, pagedFile.swapperId);
            return cursorSwapperId;
        }
    }

    private ByteBuffer readIntoBuffer(String fileName) throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate((int)16, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (StoreChannel channel = this.fs.read(this.file(fileName));){
            channel.readAll(buffer);
        }
        buffer.flip();
        return buffer;
    }

    private SwapperSet extractSwapperSet(MuninnPageCache pageCache) throws IOException {
        try (MuninnPagedFile pagedFile = (MuninnPagedFile)this.map((PageCache)pageCache, this.file("a"), 8);){
            SwapperSet swapperSet = pagedFile.getSwappers();
            return swapperSet;
        }
    }

    private class MultiChunkSwapperFilePageSwapperFactory
    extends SingleFilePageSwapperFactory {
        MultiChunkSwapperFilePageSwapperFactory(PageCacheTracer pageCacheTracer) {
            super(MuninnPageCacheTest.this.fs, pageCacheTracer);
        }

        public PageSwapper createPageSwapper(Path file, final int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist, boolean useDirectIO, boolean preallocateStoreFiles, IOController ioController, SwapperSet swappers) throws IOException {
            return new DelegatingPageSwapper(super.createPageSwapper(file, filePageSize, onEviction, createIfNotExist, useDirectIO, preallocateStoreFiles, ioController, swappers)){

                public long write(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length, int totalAffectedPages) throws IOException {
                    int flushedDataSize = 0;
                    for (int i = 0; i < length; ++i) {
                        flushedDataSize += bufferLengths[i];
                    }
                    ((AbstractIntegerAssert)Assertions.assertThat((int)(totalAffectedPages * filePageSize)).describedAs("Number of affected pages multiplied by page size should be equal to size of buffers we want to flush", new Object[0])).isEqualTo(flushedDataSize);
                    return super.write(startFilePageId, bufferAddresses, bufferLengths, length, totalAffectedPages);
                }
            };
        }
    }

    private static class InfoTracer
    extends DefaultPageCacheTracer {
        private final CopyOnWriteArrayList<ChunkInfo> observedChunks = new CopyOnWriteArrayList();
        private volatile int freeListSize;

        private InfoTracer() {
        }

        public CopyOnWriteArrayList<ChunkInfo> getObservedChunks() {
            return this.observedChunks;
        }

        public int getFreeListSize() {
            return this.freeListSize;
        }

        public PageCursorTracer createPageCursorTracer(String tag) {
            return new InfoPageCursorTracer((PageCacheTracer)this, tag);
        }

        public MajorFlushEvent beginFileFlush(PageSwapper swapper) {
            return new FlushInfoMajorFlushEvent();
        }

        private static class ChunkInfo {
            private final long notModifiedPages;
            private final long flushPerChunk;
            private final long buffersPerChunk;
            private final long mergesPerChunk;

            public long getNotModifiedPages() {
                return this.notModifiedPages;
            }

            public long getFlushPerChunk() {
                return this.flushPerChunk;
            }

            public long getBuffersPerChunk() {
                return this.buffersPerChunk;
            }

            public long getMergesPerChunk() {
                return this.mergesPerChunk;
            }

            ChunkInfo(long notModifiedPages, long flushPerChunk, long buffersPerChunk, long mergesPerChunk) {
                this.notModifiedPages = notModifiedPages;
                this.flushPerChunk = flushPerChunk;
                this.buffersPerChunk = buffersPerChunk;
                this.mergesPerChunk = mergesPerChunk;
            }
        }

        private class FlushInfoChunk
        extends MajorFlushEvent.ChunkEvent {
            private FlushInfoChunk() {
            }

            public void chunkFlushed(long notModifiedPages, long flushPerChunk, long buffersPerChunk, long mergesPerChunk) {
                ChunkInfo chunkInfo = new ChunkInfo(notModifiedPages, flushPerChunk, buffersPerChunk, mergesPerChunk);
                InfoTracer.this.observedChunks.add(chunkInfo);
            }
        }

        private class FlushInfoMajorFlushEvent
        implements MajorFlushEvent {
            private FlushInfoMajorFlushEvent() {
            }

            public void close() {
            }

            public FlushEvent beginFlush(long[] pageRefs, PageSwapper swapper, PageReferenceTranslator pageReferenceTranslator, int pagesToFlush, int mergedPages) {
                return FlushEvent.NULL;
            }

            public FlushEvent beginFlush(long pageRef, PageSwapper swapper, PageReferenceTranslator pageReferenceTranslator) {
                return FlushEvent.NULL;
            }

            public void startFlush(int[][] translationTable) {
            }

            public MajorFlushEvent.ChunkEvent startChunk(int[] chunk) {
                return new FlushInfoChunk();
            }

            public void throttle(long millis) {
            }

            public void reportIO(int completedIOs) {
            }
        }

        private class InfoPageCursorTracer
        extends DefaultPageCursorTracer {
            InfoPageCursorTracer(PageCacheTracer pageCacheTracer, String tag) {
                super(pageCacheTracer, tag);
            }

            public PinEvent beginPin(boolean writeLock, long filePageId, PageSwapper swapper) {
                return new PinEvent(){

                    public void setCachePageId(long cachePageId) {
                    }

                    public PageFaultEvent beginPageFault(long filePageId, PageSwapper swapper) {
                        return new PageFaultEvent(){

                            public void addBytesRead(long bytes) {
                            }

                            public void setCachePageId(long cachePageId) {
                            }

                            public void done() {
                            }

                            public void fail(Throwable throwable) {
                            }

                            public void freeListSize(int listSize) {
                                InfoTracer.this.freeListSize = listSize;
                            }

                            public EvictionEvent beginEviction(long cachePageId) {
                                return null;
                            }
                        };
                    }

                    public void hit() {
                    }

                    public void done() {
                    }
                };
            }
        }
    }

    private static class TestVersionContext
    implements VersionContext {
        private final IntSupplier closedTxIdSupplier;
        private long committingTxId;
        private long lastClosedTxId;
        private boolean dirty;

        TestVersionContext(IntSupplier closedTxIdSupplier) {
            this.closedTxIdSupplier = closedTxIdSupplier;
        }

        public void initRead() {
            this.lastClosedTxId = this.closedTxIdSupplier.getAsInt();
        }

        public void initWrite(long committingTxId) {
            this.committingTxId = committingTxId;
        }

        public long committingTransactionId() {
            return this.committingTxId;
        }

        public long lastClosedTransactionId() {
            return this.lastClosedTxId;
        }

        public void markAsDirty() {
            this.dirty = true;
        }

        public boolean isDirty() {
            return this.dirty;
        }
    }

    private static class CursorSwapperId
    implements AutoCloseable {
        private final PageCursor pageCursor;
        private final int cursorId;

        CursorSwapperId(PageCursor pageCursor, int cursorId) {
            this.pageCursor = pageCursor;
            this.cursorId = cursorId;
        }

        public int getCursorId() {
            return this.cursorId;
        }

        @Override
        public void close() throws Exception {
            this.pageCursor.close();
        }
    }

    private static class FlushRendezvousTracer
    extends DefaultPageCacheTracer {
        private final CountDownLatch latch;

        FlushRendezvousTracer(int fileCountToWaitFor) {
            this.latch = new CountDownLatch(fileCountToWaitFor);
        }

        public MajorFlushEvent beginFileFlush(PageSwapper swapper) {
            this.latch.countDown();
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return MajorFlushEvent.NULL;
        }
    }
}

