/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SystemUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.bouncycastle.util.Arrays;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.NeoBootstrapper;
import org.neo4j.server.WebContainerTestUtils;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.conditions.Conditions;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;

public abstract class BaseBootstrapperIT
extends ExclusiveWebContainerTestBase {
    protected NeoBootstrapper bootstrapper;

    @BeforeEach
    void before() {
        this.bootstrapper = this.newBootstrapper();
        SelfSignedCertificateFactory.create((Path)this.testDirectory.homePath());
    }

    @AfterEach
    void after() {
        if (this.bootstrapper != null) {
            this.bootstrapper.stop();
        }
    }

    protected abstract NeoBootstrapper newBootstrapper();

    @Test
    void shouldStartStopNeoServerWithoutAnyConfigFiles() {
        int resultCode = NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])BaseBootstrapperIT.withConnectorsOnRandomPortsConfig(this.getAdditionalArguments()));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)resultCode);
        Assert.assertEventually((String)"Server was not started", () -> ((NeoBootstrapper)this.bootstrapper).isRunning(), (Condition)Conditions.TRUE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    protected String[] getAdditionalArguments() {
        return new String[]{"--home-dir", this.testDirectory.directory("home-dir").toAbsolutePath().toString(), "-c", BaseBootstrapperIT.configOption(GraphDatabaseSettings.data_directory, this.testDirectory.absolutePath().toString()), "-c", BaseBootstrapperIT.configOption(GraphDatabaseSettings.logs_directory, this.testDirectory.absolutePath().toString())};
    }

    @Test
    void canSpecifyConfigFile() throws Throwable {
        Path configFile = this.testDirectory.file("neo4j.conf");
        Map properties = MapUtil.stringMap((String[])new String[]{GraphDatabaseInternalSettings.forced_kernel_id.name(), "ourcustomvalue"});
        properties.putAll(WebContainerTestUtils.getDefaultRelativeProperties((Path)this.testDirectory.homePath()));
        properties.putAll(BaseBootstrapperIT.connectorsOnRandomPortsConfig());
        MapUtil.store((Map)properties, (Path)configFile);
        NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.testDirectory.directory("home-dir").toAbsolutePath().toString(), "--config-dir", configFile.getParent().toAbsolutePath().toString()});
        DependencyResolver dependencyResolver = this.getDependencyResolver();
        Assertions.assertThat((String)((String)((Config)dependencyResolver.resolveDependency(Config.class)).get(GraphDatabaseInternalSettings.forced_kernel_id))).isEqualTo("ourcustomvalue");
    }

    @Test
    void canOverrideConfigValues() throws Throwable {
        Path configFile = this.testDirectory.file("neo4j.conf");
        Map properties = MapUtil.stringMap((String[])new String[]{GraphDatabaseInternalSettings.forced_kernel_id.name(), "thisshouldnotshowup"});
        properties.putAll(WebContainerTestUtils.getDefaultRelativeProperties((Path)this.testDirectory.homePath()));
        properties.putAll(BaseBootstrapperIT.connectorsOnRandomPortsConfig());
        MapUtil.store((Map)properties, (Path)configFile);
        NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.testDirectory.directory("home-dir").toAbsolutePath().toString(), "--config-dir", configFile.getParent().toAbsolutePath().toString(), "-c", BaseBootstrapperIT.configOption(GraphDatabaseInternalSettings.forced_kernel_id, "mycustomvalue")});
        DependencyResolver dependencyResolver = this.getDependencyResolver();
        Assertions.assertThat((String)((String)((Config)dependencyResolver.resolveDependency(Config.class)).get(GraphDatabaseInternalSettings.forced_kernel_id))).isEqualTo("mycustomvalue");
    }

    @Test
    void shouldStartWithHttpHttpsAndBoltDisabled() {
        this.testStartupWithConnectors(false, false, false);
    }

    @Test
    void shouldStartWithHttpEnabledAndHttpsBoltDisabled() {
        this.testStartupWithConnectors(true, false, false);
    }

    @Test
    void shouldStartWithHttpsEnabledAndHttpBoltDisabled() {
        this.testStartupWithConnectors(false, true, false);
    }

    @Test
    void shouldStartWithBoltEnabledAndHttpHttpsDisabled() {
        this.testStartupWithConnectors(false, false, true);
    }

    @Test
    void shouldStartWithHttpHttpsEnabledAndBoltDisabled() {
        this.testStartupWithConnectors(true, true, false);
    }

    @Test
    void shouldStartWithHttpBoltEnabledAndHttpsDisabled() {
        this.testStartupWithConnectors(true, false, true);
    }

    @Test
    void shouldStartWithHttpsBoltEnabledAndHttpDisabled() {
        this.testStartupWithConnectors(false, true, true);
    }

    @Test
    void shouldHaveSameLayoutAsEmbedded() {
        Path serverDir = this.testDirectory.directory("server-dir");
        NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])BaseBootstrapperIT.withConnectorsOnRandomPortsConfig("--home-dir", serverDir.toAbsolutePath().toString()));
        Assert.assertEventually((String)"Server was not started", () -> ((NeoBootstrapper)this.bootstrapper).isRunning(), (Condition)Conditions.TRUE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        GraphDatabaseAPI databaseAPI = (GraphDatabaseAPI)this.bootstrapper.getDatabaseManagementService().database("neo4j");
        Neo4jLayout serverLayout = databaseAPI.databaseLayout().getNeo4jLayout();
        this.bootstrapper.stop();
        Path embeddedDir = this.testDirectory.directory("embedded-dir");
        DatabaseManagementService dbms = this.newEmbeddedDbms(embeddedDir);
        Neo4jLayout embeddedLayout = ((GraphDatabaseAPI)dbms.database("neo4j")).databaseLayout().getNeo4jLayout();
        dbms.shutdown();
        org.junit.jupiter.api.Assertions.assertEquals((Object)serverDir.relativize(serverLayout.homeDirectory()), (Object)embeddedDir.relativize(embeddedLayout.homeDirectory()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)serverDir.relativize(serverLayout.databasesDirectory()), (Object)embeddedDir.relativize(embeddedLayout.databasesDirectory()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)serverDir.relativize(serverLayout.transactionLogsRootDirectory()), (Object)embeddedDir.relativize(embeddedLayout.transactionLogsRootDirectory()));
    }

    @Test
    void shouldOnlyAllowCommandExpansionWhenProvidedAsArgument() {
        String setting = String.format("%s=$(%s 100 * 1000)", GraphDatabaseSettings.log_queries_rotation_threshold.name(), SystemUtils.IS_OS_WINDOWS ? "cmd.exe /c set /a" : "expr");
        String[] args = BaseBootstrapperIT.withConnectorsOnRandomPortsConfig("--home-dir", this.testDirectory.homePath().toString(), "-c", setting);
        Assertions.assertThatThrownBy(() -> NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])args)).hasMessageContaining("is a command, but config is not explicitly told to expand it");
        NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])Arrays.append((String[])args, (String)"--expand-commands"));
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.bootstrapper.getDatabaseManagementService().database("neo4j");
        Config config = (Config)db.getDependencyResolver().resolveDependency(Config.class);
        Assertions.assertThat((Long)((Long)config.get(GraphDatabaseSettings.log_queries_rotation_threshold))).isEqualTo(100000L);
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    void shouldWriteAndDeletePidFile() {
        int resultCode = NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.testDirectory.homePath().toString()});
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)resultCode);
        Assert.assertEventually((String)"Server was not started", () -> ((NeoBootstrapper)this.bootstrapper).isRunning(), (Condition)Conditions.TRUE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        Path pidFile = (Path)((Config)this.getDependencyResolver().resolveDependency(Config.class)).get(BootloaderSettings.pid_file);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Files.exists(pidFile, new LinkOption[0]));
        this.bootstrapper.stop();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Files.exists(pidFile, new LinkOption[0]));
    }

    protected abstract DatabaseManagementService newEmbeddedDbms(Path var1);

    private void testStartupWithConnectors(boolean httpEnabled, boolean httpsEnabled, boolean boltEnabled) {
        SslPolicyConfig httpsPolicy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.HTTPS);
        if (httpsEnabled) {
            SelfSignedCertificateFactory.create((Path)this.testDirectory.absolutePath());
        }
        Object[] config = new String[]{"-c", httpsEnabled ? BaseBootstrapperIT.configOption(httpsPolicy.enabled, "true") : "", "-c", httpsEnabled ? BaseBootstrapperIT.configOption(httpsPolicy.base_directory, this.testDirectory.absolutePath().toString()) : "", "-c", HttpConnector.enabled.name() + "=" + httpEnabled, "-c", HttpConnector.listen_address.name() + "=localhost:0", "-c", HttpsConnector.enabled.name() + "=" + httpsEnabled, "-c", HttpsConnector.listen_address.name() + "=localhost:0", "-c", BoltConnector.enabled.name() + "=" + boltEnabled, "-c", BoltConnector.listen_address.name() + "=localhost:0"};
        String[] allConfigOptions = (String[])ArrayUtils.addAll((Object[])config, (Object[])this.getAdditionalArguments());
        int resultCode = NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])allConfigOptions);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)resultCode);
        Assert.assertEventually((String)"Server was not started", () -> ((NeoBootstrapper)this.bootstrapper).isRunning(), (Condition)Conditions.TRUE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        this.assertDbAccessibleAsEmbedded();
        WebContainerTestUtils.verifyConnector((GraphDatabaseService)this.db(), (String)"http", (boolean)httpEnabled);
        WebContainerTestUtils.verifyConnector((GraphDatabaseService)this.db(), (String)"https", (boolean)httpsEnabled);
        WebContainerTestUtils.verifyConnector((GraphDatabaseService)this.db(), (String)"bolt", (boolean)boltEnabled);
    }

    protected static String configOption(Setting<?> setting, String value) {
        return setting.name() + "=" + value;
    }

    protected static String[] withConnectorsOnRandomPortsConfig(String ... otherConfigs) {
        Stream<String> configs = Stream.of(otherConfigs);
        Stream connectorsConfig = BaseBootstrapperIT.connectorsOnRandomPortsConfig().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).flatMap(config -> Stream.of("-c", config));
        return (String[])Stream.concat(configs, connectorsConfig).toArray(String[]::new);
    }

    protected static Map<String, String> connectorsOnRandomPortsConfig() {
        return MapUtil.stringMap((String[])new String[]{HttpConnector.listen_address.name(), "localhost:0", HttpConnector.enabled.name(), "true", HttpsConnector.listen_address.name(), "localhost:0", HttpsConnector.enabled.name(), "false", BoltConnector.listen_address.name(), "localhost:0", BoltConnector.encryption_level.name(), "DISABLED", BoltConnector.enabled.name(), "true"});
    }

    private void assertDbAccessibleAsEmbedded() {
        GraphDatabaseAPI db = this.db();
        Label label = () -> "Node";
        String propertyKey = "key";
        String propertyValue = "value";
        try (Transaction tx = db.beginTx();){
            tx.createNode(new Label[]{label}).setProperty(propertyKey, (Object)propertyValue);
            tx.commit();
        }
        tx = db.beginTx();
        try {
            Node node = (Node)Iterators.single((Iterator)tx.findNodes(label));
            org.junit.jupiter.api.Assertions.assertEquals((Object)propertyValue, (Object)node.getProperty(propertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private GraphDatabaseAPI db() {
        return (GraphDatabaseAPI)this.bootstrapper.getDatabaseManagementService().database("neo4j");
    }

    private DependencyResolver getDependencyResolver() {
        return this.db().getDependencyResolver();
    }
}

