/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.RandomAdversary;
import org.neo4j.adversaries.fs.AdversarialFileSystemAbstraction;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DelegatingFileSystemAbstraction;
import org.neo4j.io.fs.DelegatingStoreChannel;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.DelegatingPageSwapper;
import org.neo4j.io.pagecache.EmptyIOController;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.FileIsNotMappedException;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.randomharness.Record;
import org.neo4j.io.pagecache.randomharness.StandardRecordFormat;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.ThreadTestUtils;
import org.neo4j.util.concurrent.BinaryLatch;

public abstract class PageCacheTest<T extends PageCache>
extends PageCacheTestSupport<T> {
    protected ImmutableSet<OpenOption> openOptions = Sets.immutable.empty();

    protected PagedFile map(PageCache pageCache, Path file, int filePageSize) throws IOException {
        return this.map(pageCache, file, filePageSize, (ImmutableSet<OpenOption>)Sets.immutable.empty());
    }

    protected PagedFile map(PageCache pageCache, Path file, int filePageSize, ImmutableSet<OpenOption> options) throws IOException {
        return pageCache.map(file, filePageSize, "neo4j", this.openOptions.newWithAll(options));
    }

    protected PagedFile map(Path file, int filePageSize) throws IOException {
        return this.map(this.pageCache, file, filePageSize, (ImmutableSet<OpenOption>)Sets.immutable.empty());
    }

    protected PagedFile map(Path file, int filePageSize, ImmutableSet<OpenOption> options) throws IOException {
        return this.map(this.pageCache, file, filePageSize, options);
    }

    @Test
    void mustReportConfiguredMaxPages() {
        this.configureStandardPageCache();
        Assertions.assertThat((long)this.pageCache.maxCachedPages()).isEqualTo((long)this.maxPages);
    }

    @Test
    void mustReportConfiguredCachePageSize() {
        this.configureStandardPageCache();
        Assertions.assertThat((int)this.pageCache.pageSize()).isEqualTo(this.pageCachePageSize);
    }

    @Test
    void mustHaveAtLeastTwoPages() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.getPageCache(this.fs, 1, PageCacheTracer.NULL));
    }

    @Test
    void mustAcceptTwoPagesAsMinimumConfiguration() {
        this.getPageCache(this.fs, 2, PageCacheTracer.NULL);
    }

    @Test
    void gettingNameFromMappedFileMustMatchMappedFileName() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        try (PagedFile pf = this.map(file, this.filePageSize);){
            Assertions.assertThat((Path)pf.path()).isEqualTo((Object)file);
        }
    }

    @Test
    void mustReadExistingData() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            int recordId = 0;
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);){
                while (cursor.next()) {
                    this.verifyRecordsMatchExpected(cursor);
                    recordId += this.recordsPerFilePage;
                }
            }
            Assertions.assertThat((int)recordId).isEqualTo(this.recordCount);
        });
    }

    @Test
    void mustScanInTheMiddleOfTheFile() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            long startPage = 10L;
            long endPage = this.recordCount / this.recordsPerFilePage - 10;
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            int recordId = (int)(startPage * (long)this.recordsPerFilePage);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(startPage, 1, CursorContext.NULL);){
                while (cursor.next() && cursor.getCurrentPageId() < endPage) {
                    this.verifyRecordsMatchExpected(cursor);
                    recordId += this.recordsPerFilePage;
                }
            }
            Assertions.assertThat((int)recordId).isEqualTo(this.recordCount - 10 * this.recordsPerFilePage);
        });
    }

    @Test
    void writesFlushedFromPageFileMustBeExternallyObservable() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            long startPageId = 0L;
            long endPageId = this.recordCount / this.recordsPerFilePage;
            try (PageCursor cursor = pagedFile.io(startPageId, 2, CursorContext.NULL);){
                while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                    this.writeRecords(cursor);
                }
            }
            pagedFile.flushAndForce();
            this.verifyRecordsInFile(this.file("a"), this.recordCount);
            pagedFile.close();
        });
    }

    @Test
    void pagedFileFlushAndForceMustThrowOnNullIOPSLimiter() {
        this.configureStandardPageCache();
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> {
            PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, "neo4j", Sets.immutable.empty(), null);
            if (pf != null) {
                pf.close();
            }
        });
    }

    @Test
    void wholePageCacheFlushAndForceExecutedWithoutIOController() throws Exception {
        int pagesToDirty = 10000;
        Object cache = this.getPageCache(this.fs, Numbers.ceilingPowerOfTwo((int)(2 * pagesToDirty)), PageCacheTracer.NULL);
        int pagesPerFlush = IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(cache.getBufferFactory()) ? 1 : (Integer)GraphDatabaseSettings.pagecache_flush_buffer_size_in_pages.defaultValue();
        AtomicInteger callbackCounter = new AtomicInteger();
        AtomicInteger ioCounter = new AtomicInteger();
        PageCacheIOController ioController = new PageCacheIOController(ioCounter, pagesPerFlush, callbackCounter);
        PagedFile pfA = cache.map(this.existingFile("a"), this.filePageSize, "neo4j", Sets.immutable.empty(), (IOController)ioController);
        PagedFile pfB = cache.map(this.existingFile("b"), this.filePageSize, "neo4j", Sets.immutable.empty(), (IOController)ioController);
        PageCacheTest.dirtyManyPages(pfA, pagesToDirty);
        PageCacheTest.dirtyManyPages(pfB, pagesToDirty);
        cache.flushAndForce();
        pfA.close();
        pfB.close();
        Assertions.assertThat((int)callbackCounter.get()).isEqualTo(0);
        Assertions.assertThat((int)ioCounter.get()).isEqualTo(0);
    }

    @Test
    void pagedFileFlushAndForceMustQueryTheGivenIOPSLimiter() throws Exception {
        int pagesToDirty = 10000;
        Object cache = this.getPageCache(this.fs, Numbers.ceilingPowerOfTwo((int)pagesToDirty), PageCacheTracer.NULL);
        int pagesPerFlush = IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(cache.getBufferFactory()) ? 1 : (Integer)GraphDatabaseSettings.pagecache_flush_buffer_size_in_pages.defaultValue();
        AtomicInteger callbackCounter = new AtomicInteger();
        AtomicInteger ioCounter = new AtomicInteger();
        PageCacheIOController ioController = new PageCacheIOController(ioCounter, pagesPerFlush, callbackCounter);
        PagedFile pf = cache.map(this.file("a"), this.filePageSize, "neo4j", Sets.immutable.empty(), (IOController)ioController);
        PageCacheTest.dirtyManyPages(pf, pagesToDirty);
        pf.flushAndForce();
        pf.close();
        Assertions.assertThat((int)callbackCounter.get()).isGreaterThan(0);
        Assertions.assertThat((int)ioCounter.get()).isGreaterThanOrEqualTo(pagesToDirty - 30);
    }

    private static void dirtyManyPages(PagedFile pf, int pagesToDirty) throws IOException {
        PageCacheTest.dirtyManyPages(pf, pagesToDirty, CursorContext.NULL);
    }

    private static void dirtyManyPages(PagedFile pf, int pagesToDirty, CursorContext cursorContext) throws IOException {
        try (PageCursor cursor = pf.io(0L, 2, cursorContext);){
            for (int i = 0; i < pagesToDirty; ++i) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
        }
    }

    @Test
    void writesFlushedFromPageFileMustBeObservableEvenWhenRacingWithEviction() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.LONG_TIMEOUT_MILLIS), () -> {
            this.getPageCache(this.fs, 20, PageCacheTracer.NULL);
            long startPageId = 0L;
            long endPageId = 21L;
            int iterations = 500;
            int shortsPerPage = this.pageCachePageSize / 2;
            try (PagedFile pagedFile = this.map(this.file("a"), this.pageCachePageSize);){
                for (int i = 1; i <= iterations; ++i) {
                    int j;
                    try (PageCursor cursor = pagedFile.io(startPageId, 2, CursorContext.NULL);){
                        while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                            for (j = 0; j < shortsPerPage; ++j) {
                                cursor.putShort((short)i);
                            }
                        }
                    }
                    pagedFile.flushAndForce();
                    try (DataInputStream stream = new DataInputStream(this.fs.openAsInputStream(this.file("a")));){
                        for (j = 0; j < shortsPerPage; ++j) {
                            short value = stream.readShort();
                            ((AbstractIntegerAssert)Assertions.assertThat((int)value).as("short pos = " + j + ", iteration = " + i, new Object[0])).isEqualTo(i);
                        }
                        continue;
                    }
                }
            }
        });
    }

    @Test
    void flushAndForceMustNotLockPageCacheForWholeDuration() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.maxPages = 5000;
            this.configureStandardPageCache();
            Path a = this.existingFile("a");
            Path b = this.existingFile("b");
            final BinaryLatch limiterStartLatch = new BinaryLatch();
            final BinaryLatch limiterBlockLatch = new BinaryLatch();
            EmptyIOController ioController = new EmptyIOController(){

                public void maybeLimitIO(int recentlyCompletedIOs, Flushable flushable, MajorFlushEvent flushEvent) {
                    limiterStartLatch.release();
                    limiterBlockLatch.await();
                    super.maybeLimitIO(recentlyCompletedIOs, flushable, flushEvent);
                }
            };
            try (PagedFile pfA = this.pageCache.map(a, this.filePageSize, "neo4j", Sets.immutable.empty(), (IOController)ioController);){
                try (PageCursor cursor = pfA.io(0L, 2, CursorContext.NULL);){
                    for (int i = 0; i < this.maxPages; ++i) {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    }
                }
                Future<Object> flusher = executor.submit(() -> {
                    pfA.flushAndForce();
                    return null;
                });
                limiterStartLatch.await();
                this.map(this.pageCache, b, this.filePageSize).close();
                this.pageCache.listExistingMappings();
                this.pageCache.getExistingMapping(a).ifPresent(PagedFile::close);
                limiterBlockLatch.release();
                flusher.get();
            }
        });
    }

    @Test
    void flushAndForceMustTolerateAsynchronousFileUnmapping() throws Exception {
        Future<Object> flusher;
        this.configureStandardPageCache();
        Path a = this.existingFile("a");
        Path b = this.existingFile("b");
        Path c = this.existingFile("c");
        final BinaryLatch limiterStartLatch = new BinaryLatch();
        final BinaryLatch limiterBlockLatch = new BinaryLatch();
        EmptyIOController ioController = new EmptyIOController(){

            public void maybeLimitIO(int recentlyCompletedIOs, Flushable flushable, MajorFlushEvent flushEvent) {
                limiterStartLatch.release();
                limiterBlockLatch.await();
                super.maybeLimitIO(recentlyCompletedIOs, flushable, flushEvent);
            }
        };
        try (PagedFile pfA = this.pageCache.map(a, this.filePageSize, "neo4j", Sets.immutable.empty(), (IOController)ioController);
             PagedFile pfB = this.pageCache.map(b, this.filePageSize, "neo4j", Sets.immutable.empty(), (IOController)ioController);
             PagedFile pfC = this.pageCache.map(c, this.filePageSize, "neo4j", Sets.immutable.empty(), (IOController)ioController);){
            try (PageCursor cursor = pfA.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
            cursor = pfB.io(0L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = pfC.io(0L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            flusher = executor.submit(() -> {
                pfA.flushAndForce();
                pfB.flushAndForce();
                pfC.flushAndForce();
                return null;
            });
            limiterStartLatch.await();
        }
        limiterBlockLatch.release();
        flusher.get();
    }

    @Test
    void writesFlushedFromPageCacheMustBeExternallyObservable() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            long startPageId = 0L;
            long endPageId = this.recordCount / this.recordsPerFilePage;
            Path file = this.file("a");
            try (PagedFile pagedFile = this.map(file, this.filePageSize);
                 PageCursor cursor = pagedFile.io(startPageId, 2, CursorContext.NULL);){
                while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                    this.writeRecords(cursor);
                }
            }
            this.verifyRecordsInFile(file, this.recordCount);
        });
    }

    @Test
    void writesToPagesMustNotBleedIntoAdjacentPages() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                for (int i = 1; i <= 100; ++i) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    for (int j = 0; j < this.filePageSize; ++j) {
                        cursor.putByte((byte)i);
                    }
                }
            }
            InputStream inputStream = this.fs.openAsInputStream(this.file("a"));
            for (int i = 1; i <= 100; ++i) {
                for (int j = 0; j < this.filePageSize; ++j) {
                    Assertions.assertThat((int)inputStream.read()).isEqualTo(i);
                }
            }
            inputStream.close();
        });
    }

    @Test
    void channelMustBeForcedAfterPagedFileFlushAndForceWithNoBuffers() throws Exception {
        AtomicInteger writeCounter = new AtomicInteger();
        AtomicInteger forceCounter = new AtomicInteger();
        DelegatingFileSystemAbstraction fs = this.writeAndForceCountingFs(writeCounter, forceCounter);
        this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL);
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.pageCache.getBufferFactory()));
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            pagedFile.flushAndForce();
            Assertions.assertThat((int)writeCounter.get()).isGreaterThanOrEqualTo(2);
            Assertions.assertThat((int)forceCounter.get()).isEqualTo(1);
        }
    }

    @Test
    void channelMustBeForcedAfterPagedFileFlushAndForceWithBuffers() throws Exception {
        AtomicInteger writeCounter = new AtomicInteger();
        AtomicInteger forceCounter = new AtomicInteger();
        DelegatingFileSystemAbstraction fs = this.writeAndForceCountingFs(writeCounter, forceCounter);
        this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL);
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.pageCache.getBufferFactory()));
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            pagedFile.flushAndForce();
            Assertions.assertThat((int)writeCounter.get()).isGreaterThanOrEqualTo(1);
            Assertions.assertThat((int)forceCounter.get()).isEqualTo(1);
        }
    }

    @Test
    void channelsMustBeForcedAfterPageCacheFlushAndForceWithNoBuffers() throws Exception {
        AtomicInteger writeCounter = new AtomicInteger();
        AtomicInteger forceCounter = new AtomicInteger();
        DelegatingFileSystemAbstraction fs = this.writeAndForceCountingFs(writeCounter, forceCounter);
        this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL);
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.pageCache.getBufferFactory()));
        try (PagedFile pagedFileA = this.map(this.existingFile("a"), this.filePageSize);
             PagedFile pagedFileB = this.map(this.existingFile("b"), this.filePageSize);){
            try (PageCursor cursor = pagedFileA.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            cursor = pagedFileB.io(0L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.pageCache.flushAndForce();
            Assertions.assertThat((int)writeCounter.get()).isGreaterThanOrEqualTo(3);
            Assertions.assertThat((int)forceCounter.get()).isEqualTo(2);
        }
    }

    @Test
    void channelsMustBeForcedAfterPageCacheFlushAndForceWithBuffers() throws Exception {
        AtomicInteger writeCounter = new AtomicInteger();
        AtomicInteger forceCounter = new AtomicInteger();
        DelegatingFileSystemAbstraction fs = this.writeAndForceCountingFs(writeCounter, forceCounter);
        this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL);
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.pageCache.getBufferFactory()));
        try (PagedFile pagedFileA = this.map(this.existingFile("a"), this.filePageSize);
             PagedFile pagedFileB = this.map(this.existingFile("b"), this.filePageSize);){
            try (PageCursor cursor = pagedFileA.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            cursor = pagedFileB.io(0L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.pageCache.flushAndForce();
            Assertions.assertThat((int)writeCounter.get()).isGreaterThanOrEqualTo(2);
            Assertions.assertThat((int)forceCounter.get()).isEqualTo(2);
        }
    }

    private DelegatingFileSystemAbstraction writeAndForceCountingFs(final AtomicInteger writeCounter, final AtomicInteger forceCounter) {
        return new DelegatingFileSystemAbstraction(this.fs){

            public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, options)){

                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        writeCounter.getAndIncrement();
                        super.writeAll(src, position);
                    }

                    public long write(ByteBuffer[] srcs) throws IOException {
                        writeCounter.getAndAdd(srcs.length);
                        return super.write(srcs);
                    }

                    public void force(boolean metaData) throws IOException {
                        forceCounter.getAndIncrement();
                        super.force(metaData);
                    }
                };
            }
        };
    }

    @Test
    void firstNextCallMustReturnFalseWhenTheFileIsEmptyAndNoGrowIsSpecified() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 6, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
        });
    }

    @Test
    void nextMustReturnTrueThenFalseWhenThereIsOnlyOnePageInTheFileAndNoGrowIsSpecified() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            int numberOfRecordsToGenerate = this.recordsPerFilePage;
            this.generateFileWithRecords(this.file("a"), numberOfRecordsToGenerate, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 6, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                this.verifyRecordsMatchExpected(cursor);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
        });
    }

    @Test
    void closingWithoutCallingNextMustLeavePageUnpinnedAndUntouched() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            int numberOfRecordsToGenerate = this.recordsPerFilePage;
            this.generateFileWithRecords(this.file("a"), numberOfRecordsToGenerate, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
                PageCursor ignore = pagedFile.io(0L, 2, CursorContext.NULL);
                if (ignore != null) {
                    ignore.close();
                }
                try (PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);){
                    cursor.next();
                    this.verifyRecordsMatchExpected(cursor);
                }
            }
        });
    }

    @Test
    void nextWithNegativeInitialPageIdMustReturnFalse() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);){
            try (PageCursor cursor = pf.io(-1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            cursor = pf.io(-1L, 1, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void nextWithNegativePageIdMustReturnFalse() throws Exception {
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(file, this.filePageSize);){
            long pageId = 12L;
            try (PageCursor cursor = pf.io(pageId, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next(-1L));
                Assertions.assertThat((long)cursor.getCurrentPageId()).isEqualTo(-1L);
            }
            cursor = pf.io(pageId, 1, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next(-1L));
                Assertions.assertThat((long)cursor.getCurrentPageId()).isEqualTo(-1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void rewindMustStartScanningOverFromTheBeginning() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            int numberOfRewindsToTest = 10;
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            int actualPageCounter = 0;
            int filePageCount = this.recordCount / this.recordsPerFilePage;
            int expectedPageCounterResult = numberOfRewindsToTest * filePageCount;
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);){
                for (int i = 0; i < numberOfRewindsToTest; ++i) {
                    while (cursor.next()) {
                        this.verifyRecordsMatchExpected(cursor);
                        ++actualPageCounter;
                    }
                    cursor.rewind();
                }
            }
            Assertions.assertThat((int)actualPageCounter).isEqualTo(expectedPageCounterResult);
        });
    }

    @Test
    void mustCloseFileChannelWhenTheLastHandleIsUnmapped() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            Assumptions.assumeTrue((this.fs.getClass() == EphemeralFileSystemAbstraction.class ? 1 : 0) != 0, (String)"This depends on EphemeralFSA specific features");
            this.configureStandardPageCache();
            PagedFile a = this.map(this.file("a"), this.filePageSize);
            PagedFile b = this.map(this.file("a"), this.filePageSize);
            a.close();
            b.close();
            ((EphemeralFileSystemAbstraction)this.fs).assertNoOpenFiles();
        });
    }

    @Test
    void dirtyPagesMustBeFlushedWhenTheCacheIsClosed() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            long startPageId = 0L;
            long endPageId = this.recordCount / this.recordsPerFilePage;
            Path file = this.file("a");
            try (PagedFile pagedFile = this.map(file, this.filePageSize);
                 PageCursor cursor = pagedFile.io(startPageId, 2, CursorContext.NULL);){
                while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                    this.writeRecords(cursor);
                }
            }
            finally {
                this.pageCache.close();
            }
            this.verifyRecordsInFile(file, this.recordCount);
        });
    }

    @Test
    void dirtyPagesMustBeFlushedWhenThePagedFileIsClosed() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            long startPageId = 0L;
            long endPageId = this.recordCount / this.recordsPerFilePage;
            Path file = this.file("a");
            try (PagedFile pagedFile = this.map(file, this.filePageSize);
                 PageCursor cursor = pagedFile.io(startPageId, 2, CursorContext.NULL);){
                while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                    this.writeRecords(cursor);
                }
            }
            this.verifyRecordsInFile(file, this.recordCount);
        });
    }

    @RepeatedTest(value=100)
    void flushingDuringPagedFileCloseMustRetryUntilItSucceeds() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

                public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
                    return new DelegatingStoreChannel(super.open(fileName, options)){
                        private int writeCount;

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            if (this.writeCount++ < 10) {
                                throw new IOException("This is a benign exception that we expect to be thrown during a flush of a PagedFile.");
                            }
                            super.writeAll(src, position);
                        }
                    };
                }
            };
            this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL);
            PrintStream oldSystemErr = System.err;
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                this.writeRecords(cursor);
                System.setErr(new PrintStream(new ByteArrayOutputStream()));
            }
            finally {
                System.setErr(oldSystemErr);
            }
            this.verifyRecordsInFile(this.file("a"), this.recordsPerFilePage);
        });
    }

    @Test
    void mappingFilesInClosedCacheMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.pageCache.close();
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.map(this.file("a"), this.filePageSize));
        });
    }

    @Test
    void flushingClosedCacheMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.pageCache.close();
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.pageCache.flushAndForce());
        });
    }

    @Test
    void mappingFileWithPageSizeGreaterThanCachePageSizeMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.map(this.file("a"), this.pageCachePageSize + 1));
        });
    }

    @Test
    void mappingFileWithPageSizeSmallerThanLongSizeBytesMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.map(this.file("a"), 7));
        });
    }

    @Test
    void mappingFileWithPageSizeSmallerThanLongSizeBytesMustThrowEvenWithAnyPageSizeOpenOptionAndNoExistingMapping() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.map(this.file("a"), 7, (ImmutableSet<OpenOption>)Sets.immutable.of((Object)PageCacheOpenOptions.ANY_PAGE_SIZE)));
        });
    }

    @Test
    void mappingFileWithPageZeroPageSizeMustThrowEvenWithExistingMapping() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            Path file = this.file("a");
            try (PagedFile oldMapping = this.map(file, this.filePageSize);){
                org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.map(file, 7));
            }
        });
    }

    @Test
    void mappingFileWithPageZeroPageSizeAndAnyPageSizeOpenOptionMustNotThrowGivenExistingMapping() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            Path file = this.file("a");
            try (PagedFile oldMapping = this.map(file, this.filePageSize);){
                PagedFile newMapping = this.map(file, 0, (ImmutableSet<OpenOption>)Sets.immutable.of((Object)PageCacheOpenOptions.ANY_PAGE_SIZE));
                if (newMapping != null) {
                    newMapping.close();
                }
            }
        });
    }

    @Test
    void mappingFileWithPageSizeEqualToCachePageSizeMustNotThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.pageCachePageSize);
            pagedFile.close();
        });
    }

    @Test
    void flushAndForceAfterCloseAndEvictionMustNotGetStuckOnEvictedPages() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.pageCache.map(this.file("a"), this.pageCachePageSize, "neo4j");
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                for (int i = 0; i < 20; ++i) {
                    cursor.next();
                    this.writeRecords(cursor);
                }
            }
            pagedFile.close();
            try (PagedFile b = this.pageCache.map(this.existingFile("b"), this.pageCachePageSize, "neo4j");
                 PageCursor cursor = b.io(0L, 2, CursorContext.NULL);){
                for (int i = 0; i < 200; ++i) {
                    cursor.next();
                }
            }
            pagedFile.flushAndForce();
        });
    }

    @Test
    void notSpecifyingAnyPfFlagsMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
                org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> pagedFile.io(0L, 0, CursorContext.NULL));
            }
        });
    }

    @Test
    void notSpecifyingAnyPfLockFlagsMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
                org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> pagedFile.io(0L, 16, CursorContext.NULL));
            }
        });
    }

    @Test
    void specifyingBothReadAndWriteLocksMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
                org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> pagedFile.io(0L, 3, CursorContext.NULL));
            }
        });
    }

    @Test
    void mustNotPinPagesAfterNextReturnsFalse() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            CountDownLatch startLatch = new CountDownLatch(1);
            CountDownLatch unpinLatch = new CountDownLatch(1);
            AtomicReference exceptionRef = new AtomicReference();
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            Runnable runnable = () -> {
                try (PageCursor cursorA = pagedFile.io(0L, 6, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorA.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorA.next());
                    startLatch.countDown();
                    unpinLatch.await();
                }
                catch (Exception e) {
                    exceptionRef.set(e);
                }
            };
            executor.submit(runnable);
            startLatch.await();
            try (PageCursor cursorB = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorB.next());
                unpinLatch.countDown();
            }
            finally {
                pagedFile.close();
            }
            Exception e = (Exception)exceptionRef.get();
            if (e != null) {
                throw new Exception("Child thread got exception", e);
            }
        });
    }

    @Test
    void nextMustResetTheCursorOffset() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.setOffset(0);
                cursor.putByte((byte)1);
                cursor.putByte((byte)2);
                cursor.putByte((byte)3);
                cursor.putByte((byte)4);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.setOffset(0);
                cursor.putByte((byte)5);
                cursor.putByte((byte)6);
                cursor.putByte((byte)7);
                cursor.putByte((byte)8);
            }
            cursor = pagedFile.io(0L, 2, CursorContext.NULL);
            try {
                byte[] bytes = new byte[4];
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.getBytes(bytes);
                Assertions.assertThat((byte[])bytes).containsExactly(new int[]{1, 2, 3, 4});
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.getBytes(bytes);
                Assertions.assertThat((byte[])bytes).containsExactly(new int[]{5, 6, 7, 8});
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.close();
        });
    }

    @Test
    void nextMustAdvanceCurrentPageId() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)cursor.getCurrentPageId()).isEqualTo(0L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)cursor.getCurrentPageId()).isEqualTo(1L);
            }
        });
    }

    @Test
    void nextToSpecificPageIdMustAdvanceFromThatPointOn() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)cursor.getCurrentPageId()).isEqualTo(1L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(4L));
                Assertions.assertThat((long)cursor.getCurrentPageId()).isEqualTo(4L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)cursor.getCurrentPageId()).isEqualTo(5L);
            }
        });
    }

    @Test
    void currentPageIdIsUnboundBeforeFirstNextAndAfterRewind() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                Assertions.assertThat((long)cursor.getCurrentPageId()).isEqualTo(-1L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)cursor.getCurrentPageId()).isEqualTo(0L);
                cursor.rewind();
                Assertions.assertThat((long)cursor.getCurrentPageId()).isEqualTo(-1L);
            }
        });
    }

    @Test
    void pageCursorMustKnowCurrentFilePageSize() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                Assertions.assertThat((int)cursor.getCurrentPageSize()).isEqualTo(-1);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((int)cursor.getCurrentPageSize()).isEqualTo(this.filePageSize);
                cursor.rewind();
                Assertions.assertThat((int)cursor.getCurrentPageSize()).isEqualTo(-1);
            }
        });
    }

    @Test
    void pageCursorMustKnowCurrentFile() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                Assertions.assertThat((Path)cursor.getCurrentFile()).isNull();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((Path)cursor.getCurrentFile()).isEqualTo((Object)this.file("a"));
                cursor.rewind();
                Assertions.assertThat((Path)cursor.getCurrentFile()).isNull();
            }
        });
    }

    @Test
    void readingFromUnboundReadCursorMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> PageCacheTest.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkUnboundReadCursorAccess)));
    }

    @Test
    void readingFromUnboundWriteCursorMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> PageCacheTest.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkUnboundWriteCursorAccess)));
    }

    @Test
    void readingFromPreviouslyBoundCursorMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> PageCacheTest.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundWriteCursorAccess)));
    }

    @Test
    void writingToUnboundCursorMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> PageCacheTest.verifyOnWriteCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkUnboundWriteCursorAccess)));
    }

    @Test
    void writingToPreviouslyBoundCursorMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> PageCacheTest.verifyOnWriteCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundWriteCursorAccess)));
    }

    @Test
    void readFromReadCursorAfterNextReturnsFalseMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> PageCacheTest.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkReadCursorAfterFailedNext)));
    }

    @Test
    void readFromPreviouslyBoundReadCursorAfterNextReturnsFalseMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> PageCacheTest.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundReadCursorAfterFailedNext)));
    }

    @Test
    void readFromWriteCursorAfterNextReturnsFalseMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> PageCacheTest.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkWriteCursorAfterFailedNext)));
    }

    @Test
    void readFromPreviouslyBoundWriteCursorAfterNextReturnsFalseMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> PageCacheTest.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundWriteCursorAfterFailedNext)));
    }

    @Test
    void writeAfterNextReturnsFalseMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> PageCacheTest.verifyOnWriteCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkWriteCursorAfterFailedNext)));
    }

    @Test
    void writeToPreviouslyBoundCursorAfterNextReturnsFalseMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> PageCacheTest.verifyOnWriteCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundWriteCursorAfterFailedNext)));
    }

    private static void verifyOnReadCursor(ThrowingConsumer<PageCursorAction, IOException> testTemplate) throws IOException {
        testTemplate.accept(PageCursor::getByte);
        testTemplate.accept(PageCursor::getInt);
        testTemplate.accept(PageCursor::getLong);
        testTemplate.accept(PageCursor::getShort);
        testTemplate.accept(cursor -> cursor.getByte(0));
        testTemplate.accept(cursor -> cursor.getInt(0));
        testTemplate.accept(cursor -> cursor.getLong(0));
        testTemplate.accept(cursor -> cursor.getShort(0));
    }

    private static void verifyOnWriteCursor(ThrowingConsumer<PageCursorAction, IOException> testTemplate) throws IOException {
        testTemplate.accept(cursor -> cursor.putByte((byte)1));
        testTemplate.accept(cursor -> cursor.putInt(1));
        testTemplate.accept(cursor -> cursor.putLong(1L));
        testTemplate.accept(cursor -> cursor.putShort((short)1));
        testTemplate.accept(cursor -> cursor.putByte(0, (byte)1));
        testTemplate.accept(cursor -> cursor.putInt(0, 1));
        testTemplate.accept(cursor -> cursor.putLong(0, 1L));
        testTemplate.accept(cursor -> cursor.putShort(0, (short)1));
        testTemplate.accept(PageCursor::zapPage);
    }

    private void checkUnboundReadCursorAccess(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);){
            action.apply(cursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkUnboundWriteCursorAccess(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
            action.apply(cursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkPreviouslyBoundWriteCursorAccess(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
            PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            action.apply(cursor);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
            cursor.close();
            action.apply(cursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkReadCursorAfterFailedNext(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            action.apply(cursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkPreviouslyBoundReadCursorAfterFailedNext(PageCursorAction action) throws IOException {
        PageCursor cursor;
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
            cursor = pagedFile.io(0L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        pagedFile = this.map(this.file("a"), this.filePageSize);
        try {
            cursor = pagedFile.io(0L, 1, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                action.apply(cursor);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        finally {
            if (pagedFile != null) {
                pagedFile.close();
            }
        }
    }

    private void checkWriteCursorAfterFailedNext(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pagedFile.io(0L, 6, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            action.apply(cursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkPreviouslyBoundWriteCursorAfterFailedNext(PageCursorAction action) throws IOException {
        PageCursor cursor;
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
            cursor = pagedFile.io(0L, 2, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        pagedFile = this.map(this.file("a"), this.filePageSize);
        try {
            cursor = pagedFile.io(0L, 6, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                action.apply(cursor);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        finally {
            if (pagedFile != null) {
                pagedFile.close();
            }
        }
    }

    @Test
    void tryMappedPagedFileShouldReportMappedFilePresent() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        try (PagedFile pf = this.map(file, this.filePageSize);){
            Optional optional = this.pageCache.getExistingMapping(file);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)optional.isPresent());
            PagedFile actual = (PagedFile)optional.get();
            Assertions.assertThat((Object)actual).isSameAs((Object)pf);
            actual.close();
        }
    }

    @Test
    void tryMappedPagedFileShouldReportNonMappedFileNotPresent() throws Exception {
        this.configureStandardPageCache();
        Optional dontExist = this.pageCache.getExistingMapping(Path.of("dont_exist", new String[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)dontExist.isPresent());
    }

    @Test
    void mustListExistingMappings() throws Exception {
        this.configureStandardPageCache();
        Path f1 = this.existingFile("1");
        Path f2 = this.existingFile("2");
        Path f3 = this.existingFile("3");
        this.existingFile("4");
        try (PagedFile pf1 = this.map(f1, this.filePageSize);
             PagedFile pf2 = this.map(f2, this.filePageSize);){
            this.map(f3, this.filePageSize).close();
            List existingMappings = this.pageCache.listExistingMappings();
            Assertions.assertThat((int)existingMappings.size()).isEqualTo(2);
            Assertions.assertThat((List)existingMappings).contains((Object[])new PagedFile[]{pf1, pf2});
        }
    }

    @Test
    void listExistingMappingsMustNotIncrementPagedFileReferenceCount() throws Exception {
        PagedFile existingMapping;
        this.configureStandardPageCache();
        Path file = this.file("a");
        try (PagedFile pf = this.map(file, this.filePageSize);){
            existingMapping = (PagedFile)this.pageCache.listExistingMappings().get(0);
            try (PageCursor cursor = existingMapping.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
        }
        org.junit.jupiter.api.Assertions.assertThrows(FileIsNotMappedException.class, () -> existingMapping.io(0L, 2, CursorContext.NULL).next());
    }

    @Test
    void listExistingMappingsMustThrowOnClosedPageCache() {
        this.configureStandardPageCache();
        PageCache pc = this.pageCache;
        this.pageCache = null;
        pc.close();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((PageCache)pc).listExistingMappings());
    }

    @Test
    void lastPageMustBeAccessibleWithNoGrowSpecified() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
                try (PageCursor cursor = pagedFile.io(0L, 6, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                cursor = pagedFile.io(0L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 6, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(2L, 6, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(2L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(3L, 6, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(3L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void lastPageMustBeAccessibleWithNoGrowSpecifiedEvenIfLessThanFilePageSize() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2 - 1, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
                try (PageCursor cursor = pagedFile.io(0L, 6, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                cursor = pagedFile.io(0L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 6, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(2L, 6, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(2L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(3L, 6, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(3L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void firstPageMustBeAccessibleWithNoGrowSpecifiedIfItIsTheOnlyPage() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
                try (PageCursor cursor = pagedFile.io(0L, 6, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                cursor = pagedFile.io(0L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 6, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void firstPageMustBeAccessibleEvenIfTheFileIsNonEmptyButSmallerThanFilePageSize() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
                try (PageCursor cursor = pagedFile.io(0L, 6, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                cursor = pagedFile.io(0L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 6, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void firstPageMustNotBeAccessibleIfFileIsEmptyAndNoGrowSpecified() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
                try (PageCursor cursor = pagedFile.io(0L, 6, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                cursor = pagedFile.io(0L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 6, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void newlyWrittenPagesMustBeAccessibleWithNoGrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            int initialPages = 1;
            int pagesToAdd = 3;
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * initialPages, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL);){
                for (int i = 0; i < pagesToAdd; ++i) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    this.writeRecords(cursor);
                }
            }
            int pagesChecked = 0;
            try (PageCursor cursor = pagedFile.io(0L, 6, CursorContext.NULL);){
                while (cursor.next()) {
                    this.verifyRecordsMatchExpected(cursor);
                    ++pagesChecked;
                }
            }
            Assertions.assertThat((int)pagesChecked).isEqualTo(initialPages + pagesToAdd);
            pagesChecked = 0;
            cursor = pagedFile.io(0L, 1, CursorContext.NULL);
            try {
                while (cursor.next()) {
                    this.verifyRecordsMatchExpected(cursor);
                    ++pagesChecked;
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            Assertions.assertThat((int)pagesChecked).isEqualTo(initialPages + pagesToAdd);
            pagedFile.close();
        });
    }

    @Test
    void readLockImpliesNoGrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            int initialPages = 3;
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * initialPages, this.recordSize);
            int pagesChecked = 0;
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);){
                while (cursor.next()) {
                    ++pagesChecked;
                }
            }
            Assertions.assertThat((int)pagesChecked).isEqualTo(initialPages);
        });
    }

    @Test
    void retryMustResetCursorOffset() throws Exception {
        int i;
        this.configureStandardPageCache();
        PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
        AtomicReference caughtWriterException = new AtomicReference();
        CountDownLatch startLatch = new CountDownLatch(1);
        int expectedByte = 13;
        try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
            if (cursor.next()) {
                cursor.putByte((byte)13);
            }
        }
        AtomicBoolean end = new AtomicBoolean(false);
        Runnable writer = () -> {
            while (!end.get()) {
                try {
                    PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);
                    try {
                        if (cursor.next()) {
                            cursor.setOffset(this.recordSize);
                            cursor.putByte((byte)14);
                        }
                        startLatch.countDown();
                    }
                    finally {
                        if (cursor == null) continue;
                        cursor.close();
                    }
                }
                catch (IOException e) {
                    caughtWriterException.set(e);
                    throw new RuntimeException(e);
                }
            }
        };
        Future<?> writerFuture = executor.submit(writer);
        startLatch.await();
        long timeout = System.currentTimeMillis() + this.SHORT_TIMEOUT_MILLIS;
        for (i = 0; i < 1000 && System.currentTimeMillis() < timeout; ++i) {
            try (PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                do {
                    Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)13);
                } while (cursor.shouldRetry() && System.currentTimeMillis() < timeout);
                continue;
            }
        }
        end.set(true);
        writerFuture.get();
        org.junit.jupiter.api.Assertions.assertTrue((i > 1 ? 1 : 0) != 0);
        pagedFile.close();
    }

    @Test
    void nextWithPageIdMustAllowTraversingInReverse() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            long lastFilePageId = this.recordCount / this.recordsPerFilePage - 1;
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);){
                for (long currentPageId = lastFilePageId; currentPageId >= 0L; --currentPageId) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(currentPageId), (String)("next( currentPageId = " + currentPageId + " )"));
                    Assertions.assertThat((long)cursor.getCurrentPageId()).isEqualTo(currentPageId);
                    this.verifyRecordsMatchExpected(cursor);
                }
            }
        });
    }

    @Test
    void nextWithPageIdMustReturnFalseIfPageIdIsBeyondFilePageRangeAndNoGrowSpecified() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
                try (PageCursor cursor = pagedFile.io(0L, 6, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next(2L));
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(1L));
                }
                cursor = pagedFile.io(0L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next(2L));
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(1L));
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void pagesAddedWithNextWithPageIdMustBeAccessibleWithNoGrowSpecified() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(2L));
                this.writeRecords(cursor);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(0L));
                this.writeRecords(cursor);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(1L));
                this.writeRecords(cursor);
            }
            cursor = pagedFile.io(0L, 6, CursorContext.NULL);
            try {
                while (cursor.next()) {
                    this.verifyRecordsMatchExpected(cursor);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = pagedFile.io(0L, 1, CursorContext.NULL);
            try {
                while (cursor.next()) {
                    this.verifyRecordsMatchExpected(cursor);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.close();
        });
    }

    @Test
    void writesOfDifferentUnitsMustHaveCorrectEndianness() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), 23);){
                try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    byte[] data = new byte[]{42, 43, 44, 45, 46};
                    cursor.putLong(41L);
                    cursor.putInt(41);
                    cursor.putShort((short)41);
                    cursor.putByte((byte)41);
                    cursor.putBytes(data);
                    cursor.putBytes(3, (byte)47);
                }
                cursor = pagedFile.io(0L, 2, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    long a = cursor.getLong();
                    int b = cursor.getInt();
                    short c = cursor.getShort();
                    byte[] data = new byte[]{cursor.getByte(), cursor.getByte(), cursor.getByte(), cursor.getByte(), cursor.getByte(), cursor.getByte()};
                    byte d = cursor.getByte();
                    byte e = cursor.getByte();
                    byte f = cursor.getByte();
                    cursor.setOffset(0);
                    cursor.putLong(1L + a);
                    cursor.putInt(1 + b);
                    cursor.putShort((short)(1 + c));
                    for (byte g : data) {
                        g = (byte)(g + 1);
                        cursor.putByte(g);
                    }
                    cursor.putByte((byte)(1 + d));
                    cursor.putByte((byte)(1 + e));
                    cursor.putByte((byte)(1 + f));
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            ByteBuffer buf = ByteBuffers.allocate((int)23, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            try (StoreChannel channel = this.fs.read(this.file("a"));){
                channel.readAll(buf);
            }
            buf.flip();
            Assertions.assertThat((long)buf.getLong()).isEqualTo(42L);
            Assertions.assertThat((int)buf.getInt()).isEqualTo(42);
            Assertions.assertThat((short)buf.getShort()).isEqualTo((short)42);
            Assertions.assertThat((byte)buf.get()).isEqualTo((byte)42);
            Assertions.assertThat((byte)buf.get()).isEqualTo((byte)43);
            Assertions.assertThat((byte)buf.get()).isEqualTo((byte)44);
            Assertions.assertThat((byte)buf.get()).isEqualTo((byte)45);
            Assertions.assertThat((byte)buf.get()).isEqualTo((byte)46);
            Assertions.assertThat((byte)buf.get()).isEqualTo((byte)47);
            Assertions.assertThat((byte)buf.get()).isEqualTo((byte)48);
            Assertions.assertThat((byte)buf.get()).isEqualTo((byte)48);
            Assertions.assertThat((byte)buf.get()).isEqualTo((byte)48);
        });
    }

    @Test
    void mappingFileSecondTimeWithLesserPageSizeMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile ignore = this.map(this.file("a"), this.filePageSize);){
                org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.map(this.file("a"), this.filePageSize - 1));
            }
        });
    }

    @Test
    void mappingFileSecondTimeWithGreaterPageSizeMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile ignore = this.map(this.file("a"), this.filePageSize);){
                org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.map(this.file("a"), this.filePageSize + 1));
            }
        });
    }

    @Test
    void allowOpeningMultipleReadAndWriteCursorsPerThread() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            Path fileA = this.existingFile("a");
            Path fileB = this.existingFile("b");
            this.generateFileWithRecords(fileA, 1, 16);
            this.generateFileWithRecords(fileB, 1, 16);
            try (PagedFile pfA = this.map(fileA, this.filePageSize);
                 PagedFile pfB = this.map(fileB, this.filePageSize);
                 PageCursor a = pfA.io(0L, 1, CursorContext.NULL);
                 PageCursor b = pfA.io(0L, 1, CursorContext.NULL);
                 PageCursor c = pfA.io(0L, 2, CursorContext.NULL);
                 PageCursor d = pfA.io(0L, 2, CursorContext.NULL);
                 PageCursor e = pfB.io(0L, 1, CursorContext.NULL);
                 PageCursor f = pfB.io(0L, 1, CursorContext.NULL);
                 PageCursor g = pfB.io(0L, 2, CursorContext.NULL);
                 PageCursor h = pfB.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)a.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)b.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)c.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)d.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)e.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)f.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)g.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)h.next());
            }
        });
    }

    @Test
    void mustNotLiveLockIfWeRunOutOfEvictablePages() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            LinkedList cursors = new LinkedList();
            try (PagedFile pf = this.map(this.existingFile("a"), this.filePageSize);){
                try {
                    org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> {
                        long i = 0L;
                        while (true) {
                            PageCursor cursor = pf.io(i, 2, CursorContext.NULL);
                            cursors.add(cursor);
                            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                            ++i;
                        }
                    });
                }
                finally {
                    for (PageCursor cursor : cursors) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void writeLocksMustNotBeExclusive() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.existingFile("a"), this.filePageSize);
                 PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                executor.submit(() -> {
                    try (PageCursor innerCursor = pf.io(0L, 2, CursorContext.NULL);){
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)innerCursor.next());
                    }
                    return null;
                }).get();
            }
        });
    }

    @Test
    void writeLockMustInvalidateInnerReadLock() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.existingFile("a"), this.filePageSize);
                 PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                executor.submit(() -> {
                    try (PageCursor innerCursor = pf.io(0L, 1, CursorContext.NULL);){
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)innerCursor.next());
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)innerCursor.shouldRetry());
                    }
                    return null;
                }).get();
            }
        });
    }

    @Test
    void writeLockMustInvalidateExistingReadLock() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            BinaryLatch startLatch = new BinaryLatch();
            BinaryLatch continueLatch = new BinaryLatch();
            try (PagedFile pf = this.map(this.existingFile("a"), this.filePageSize);
                 PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Future<Object> read = executor.submit(() -> {
                    try (PageCursor innerCursor = pf.io(0L, 1, CursorContext.NULL);){
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)innerCursor.next());
                        org.junit.jupiter.api.Assertions.assertFalse((boolean)innerCursor.shouldRetry());
                        startLatch.release();
                        continueLatch.await();
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)innerCursor.shouldRetry());
                    }
                    return null;
                });
                startLatch.await();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(0L));
                continueLatch.release();
                read.get();
            }
        });
    }

    @Test
    void writeUnlockMustInvalidateReadLocks() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            BinaryLatch startLatch = new BinaryLatch();
            BinaryLatch continueLatch = new BinaryLatch();
            try (PagedFile pf = this.map(this.existingFile("a"), this.filePageSize);
                 PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Future<Object> read = executor.submit(() -> {
                    try (PageCursor innerCursor = pf.io(0L, 1, CursorContext.NULL);){
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)innerCursor.next());
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)innerCursor.shouldRetry());
                        startLatch.release();
                        continueLatch.await();
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)innerCursor.shouldRetry());
                    }
                    return null;
                });
                startLatch.await();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                continueLatch.release();
                read.get();
            }
        });
    }

    @Test
    void mustNotFlushCleanPagesWhenEvicting() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            final AtomicBoolean observedWrite = new AtomicBoolean();
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

                public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
                    StoreChannel channel = super.open(fileName, options);
                    return new DelegatingStoreChannel(channel){

                        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                            observedWrite.set(true);
                            throw new IOException("not allowed");
                        }

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            observedWrite.set(true);
                            throw new IOException("not allowed");
                        }

                        public void writeAll(ByteBuffer src) throws IOException {
                            observedWrite.set(true);
                            throw new IOException("not allowed");
                        }

                        public int write(ByteBuffer src) throws IOException {
                            observedWrite.set(true);
                            throw new IOException("not allowed");
                        }

                        public long write(ByteBuffer[] srcs) throws IOException {
                            observedWrite.set(true);
                            throw new IOException("not allowed");
                        }
                    };
                }
            };
            this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL);
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);){
                while (cursor.next()) {
                    this.verifyRecordsMatchExpected(cursor);
                }
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)observedWrite.get());
        });
    }

    @Test
    void evictionMustFlushPagesToTheRightFiles() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            int filePageSize2 = this.filePageSize - 3;
            long maxPageIdCursor1 = this.recordCount / this.recordsPerFilePage;
            Path file2 = this.file("b");
            long file2sizeBytes = (maxPageIdCursor1 + 17L) * (long)filePageSize2;
            try (OutputStream outputStream = this.fs.openAsOutputStream(file2, false);){
                int i = 0;
                while ((long)i < file2sizeBytes) {
                    outputStream.write(97);
                    ++i;
                }
                outputStream.flush();
            }
            try (PagedFile pagedFile1 = this.map(this.file("a"), this.filePageSize);
                 PagedFile pagedFile2 = this.map(file2, filePageSize2);){
                boolean cursorReady2;
                boolean cursorReady1;
                boolean moreWorkToDo;
                long pageId1 = 0L;
                long pageId2 = 0L;
                do {
                    try (PageCursor cursor = pagedFile1.io(pageId1, 2, CursorContext.NULL);){
                        boolean bl = cursorReady1 = cursor.next() && cursor.getCurrentPageId() < maxPageIdCursor1;
                        if (cursorReady1) {
                            this.writeRecords(cursor);
                            ++pageId1;
                        }
                    }
                    cursor = pagedFile2.io(pageId2, 6, CursorContext.NULL);
                    try {
                        cursorReady2 = cursor.next();
                        if (cursorReady2) {
                            for (int i = 0; i < filePageSize2; ++i) {
                                cursor.putByte((byte)98);
                            }
                            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.shouldRetry());
                        }
                        ++pageId2;
                    }
                    finally {
                        if (cursor != null) {
                            cursor.close();
                        }
                    }
                } while (moreWorkToDo = cursorReady1 || cursorReady2);
            }
            Assertions.assertThat((long)this.fs.getFileSize(file2)).isEqualTo(file2sizeBytes);
            try (InputStream inputStream = this.fs.openAsInputStream(file2);){
                int i = 0;
                while ((long)i < file2sizeBytes) {
                    int b = inputStream.read();
                    Assertions.assertThat((int)b).isEqualTo(98);
                    ++i;
                }
                Assertions.assertThat((int)inputStream.read()).isEqualTo(-1);
            }
            try (StoreChannel channel = this.fs.read(this.file("a"));){
                ByteBuffer bufB = ByteBuffers.allocate((int)this.recordSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                for (int i = 0; i < this.recordCount; ++i) {
                    this.bufA.clear();
                    channel.readAll(this.bufA);
                    this.bufA.flip();
                    bufB.clear();
                    PageCacheTest.generateRecordForId(i, bufB);
                    Assertions.assertThat((byte[])bufB.array()).containsExactly(this.bufA.array());
                }
            }
        });
    }

    @Test
    void tracerMustBeNotifiedAboutPinUnpinFaultAndEvictEventsWhenReading() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            DefaultPageCacheTracer tracer = new DefaultPageCacheTracer(true);
            this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)tracer);
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            long initialPins = tracer.pins();
            long initialUnpins = tracer.unpins();
            long countedPages = 0L;
            long countedFaults = 0L;
            try (CursorContext cursorContext = new CursorContext(tracer.createPageCursorTracer("tracerMustBeNotifiedAboutPinUnpinFaultAndEvictEventsWhenReading"));
                 PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 1, cursorContext);){
                int i;
                while (cursor.next()) {
                    ++countedPages;
                    ++countedFaults;
                }
                ++countedPages;
                for (i = 0; i < 20; ++i) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(1L));
                }
                for (i = 0; i < 20; ++i) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next((long)i));
                    ++countedPages;
                }
                ((AbstractLongAssert)Assertions.assertThat((long)pagedFile.pageFileCounters().pins()).as("wrong count of pins", new Object[0])).isEqualTo(countedPages + initialPins);
                ((AbstractLongAssert)Assertions.assertThat((long)pagedFile.pageFileCounters().unpins()).as("wrong count of unpins", new Object[0])).isEqualTo(countedPages + initialUnpins - 1L);
            }
            ((AbstractLongAssert)Assertions.assertThat((long)tracer.pins()).as("wrong count of pins", new Object[0])).isEqualTo(countedPages + initialPins);
            ((AbstractLongAssert)Assertions.assertThat((long)tracer.unpins()).as("wrong count of unpins", new Object[0])).isEqualTo(countedPages + initialUnpins);
            long faults = tracer.faults();
            long bytesRead = tracer.bytesRead();
            ((AbstractLongAssert)Assertions.assertThat((long)faults).as("wrong count of faults", new Object[0])).isGreaterThanOrEqualTo(countedFaults);
            ((AbstractLongAssert)Assertions.assertThat((long)bytesRead).as("wrong number of bytes read", new Object[0])).isGreaterThanOrEqualTo(countedFaults * (long)this.filePageSize);
            ((AbstractLongAssert)Assertions.assertThat((long)tracer.evictions()).as("wrong count of evictions", new Object[0])).isGreaterThanOrEqualTo(countedFaults - (long)this.maxPages).isLessThanOrEqualTo(countedPages + faults);
        });
    }

    @Test
    void tracerMustBeNotifiedAboutPinUnpinFaultFlushAndEvictionEventsWhenWriting() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            long pagesToGenerate = 142L;
            DefaultPageCacheTracer tracer = new DefaultPageCacheTracer(true);
            this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)tracer);
            long initialPins = tracer.pins();
            long initialUnpins = tracer.unpins();
            try (CursorContext cursorContext = new CursorContext(tracer.createPageCursorTracer("tracerMustBeNotifiedAboutPinUnpinFaultFlushAndEvictionEventsWhenWriting"));
                 PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                for (long i = 0L; i < pagesToGenerate; ++i) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertThat((long)cursor.getCurrentPageId()).isEqualTo(i);
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(i));
                    Assertions.assertThat((long)cursor.getCurrentPageId()).isEqualTo(i);
                    this.writeRecords(cursor);
                }
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(0L));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(0L));
                ((AbstractLongAssert)Assertions.assertThat((long)pagedFile.pageFileCounters().pins()).as("wrong count of pins", new Object[0])).isEqualTo(pagesToGenerate + 1L + initialPins);
                ((AbstractLongAssert)Assertions.assertThat((long)pagedFile.pageFileCounters().unpins()).as("wrong count of unpins", new Object[0])).isEqualTo(pagesToGenerate + initialPins);
            }
            ((AbstractLongAssert)Assertions.assertThat((long)tracer.pins()).as("wrong count of pins", new Object[0])).isEqualTo(pagesToGenerate + 1L + initialPins);
            ((AbstractLongAssert)Assertions.assertThat((long)tracer.unpins()).as("wrong count of unpins", new Object[0])).isEqualTo(pagesToGenerate + 1L + initialUnpins);
            long faults = tracer.faults();
            ((AbstractLongAssert)Assertions.assertThat((long)faults).as("wrong count of faults", new Object[0])).isGreaterThanOrEqualTo(pagesToGenerate);
            ((AbstractLongAssert)Assertions.assertThat((long)tracer.evictions()).as("wrong count of evictions", new Object[0])).isGreaterThanOrEqualTo(pagesToGenerate - (long)this.maxPages).isLessThanOrEqualTo(pagesToGenerate + faults);
            long flushes = tracer.flushes();
            long bytesWritten = tracer.bytesWritten();
            ((AbstractLongAssert)Assertions.assertThat((long)flushes).as("wrong count of flushes", new Object[0])).isGreaterThanOrEqualTo(pagesToGenerate - (long)this.maxPages);
            ((AbstractLongAssert)Assertions.assertThat((long)bytesWritten).as("wrong count of bytes written", new Object[0])).isGreaterThanOrEqualTo(pagesToGenerate * (long)this.filePageSize);
        });
    }

    @Test
    void tracerMustBeNotifiedOfReadAndWritePins() throws Exception {
        final AtomicInteger writeCount = new AtomicInteger();
        final AtomicInteger readCount = new AtomicInteger();
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        DefaultPageCursorTracer pageCursorTracer = new DefaultPageCursorTracer((PageCacheTracer)tracer, "test"){

            public PinEvent beginPin(boolean writeLock, long filePageId, PageSwapper swapper) {
                (writeLock ? writeCount : readCount).getAndIncrement();
                return super.beginPin(writeLock, filePageId, swapper);
            }
        };
        this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)tracer);
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        int pinsForRead = 13;
        int pinsForWrite = 42;
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
            try (PageCursor cursor = pagedFile.io(0L, 1, new CursorContext((PageCursorTracer)pageCursorTracer));){
                for (int i = 0; i < pinsForRead; ++i) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                }
            }
            PageCacheTest.dirtyManyPages(pagedFile, pinsForWrite, new CursorContext((PageCursorTracer)pageCursorTracer));
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)readCount.get()).as("wrong read pin count", new Object[0])).isEqualTo(pinsForRead);
        ((AbstractIntegerAssert)Assertions.assertThat((int)writeCount.get()).as("wrong write pin count", new Object[0])).isEqualTo(pinsForWrite);
    }

    @Test
    void restartByShouldRetryMustCarryOverExistingPin() throws IOException {
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)tracer);
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
             CursorContext cursorContext = new CursorContext(tracer.createPageCursorTracer("test"));
             PageCursor reader = pagedFile.io(0L, 1, cursorContext);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            try (PagedFile otherPagedFile = this.map(this.existingFile("b"), this.filePageSize);
                 PageCursor writer = otherPagedFile.io(0L, 2, cursorContext);){
                while (!reader.shouldRetry()) {
                    for (int i = 0; i < this.maxPages * 10; ++i) {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next((long)i));
                    }
                }
            }
        }
        Assertions.assertThat((long)tracer.unpins()).isEqualTo(tracer.pins());
    }

    @Test
    void pinEventShouldCompleteIfRepinFromShouldRetryThrows() throws IOException {
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        RandomAdversary adversary = new RandomAdversary(0.0, 0.9, 0.0);
        adversary.setProbabilityFactor(0.0);
        AdversarialFileSystemAbstraction afs = new AdversarialFileSystemAbstraction((Adversary)adversary, this.fs);
        this.getPageCache((FileSystemAbstraction)afs, this.maxPages, (PageCacheTracer)tracer);
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
             CursorContext cursorContext = new CursorContext(tracer.createPageCursorTracer("test"));
             PageCursor reader = pagedFile.io(0L, 1, cursorContext);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            try (PagedFile otherPagedFile = this.map(this.existingFile("b"), this.filePageSize);){
                org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> {
                    while (true) {
                        adversary.setProbabilityFactor(1.0);
                        try {
                            reader.shouldRetry();
                        }
                        finally {
                            adversary.setProbabilityFactor(0.0);
                        }
                        try (PageCursor writer = otherPagedFile.io(0L, 2, cursorContext);){
                            for (int i = 0; i < this.maxPages * 10; ++i) {
                                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next((long)i));
                            }
                        }
                        otherPagedFile.flushAndForce();
                    }
                });
            }
        }
        Assertions.assertThat((long)tracer.unpins()).isEqualTo(tracer.pins());
    }

    @Test
    void lastPageIdOfEmptyFileIsLessThanZero() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
            Assertions.assertThat((long)pagedFile.getLastPageId()).isLessThan(0L);
        }
    }

    @Test
    void lastPageIdOfFileWithOneByteIsZero() throws IOException {
        StoreChannel channel = this.fs.write(this.file("a"));
        channel.write(ByteBuffer.wrap(new byte[]{1}));
        channel.close();
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
            Assertions.assertThat((long)pagedFile.getLastPageId()).isEqualTo(0L);
        }
    }

    @Test
    void lastPageIdOfFileWithExactlyTwoPagesWorthOfDataIsOne() throws IOException {
        this.configureStandardPageCache();
        int twoPagesWorthOfRecords = this.recordsPerFilePage * 2;
        this.generateFileWithRecords(this.file("a"), twoPagesWorthOfRecords, this.recordSize);
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
            Assertions.assertThat((long)pagedFile.getLastPageId()).isEqualTo(1L);
        }
    }

    @Test
    void lastPageIdOfFileWithExactlyTwoPagesAndOneByteWorthOfDataIsTwo() throws IOException {
        this.configureStandardPageCache();
        int twoPagesWorthOfRecords = this.recordsPerFilePage * 2;
        this.generateFileWithRecords(this.file("a"), twoPagesWorthOfRecords, this.recordSize);
        OutputStream outputStream = this.fs.openAsOutputStream(this.file("a"), true);
        outputStream.write(97);
        outputStream.close();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
            Assertions.assertThat((long)pagedFile.getLastPageId()).isEqualTo(2L);
        }
    }

    @Test
    void lastPageIdMustNotIncreaseWhenReadingToEndWithReadLock() throws IOException {
        this.configureStandardPageCache();
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
        long initialLastPageId = pagedFile.getLastPageId();
        try (PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);){
            while (cursor.next()) {
            }
        }
        long resultingLastPageId = pagedFile.getLastPageId();
        pagedFile.close();
        Assertions.assertThat((long)resultingLastPageId).isEqualTo(initialLastPageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void lastPageIdMustNotIncreaseWhenReadingToEndWithNoGrowAndWriteLock() throws IOException {
        this.configureStandardPageCache();
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
        long initialLastPageId = pagedFile.getLastPageId();
        try (PageCursor cursor = pagedFile.io(0L, 6, CursorContext.NULL);){
            while (cursor.next()) {
            }
        }
        long resultingLastPageId = pagedFile.getLastPageId();
        try {
            Assertions.assertThat((long)resultingLastPageId).isEqualTo(initialLastPageId);
        }
        catch (Throwable throwable) {
            IOUtils.closeAllSilently((AutoCloseable[])new PagedFile[]{pagedFile});
            throw throwable;
        }
        IOUtils.closeAllSilently((AutoCloseable[])new PagedFile[]{pagedFile});
    }

    @Test
    void lastPageIdMustIncreaseWhenScanningPastEndWithWriteLock() throws IOException {
        this.configureStandardPageCache();
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 10, this.recordSize);
        PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
        Assertions.assertThat((long)pagedFile.getLastPageId()).isEqualTo(9L);
        PageCacheTest.dirtyManyPages(pagedFile, 15);
        try {
            Assertions.assertThat((long)pagedFile.getLastPageId()).isEqualTo(14L);
        }
        catch (Throwable throwable) {
            IOUtils.closeAllSilently((AutoCloseable[])new PagedFile[]{pagedFile});
            throw throwable;
        }
        IOUtils.closeAllSilently((AutoCloseable[])new PagedFile[]{pagedFile});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void lastPageIdMustIncreaseWhenJumpingPastEndWithWriteLock() throws IOException {
        this.configureStandardPageCache();
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 10, this.recordSize);
        PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
        Assertions.assertThat((long)pagedFile.getLastPageId()).isEqualTo(9L);
        try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(15L));
        }
        try {
            Assertions.assertThat((long)pagedFile.getLastPageId()).isEqualTo(15L);
        }
        catch (Throwable throwable) {
            IOUtils.closeAllSilently((AutoCloseable[])new PagedFile[]{pagedFile});
            throw throwable;
        }
        IOUtils.closeAllSilently((AutoCloseable[])new PagedFile[]{pagedFile});
    }

    @Test
    void lastPageIdFromUnmappedFileMustThrow() throws IOException {
        PagedFile file;
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, (ImmutableSet<OpenOption>)Sets.immutable.of((Object)StandardOpenOption.CREATE));){
            file = pf;
        }
        org.junit.jupiter.api.Assertions.assertThrows(FileIsNotMappedException.class, () -> ((PagedFile)file).getLastPageId());
    }

    @Test
    void cursorOffsetMustBeUpdatedReadAndWrite() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                this.verifyWriteOffsets(cursor);
                cursor.setOffset(0);
                PageCacheTest.verifyReadOffsets(cursor);
            }
            cursor = pagedFile.io(0L, 1, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                PageCacheTest.verifyReadOffsets(cursor);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    private void verifyWriteOffsets(PageCursor cursor) {
        cursor.setOffset(this.filePageSize / 2);
        cursor.zapPage();
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(this.filePageSize / 2);
        cursor.setOffset(0);
        cursor.putLong(1L);
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(8);
        cursor.putInt(1);
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(12);
        cursor.putShort((short)1);
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(14);
        cursor.putByte((byte)1);
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(15);
        cursor.putBytes(new byte[]{1, 2, 3});
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(18);
        cursor.putBytes(new byte[]{1, 2, 3}, 1, 1);
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(19);
        cursor.putBytes(5, (byte)1);
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(24);
    }

    private static void verifyReadOffsets(PageCursor cursor) {
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(0);
        cursor.getLong();
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(8);
        cursor.getInt();
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(12);
        cursor.getShort();
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(14);
        cursor.getByte();
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(15);
        cursor.getBytes(new byte[3]);
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(18);
        cursor.getBytes(new byte[3], 1, 1);
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(19);
        cursor.getBytes(new byte[5]);
        Assertions.assertThat((int)cursor.getOffset()).isEqualTo(24);
        byte[] expectedBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 2, 3, 2, 1, 1, 1, 1, 1};
        byte[] actualBytes = new byte[24];
        cursor.setOffset(0);
        cursor.getBytes(actualBytes);
        Assertions.assertThat((byte[])actualBytes).containsExactly(expectedBytes);
    }

    @Test
    void getBytesMustRespectOffsets() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            cursor.putByte((byte)1);
            cursor.putByte((byte)2);
            cursor.putByte((byte)3);
            cursor.putByte((byte)4);
            cursor.putByte((byte)5);
            cursor.putByte((byte)6);
            cursor.putByte((byte)7);
            cursor.putByte((byte)8);
            byte[] data = new byte[]{42, 42, 42, 42, 42};
            cursor.setOffset(1);
            cursor.getBytes(data, 1, 3);
            byte[] expected = new byte[]{42, 2, 3, 4, 42};
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])expected, (byte[])data);
        }
    }

    @Test
    void putBytesMustRespectOffsets() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            cursor.putByte((byte)1);
            cursor.putByte((byte)2);
            cursor.putByte((byte)3);
            cursor.putByte((byte)4);
            cursor.putByte((byte)5);
            cursor.putByte((byte)6);
            cursor.putByte((byte)7);
            cursor.putByte((byte)8);
            byte[] data = new byte[]{42, 41, 40, 39, 38};
            cursor.setOffset(1);
            cursor.putBytes(data, 1, 3);
            cursor.setOffset(0);
            Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)1);
            Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)41);
            Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)40);
            Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)39);
            Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)5);
            Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)6);
            Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)7);
            Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)8);
        }
    }

    @Test
    void getBytesMustRespectLargeOffsets() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            int i;
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            for (int i2 = 0; i2 < 200; ++i2) {
                cursor.putByte((byte)(i2 + 1));
            }
            byte[] data = new byte[200];
            for (i = 0; i < data.length; ++i) {
                data[i] = (byte)(data.length - i);
            }
            cursor.setOffset(1);
            cursor.getBytes(data, 1, data.length - 2);
            Assertions.assertThat((byte)data[0]).isEqualTo((byte)-56);
            for (i = 1; i < 199; ++i) {
                Assertions.assertThat((byte)data[i]).isEqualTo((byte)(i + 1));
            }
            Assertions.assertThat((byte)data[199]).isEqualTo((byte)1);
        }
    }

    @Test
    void putBytesMustRespectLargeOffsets() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            int i;
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            for (int i2 = 0; i2 < 200; ++i2) {
                cursor.putByte((byte)(i2 + 1));
            }
            byte[] data = new byte[200];
            for (i = 0; i < data.length; ++i) {
                data[i] = (byte)(data.length - i);
            }
            cursor.setOffset(1);
            cursor.putBytes(data, 1, data.length - 2);
            cursor.setOffset(0);
            Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)1);
            for (i = 0; i < 198; ++i) {
                Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)(199 - i));
            }
            Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)-56);
        }
    }

    @Test
    void getBytesMustThrowArrayIndexOutOfBounds() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            byte[] bytes = new byte[3];
            org.junit.jupiter.api.Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> cursor.getBytes(bytes, 1, 3));
        }
    }

    @Test
    void putBytesMustThrowArrayIndexOutOfBounds() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            byte[] bytes = new byte[3];
            org.junit.jupiter.api.Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> cursor.putBytes(bytes, 1, 3));
        }
    }

    @Test
    void closeOnPageCacheMustThrowIfFilesAreStillMapped() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile ignore = this.map(this.file("a"), this.filePageSize);){
                org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.pageCache.close());
            }
        });
    }

    @Test
    void pagedFileIoMustThrowIfFileIsUnmapped() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            PageCacheTest.closeThisPagedFile(pagedFile);
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                FileIsNotMappedException exception = (FileIsNotMappedException)org.junit.jupiter.api.Assertions.assertThrows(FileIsNotMappedException.class, () -> ((PageCursor)cursor).next());
                StringWriter out = new StringWriter();
                exception.printStackTrace(new PrintWriter(out));
                Assertions.assertThat((String)out.toString()).contains(new CharSequence[]{"closeThisPagedFile"});
            }
        });
    }

    private static void closeThisPagedFile(PagedFile pagedFile) {
        pagedFile.close();
    }

    @Test
    void writeLockedPageCursorNextMustThrowIfFileIsUnmapped() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);
            PageCacheTest.closeThisPagedFile(pagedFile);
            FileIsNotMappedException exception = (FileIsNotMappedException)org.junit.jupiter.api.Assertions.assertThrows(FileIsNotMappedException.class, () -> ((PageCursor)cursor).next());
            StringWriter out = new StringWriter();
            exception.printStackTrace(new PrintWriter(out));
            Assertions.assertThat((String)out.toString()).contains(new CharSequence[]{"closeThisPagedFile"});
        });
    }

    @Test
    void writeLockedPageCursorNextWithIdMustThrowIfFileIsUnmapped() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);
            pagedFile.close();
            org.junit.jupiter.api.Assertions.assertThrows(FileIsNotMappedException.class, () -> cursor.next(1L));
        });
    }

    @Test
    void readLockedPageCursorNextMustThrowIfFileIsUnmapped() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);
            pagedFile.close();
            org.junit.jupiter.api.Assertions.assertThrows(FileIsNotMappedException.class, () -> ((PageCursor)cursor).next());
        });
    }

    @Test
    void readLockedPageCursorNextWithIdMustThrowIfFileIsUnmapped() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);
            pagedFile.close();
            org.junit.jupiter.api.Assertions.assertThrows(FileIsNotMappedException.class, () -> cursor.next(1L));
        });
    }

    @Test
    void writeLockedPageMustBlockFileUnmapping() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            Thread unmapper = ThreadTestUtils.fork((Runnable)PageCacheTest.closePageFile(pagedFile));
            unmapper.join(100L);
            cursor.close();
            unmapper.join();
        });
    }

    @Test
    void optimisticReadLockedPageMustNotBlockFileUnmapping() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            ThreadTestUtils.fork((Runnable)PageCacheTest.closePageFile(pagedFile)).join();
            cursor.close();
        });
    }

    @Test
    void advancingPessimisticReadLockingCursorAfterUnmappingMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            ThreadTestUtils.fork((Runnable)PageCacheTest.closePageFile(pagedFile)).join();
            org.junit.jupiter.api.Assertions.assertThrows(FileIsNotMappedException.class, () -> ((PageCursor)cursor).next());
        });
    }

    @Test
    void advancingOptimisticReadLockingCursorAfterUnmappingMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(0L));
            ThreadTestUtils.fork((Runnable)PageCacheTest.closePageFile(pagedFile)).join();
            org.junit.jupiter.api.Assertions.assertThrows(FileIsNotMappedException.class, () -> ((PageCursor)cursor).next());
        });
    }

    @Test
    void readingAndRetryingOnPageWithOptimisticReadLockingAfterUnmappingMustNotThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(0L));
            ThreadTestUtils.fork((Runnable)PageCacheTest.closePageFile(pagedFile)).join();
            this.pageCache.close();
            this.pageCache = null;
            cursor.getByte();
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ((PageCursor)cursor).shouldRetry());
            org.junit.jupiter.api.Assertions.assertThrows(FileIsNotMappedException.class, () -> ((PageCursor)cursor).next());
        });
    }

    @Test
    void shouldRetryFromUnboundReadCursorMustNotThrow() throws Exception {
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor cursor = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.shouldRetry());
        }
    }

    @Test
    void shouldRetryFromUnboundWriteCursorMustNotThrow() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.shouldRetry());
        }
    }

    @Test
    void shouldRetryFromUnboundLinkedReadCursorMustNotThrow() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor cursor = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            try (PageCursor linked = cursor.openLinkedCursor(1L);){
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.shouldRetry());
            }
        }
    }

    @Test
    void shouldRetryFromUnboundLinkedWriteCursorMustNotThrow() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            try (PageCursor linked = cursor.openLinkedCursor(1L);){
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.shouldRetry());
            }
        }
    }

    @Test
    void shouldRetryOnWriteParentOfClosedLinkedCursorMustNotThrow() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            try (PageCursor linked = cursor.openLinkedCursor(1L);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)linked.next());
            }
            cursor.shouldRetry();
        }
    }

    @Test
    void shouldRetryOnReadParentOfClosedLinkedCursorMustNotThrow() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor cursor = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            try (PageCursor linked = cursor.openLinkedCursor(1L);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)linked.next());
            }
            cursor.shouldRetry();
        }
    }

    @Test
    void shouldRetryOnReadParentOnDirtyPageOfClosedLinkedCursorMustNotThrow() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            try (PageCursor writer = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            }
            try (PageCursor linked = reader.openLinkedCursor(1L);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)linked.next());
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.shouldRetry());
        }
    }

    @Test
    void pageCursorCloseShouldNotReturnAlreadyClosedLinkedCursorToPool() throws Exception {
        this.getPageCache(this.fs, this.maxPages, PageCacheTracer.NULL);
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);){
            PageCursor a = pf.io(0L, 2, CursorContext.NULL);
            PageCursor b = a.openLinkedCursor(0L);
            b.close();
            PageCursor c = a.openLinkedCursor(0L);
            PageCursor d = pf.io(0L, 2, CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertNotSame((Object)c, (Object)d);
            c.close();
            d.close();
        }
    }

    @Test
    void pageCursorCloseShouldNotReturnSameObjectToCursorPoolTwice() throws Exception {
        this.getPageCache(this.fs, this.maxPages, PageCacheTracer.NULL);
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);){
            PageCursor a = pf.io(0L, 2, CursorContext.NULL);
            a.close();
            a.close();
            PageCursor b = pf.io(0L, 2, CursorContext.NULL);
            PageCursor c = pf.io(0L, 2, CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertNotSame((Object)b, (Object)c);
            b.close();
            c.close();
        }
    }

    @Test
    void pageCursorCloseWithClosedLinkedCursorShouldNotReturnSameObjectToCursorPoolTwice() throws Exception {
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, PageCacheTracer.NULL);
        try (PagedFile pf = this.map(file, this.filePageSize);){
            PageCursor a = pf.io(0L, 2, CursorContext.NULL);
            a.openLinkedCursor(0L);
            a.openLinkedCursor(0L).close();
            a.close();
            PageCursor x = pf.io(0L, 2, CursorContext.NULL);
            PageCursor y = pf.io(0L, 2, CursorContext.NULL);
            PageCursor z = pf.io(0L, 2, CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertNotSame((Object)x, (Object)y);
            org.junit.jupiter.api.Assertions.assertNotSame((Object)x, (Object)z);
            org.junit.jupiter.api.Assertions.assertNotSame((Object)y, (Object)z);
            x.close();
            y.close();
            z.close();
        }
    }

    @Test
    void pageCursorCloseMustNotClosePreviouslyLinkedCursorThatGotReused() throws Exception {
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, PageCacheTracer.NULL);
        try (PagedFile pf = this.map(file, this.filePageSize);){
            PageCursor a = pf.io(0L, 2, CursorContext.NULL);
            a.openLinkedCursor(0L).close();
            PageCursor x = pf.io(0L, 2, CursorContext.NULL);
            a.close();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)x.next(1L));
            x.close();
        }
    }

    @Test
    void getByteBeyondPageEndMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(PageCursor::getByte));
    }

    @Test
    void putByteBeyondPageEndMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(cursor -> cursor.putByte((byte)42)));
    }

    @Test
    void getShortBeyondPageEndMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(PageCursor::getShort));
    }

    @Test
    void putShortBeyondPageEndMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(cursor -> cursor.putShort((short)42)));
    }

    @Test
    void getIntBeyondPageEndMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(PageCursor::getInt));
    }

    @Test
    void putIntBeyondPageEndMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(cursor -> cursor.putInt(42)));
    }

    @Test
    void putLongBeyondPageEndMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(cursor -> cursor.putLong(42L)));
    }

    @Test
    void getLongBeyondPageEndMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(PageCursor::getLong));
    }

    @Test
    void putBytesBeyondPageEndMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            byte[] bytes = new byte[]{1, 2, 3};
            this.verifyPageBounds(cursor -> cursor.putBytes(bytes));
        });
    }

    @Test
    void putBytesRepeatedByteBeyondPageEndMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(cursor -> cursor.putBytes(3, (byte)1)));
    }

    @Test
    void getBytesBeyondPageEndMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            byte[] bytes = new byte[3];
            this.verifyPageBounds(cursor -> cursor.getBytes(bytes));
        });
    }

    @Test
    void putBytesWithOffsetAndLengthBeyondPageEndMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            byte[] bytes = new byte[]{1, 2, 3};
            this.verifyPageBounds(cursor -> cursor.putBytes(bytes, 1, 1));
        });
    }

    @Test
    void getBytesWithOffsetAndLengthBeyondPageEndMustThrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            byte[] bytes = new byte[3];
            this.verifyPageBounds(cursor -> cursor.getBytes(bytes, 1, 1));
        });
    }

    private void verifyPageBounds(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
            cursor.next();
            org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> {
                for (int i = 0; i < 100000; ++i) {
                    action.apply(cursor);
                    if (!cursor.checkAndClearBoundsFlag()) continue;
                    throw new IndexOutOfBoundsException();
                }
            });
        }
    }

    @Test
    void shouldRetryMustClearBoundsFlagWhenReturningTrue() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
                 PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
                PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                reader.getByte(-1);
                writer.close();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.shouldRetry());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)reader.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void shouldRetryMustNotClearBoundsFlagWhenReturningFalse() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
                 PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
                PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                writer.close();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                reader.getByte(-1);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)reader.shouldRetry());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void nextThatReturnsTrueMustNotClearBoundsFlagOnReadCursor() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
                 PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
                PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                reader.getByte(-1);
                writer.next();
                writer.close();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void nextThatReturnsTrueMustNotClearBoundsFlagOnWriteCursor() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
                 PageCursor writer = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                writer.getByte(-1);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void nextThatReturnsFalseMustNotClearBoundsFlagOnReadCursor() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
                 PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
                PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                reader.getByte(-1);
                writer.close();
                org.junit.jupiter.api.Assertions.assertFalse((boolean)reader.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void nextThatReturnsFalseMustNotClearBoundsFlagOnWriteCursor() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            Path file = this.file("a");
            this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
            try (PagedFile pf = this.map(file, this.filePageSize);
                 PageCursor writer = pf.io(0L, 6, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                writer.getByte(-1);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)writer.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void nextWithPageIdThatReturnsTrueMustNotClearBoundsFlagOnReadCursor() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
                 PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
                PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                reader.getByte(-1);
                writer.next(3L);
                writer.close();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next(3L));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void nextWithPageIdMustNotClearBoundsFlagOnWriteCursor() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
                 PageCursor writer = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                writer.getByte(-1);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next(3L));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void settingOutOfBoundsCursorOffsetMustRaiseBoundsFlag() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);){
                cursor.setOffset(-1);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
                cursor.setOffset(this.filePageSize + 1);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
                cursor.setOffset(this.pageCachePageSize + 1);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void manuallyRaisedBoundsFlagMustBeObservable() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
             PageCursor writer = pagedFile.io(0L, 2, CursorContext.NULL);
             PageCursor reader = pagedFile.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            writer.raiseOutOfBounds();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            reader.raiseOutOfBounds();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
        }
    }

    @Test
    void pageFaultForWriteMustThrowIfOutOfStorageSpace() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            final AtomicInteger writeCounter = new AtomicInteger();
            final AtomicBoolean restrictWrites = new AtomicBoolean(true);
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){
                private final List channels;
                {
                    super(delegate);
                    this.channels = new CopyOnWriteArrayList();
                }

                public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
                    DelegatingStoreChannel channel = new DelegatingStoreChannel(super.open(fileName, options)){

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            if (restrictWrites.get() && writeCounter.incrementAndGet() > 10) {
                                throw new IOException("No space left on device");
                            }
                            super.writeAll(src, position);
                        }
                    };
                    this.channels.add(channel);
                    return channel;
                }

                public void close() throws IOException {
                    IOUtils.closeAll((Collection)this.channels);
                    super.close();
                }
            };
            fs.write(this.file("a")).close();
            this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> {
                    while (cursor.next()) {
                    }
                });
            }
            finally {
                restrictWrites.set(false);
                pagedFile.close();
                this.pageCache.close();
                fs.close();
            }
        });
    }

    @Test
    void pageFaultForReadMustThrowIfOutOfStorageSpace() {
        try {
            org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
                final AtomicInteger writeCounter = new AtomicInteger();
                final AtomicBoolean restrictWrites = new AtomicBoolean(true);
                DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){
                    private final List channels;
                    {
                        super(delegate);
                        this.channels = new CopyOnWriteArrayList();
                    }

                    public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
                        DelegatingStoreChannel channel = new DelegatingStoreChannel(super.open(fileName, options)){

                            public void writeAll(ByteBuffer src, long position) throws IOException {
                                if (restrictWrites.get() && writeCounter.incrementAndGet() >= 1) {
                                    throw new IOException("No space left on device");
                                }
                                super.writeAll(src, position);
                            }
                        };
                        this.channels.add(channel);
                        return channel;
                    }

                    public void close() throws IOException {
                        IOUtils.closeAll((Collection)this.channels);
                        super.close();
                    }
                };
                this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL);
                this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
                PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
                try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                }
                try {
                    cursor = pagedFile.io(0L, 1, CursorContext.NULL);
                    try {
                        while (true) {
                            if (cursor.next()) {
                                continue;
                            }
                            cursor.rewind();
                        }
                    }
                    catch (Throwable throwable) {
                        if (cursor != null) {
                            try {
                                cursor.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    restrictWrites.set(false);
                    pagedFile.close();
                    this.pageCache.close();
                    fs.close();
                    throw throwable;
                }
            });
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(IOException.class);
        }
    }

    @Test
    void mustRecoverViaFileCloseFromFullDriveWhenMoreStorageBecomesAvailable() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            final AtomicBoolean hasSpace = new AtomicBoolean();
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

                public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
                    return new DelegatingStoreChannel(super.open(fileName, options)){

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            if (!hasSpace.get()) {
                                throw new IOException("No space left on device");
                            }
                            super.writeAll(src, position);
                        }
                    };
                }
            };
            fs.write(this.file("a")).close();
            this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            try {
                PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);
                try {
                    while (true) {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                        this.writeRecords(cursor);
                    }
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException cursor) {
                hasSpace.set(true);
                pagedFile.close();
                try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
                     PageCursor cursor2 = pf.io(0L, 1, CursorContext.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor2.next());
                }
                return;
            }
        });
    }

    @Test
    void mustRecoverViaFileFlushFromFullDriveWhenMoreStorageBecomesAvailable() throws Exception {
        PageCursor cursor2;
        final AtomicBoolean hasSpace = new AtomicBoolean();
        final AtomicBoolean hasThrown = new AtomicBoolean();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

            public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, options)){

                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        if (!hasSpace.get()) {
                            hasThrown.set(true);
                            throw new IOException("No space left on device");
                        }
                        super.writeAll(src, position);
                    }
                };
            }
        };
        fs.write(this.file("a")).close();
        this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL);
        PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
        try {
            cursor2 = pagedFile.io(0L, 2, CursorContext.NULL);
            try {
                while (!hasThrown.get()) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor2.next());
                    this.writeRecords(cursor2);
                }
            }
            finally {
                if (cursor2 != null) {
                    cursor2.close();
                }
            }
        }
        catch (IOException cursor2) {
            // empty catch block
        }
        hasSpace.set(true);
        pagedFile.flushAndForce();
        cursor2 = pagedFile.io(0L, 1, CursorContext.NULL);
        try {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor2.next());
        }
        finally {
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        pagedFile.close();
    }

    @Test
    void dataFromDifferentFilesMustNotBleedIntoEachOther() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            int i;
            this.configureStandardPageCache();
            Path fileB = this.existingFile("b");
            int filePageSizeA = this.pageCachePageSize - 2;
            int filePageSizeB = this.pageCachePageSize - 6;
            int pagesToWriteA = 100;
            int pagesToWriteB = 3;
            PagedFile pagedFileA = this.map(this.existingFile("a"), filePageSizeA);
            try (PageCursor cursor = pagedFileA.io(0L, 2, CursorContext.NULL);){
                for (int i2 = 0; i2 < pagesToWriteA; ++i2) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    for (int j = 0; j < filePageSizeA; ++j) {
                        cursor.putByte((byte)42);
                    }
                }
            }
            PagedFile pagedFileB = this.map(fileB, filePageSizeB);
            try (PageCursor cursor = pagedFileB.io(0L, 2, CursorContext.NULL);){
                for (i = 0; i < pagesToWriteB; ++i) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putByte((byte)63);
                }
            }
            pagedFileA.close();
            pagedFileB.close();
            InputStream inputStream = this.fs.openAsInputStream(fileB);
            ((AbstractIntegerAssert)Assertions.assertThat((int)inputStream.read()).as("first page first byte", new Object[0])).isEqualTo(63);
            for (i = 0; i < filePageSizeB - 1; ++i) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)inputStream.read()).as("page 0 byte pos " + i, new Object[0])).isEqualTo(0);
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)inputStream.read()).as("second page first byte", new Object[0])).isEqualTo(63);
            for (i = 0; i < filePageSizeB - 1; ++i) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)inputStream.read()).as("page 1 byte pos " + i, new Object[0])).isEqualTo(0);
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)inputStream.read()).as("third page first byte", new Object[0])).isEqualTo(63);
            for (i = 0; i < filePageSizeB - 1; ++i) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)inputStream.read()).as("page 2 byte pos " + i, new Object[0])).isEqualTo(0);
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)inputStream.read()).as("expect EOF", new Object[0])).isEqualTo(-1);
        });
    }

    @Test
    void freshlyCreatedPagesMustContainAllZeros() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            int j;
            int i;
            PageCursor cursor;
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.existingFile("a"), this.filePageSize);){
                cursor = pagedFile.io(0L, 2, CursorContext.NULL);
                try {
                    for (i = 0; i < 100; ++i) {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                        for (j = 0; j < this.filePageSize; ++j) {
                            cursor.putByte((byte)rng.nextInt());
                        }
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            this.pageCache.close();
            this.pageCache = null;
            this.configureStandardPageCache();
            pagedFile = this.map(this.existingFile("b"), this.filePageSize);
            try {
                cursor = pagedFile.io(0L, 2, CursorContext.NULL);
                try {
                    for (i = 0; i < 100; ++i) {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                        for (j = 0; j < this.filePageSize; ++j) {
                            Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)0);
                        }
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            finally {
                if (pagedFile != null) {
                    pagedFile.close();
                }
            }
        });
    }

    @Test
    void optimisticReadLockMustFaultOnRetryIfPageHasBeenEvicted() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            int a = 97;
            int b = 98;
            Path fileA = this.existingFile("a");
            Path fileB = this.existingFile("b");
            this.configureStandardPageCache();
            PagedFile pagedFileA = this.map(fileA, this.filePageSize);
            PagedFile pagedFileB = this.map(fileB, this.filePageSize);
            try (PageCursor cursor = pagedFileA.io(0L, 2, CursorContext.NULL);){
                for (int i = 0; i < this.maxPages; ++i) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    for (int j = 0; j < this.filePageSize; ++j) {
                        cursor.putByte((byte)97);
                    }
                }
            }
            Runnable fillPagedFileB = () -> {
                try (PageCursor cursor = pagedFileB.io(0L, 2, CursorContext.NULL);){
                    for (int i = 0; i < this.maxPages * 30; ++i) {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                        for (int j = 0; j < this.filePageSize; ++j) {
                            cursor.putByte((byte)98);
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
            try (PageCursor cursor = pagedFileA.io(0L, 1, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(0L));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(0L));
                for (int i = 0; i < this.filePageSize; ++i) {
                    Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)97);
                }
                ThreadTestUtils.fork((Runnable)fillPagedFileB).join();
                if (cursor.shouldRetry()) {
                    int actual;
                    int expected = 97 * this.filePageSize;
                    do {
                        actual = 0;
                        for (int i = 0; i < this.filePageSize; ++i) {
                            actual += cursor.getByte();
                        }
                    } while (cursor.shouldRetry());
                    Assertions.assertThat((int)actual).isEqualTo(expected);
                }
            }
            pagedFileA.close();
            pagedFileB.close();
        });
    }

    @Test
    void pagesMustReturnToFreelistIfSwapInThrows() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);
            int iterations = this.maxPages * 2;
            PageCacheTest.accessPagesWhileInterrupted(pagedFile, 1, iterations);
            PageCacheTest.accessPagesWhileInterrupted(pagedFile, 2, iterations);
            Thread.interrupted();
            try (PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                this.verifyRecordsMatchExpected(cursor);
            }
            pagedFile.close();
        });
    }

    private static void accessPagesWhileInterrupted(PagedFile pagedFile, int pf_flags, int iterations) throws IOException {
        try (PageCursor cursor = pagedFile.io(0L, pf_flags, CursorContext.NULL);){
            for (int i = 0; i < iterations; ++i) {
                Thread.currentThread().interrupt();
                try {
                    cursor.next(0L);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    void mustSupportUnalignedWordAccesses() throws Exception {
        this.getPageCache(this.fs, 5, PageCacheTracer.NULL);
        int pageSize = this.pageCache.pageSize();
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        try (PagedFile pagedFile = this.map(this.file("a"), pageSize);
             PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            long x = rng.nextLong();
            int limit = pageSize - 8;
            for (int i = 0; i < limit; ++i) {
                cursor.setOffset(i);
                cursor.putLong(x += (long)i);
                cursor.setOffset(i);
                long y = cursor.getLong();
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag(), (String)"Should not have had a page out-of-bounds access!");
                if (x == y) continue;
                String reason = "Failed to read back the value that was written at offset " + Long.toHexString(i);
                ((AbstractStringAssert)Assertions.assertThat((String)Long.toHexString(y)).as(reason, new Object[0])).isEqualTo(Long.toHexString(x));
            }
        }
    }

    @RepeatedTest(value=50)
    void mustEvictPagesFromUnmappedFiles() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            PageCursor cursor;
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
                cursor = pagedFile.io(0L, 2, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            pagedFile = this.map(this.file("a"), this.filePageSize);
            try {
                cursor = pagedFile.io(0L, 2, CursorContext.NULL);
                try {
                    for (int i = 0; i < this.maxPages + 5; ++i) {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            finally {
                if (pagedFile != null) {
                    pagedFile.close();
                }
            }
        });
    }

    @Test
    void mustReadZerosFromBeyondEndOfFile() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            StandardRecordFormat recordFormat = new StandardRecordFormat();
            Path[] files = new Path[]{this.file("1"), this.file("2"), this.file("3"), this.file("4"), this.file("5"), this.file("6"), this.file("7"), this.file("8"), this.file("9"), this.file("0"), this.file("A"), this.file("B")};
            for (int fileId = 0; fileId < files.length; ++fileId) {
                Path file = files[fileId];
                StoreChannel channel = this.fs.write(file);
                for (int recordId = 0; recordId < fileId + 1; ++recordId) {
                    Record record = recordFormat.createRecord(file, recordId, (int)(channel.position() / 8192L), (int)(channel.position() % 8192L));
                    recordFormat.writeRecord(record, channel);
                }
                channel.close();
            }
            this.getPageCache(this.fs, 2, PageCacheTracer.NULL);
            int pageSize = this.pageCache.pageSize();
            int fileId = files.length;
            while (fileId-- > 0) {
                Path file = files[fileId];
                PagedFile pf = this.map(file, pageSize);
                try {
                    PageCursor cursor = pf.io(0L, 1, CursorContext.NULL);
                    try {
                        int pageCount = 0;
                        while (cursor.next()) {
                            ++pageCount;
                            recordFormat.assertRecordsWrittenCorrectly(cursor);
                        }
                        ((AbstractIntegerAssert)Assertions.assertThat((int)pageCount).as("pages in file " + String.valueOf(file), new Object[0])).isGreaterThan(0);
                    }
                    finally {
                        if (cursor == null) continue;
                        cursor.close();
                    }
                }
                finally {
                    if (pf == null) continue;
                    pf.close();
                }
            }
        });
    }

    @Test
    void mustThrowWhenMappingNonExistingFile() {
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchFileException.class, () -> {
            this.configureStandardPageCache();
            this.map(this.file("does not exist"), this.filePageSize);
        });
    }

    @Test
    void mustCreateNonExistingFileWithCreateOption() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("does not exist"), this.filePageSize, (ImmutableSet<OpenOption>)Sets.immutable.of((Object)StandardOpenOption.CREATE));
                 PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
        });
    }

    @Test
    void mustIgnoreCreateOptionIfFileAlreadyExists() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, (ImmutableSet<OpenOption>)Sets.immutable.of((Object)StandardOpenOption.CREATE));
                 PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
        });
    }

    @Test
    void mustIgnoreCertainOpenOptions() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, (ImmutableSet<OpenOption>)Sets.immutable.of((Object)StandardOpenOption.READ, (Object)StandardOpenOption.WRITE, (Object)StandardOpenOption.APPEND, (Object)StandardOpenOption.SPARSE));
                 PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
        });
    }

    @Test
    void mustThrowOnUnsupportedOpenOptions() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.verifyMappingWithOpenOptionThrows(StandardOpenOption.CREATE_NEW);
            this.verifyMappingWithOpenOptionThrows(StandardOpenOption.SYNC);
            this.verifyMappingWithOpenOptionThrows(StandardOpenOption.DSYNC);
            this.verifyMappingWithOpenOptionThrows(new OpenOption(){

                public String toString() {
                    return "NonStandardOpenOption";
                }
            });
        });
    }

    private void verifyMappingWithOpenOptionThrows(OpenOption option) throws IOException {
        try {
            this.map(this.file("a"), this.filePageSize, (ImmutableSet<OpenOption>)Sets.immutable.of((Object)option)).close();
            org.junit.jupiter.api.Assertions.fail((String)("Expected map() to throw when given the OpenOption " + String.valueOf(option)));
        }
        catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
    }

    @Test
    void mappingFileWithTruncateOptionMustTruncateFile() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            PageCursor cursor;
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);){
                cursor = pf.io(10L, 2, CursorContext.NULL);
                try {
                    Assertions.assertThat((long)pf.getLastPageId()).isLessThan(0L);
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putInt(-889275714);
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            pf = this.map(this.file("a"), this.filePageSize, (ImmutableSet<OpenOption>)Sets.immutable.of((Object)StandardOpenOption.TRUNCATE_EXISTING));
            try {
                cursor = pf.io(0L, 1, CursorContext.NULL);
                try {
                    Assertions.assertThat((long)pf.getLastPageId()).isLessThan(0L);
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            finally {
                if (pf != null) {
                    pf.close();
                }
            }
        });
    }

    @Test
    void mappingAlreadyMappedFileWithTruncateOptionMustThrow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile first = this.map(this.file("a"), this.filePageSize);){
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> {
                PagedFile second = this.map(this.file("a"), this.filePageSize, (ImmutableSet<OpenOption>)Sets.immutable.of((Object)StandardOpenOption.TRUNCATE_EXISTING));
                if (second != null) {
                    second.close();
                }
            });
        }
    }

    @Test
    void mustThrowIfFileIsClosedMoreThanItIsMapped() throws Exception {
        this.configureStandardPageCache();
        PagedFile pf = this.map(this.file("a"), this.filePageSize);
        pf.close();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((PagedFile)pf).close());
    }

    @Test
    void fileMappedWithDeleteOnCloseMustNotExistAfterUnmap() throws Exception {
        this.configureStandardPageCache();
        this.map(this.file("a"), this.filePageSize, (ImmutableSet<OpenOption>)Sets.immutable.of((Object)StandardOpenOption.DELETE_ON_CLOSE)).close();
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchFileException.class, () -> this.map(this.file("a"), this.filePageSize));
    }

    @Test
    void fileMappedWithDeleteOnCloseMustNotExistAfterLastUnmap() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        try (PagedFile ignore = this.map(file, this.filePageSize);){
            this.map(file, this.filePageSize, (ImmutableSet<OpenOption>)Sets.immutable.of((Object)StandardOpenOption.DELETE_ON_CLOSE)).close();
        }
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchFileException.class, () -> this.map(file, this.filePageSize));
    }

    @Test
    void fileMappedWithDeleteOnCloseShouldNotFlushDirtyPagesOnClose() throws Exception {
        PageCacheTracer cacheTracer = PageCacheTracer.NULL;
        AtomicInteger flushCounter = new AtomicInteger();
        SingleFilePageSwapperFactory swapperFactory = PageCacheTest.flushCountingPageSwapperFactory(this.fs, flushCounter, cacheTracer);
        Path file = this.file("a");
        try (Object cache = this.createPageCache((PageSwapperFactory)swapperFactory, this.maxPages, cacheTracer);
             PagedFile pf = cache.map(file, this.filePageSize, "neo4j", Sets.immutable.of((Object)StandardOpenOption.DELETE_ON_CLOSE));
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            this.writeRecords(cursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
        }
        Assertions.assertThat((int)flushCounter.get()).isLessThan(this.recordCount / this.recordsPerFilePage);
    }

    @Test
    void mustFlushAllDirtyPagesWhenClosingPagedFileThatIsNotMappedWithDeleteOnClose() throws Exception {
        PageCacheTracer cacheTracer = PageCacheTracer.NULL;
        AtomicInteger flushCounter = new AtomicInteger();
        SingleFilePageSwapperFactory swapperFactory = PageCacheTest.flushCountingPageSwapperFactory(this.fs, flushCounter, cacheTracer);
        Path file = this.file("a");
        try (Object cache = this.createPageCache((PageSwapperFactory)swapperFactory, this.maxPages, cacheTracer);
             PagedFile pf = cache.map(file, this.filePageSize, "neo4j");
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            this.writeRecords(cursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
        }
        Assertions.assertThat((int)flushCounter.get()).isEqualTo(1);
    }

    private static SingleFilePageSwapperFactory flushCountingPageSwapperFactory(FileSystemAbstraction fs, final AtomicInteger flushCounter, PageCacheTracer pageCacheTracer) {
        return new SingleFilePageSwapperFactory(fs, pageCacheTracer){

            public PageSwapper createPageSwapper(Path path, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist, boolean useDirectIO, boolean preallocateStoreFiles, IOController ioController, SwapperSet swappers) throws IOException {
                PageSwapper swapper = super.createPageSwapper(path, filePageSize, onEviction, createIfNotExist, useDirectIO, preallocateStoreFiles, ioController, swappers);
                return new DelegatingPageSwapper(swapper){

                    public long write(long filePageId, long bufferAddress) throws IOException {
                        flushCounter.getAndIncrement();
                        return super.write(filePageId, bufferAddress);
                    }

                    public long write(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length, int totalAffectedPages) throws IOException {
                        flushCounter.getAndAdd(totalAffectedPages);
                        return super.write(startFilePageId, bufferAddresses, bufferLengths, length, totalAffectedPages);
                    }
                };
            }
        };
    }

    @Test
    void fileMappedWithDeleteOnCloseMustNotLeakDirtyPages() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            Path file = this.file("a");
            int iterations = 50;
            for (int i = 0; i < iterations; ++i) {
                this.ensureExists(file);
                try (PagedFile pf = this.map(file, this.filePageSize, (ImmutableSet<OpenOption>)Sets.immutable.of((Object)StandardOpenOption.DELETE_ON_CLOSE));
                     PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                    this.writeRecords(cursor);
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    continue;
                }
            }
        });
    }

    @Test
    void mustNotThrowWhenMappingFileWithDifferentFilePageSizeAndAnyPageSizeIsSpecified() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile ignore = this.map(this.file("a"), this.filePageSize);){
            this.map(this.file("a"), this.filePageSize + 1, (ImmutableSet<OpenOption>)Sets.immutable.of((Object)PageCacheOpenOptions.ANY_PAGE_SIZE)).close();
        }
    }

    @Test
    void mustCopyIntoSameSizedWritePageCursor() throws Exception {
        this.configureStandardPageCache();
        int bytes = 200;
        try (PagedFile pf = this.map(this.file("a"), 32);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            for (int i = 0; i < bytes; ++i) {
                if ((i & 0x1F) == 0) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                }
                cursor.putByte((byte)i);
            }
        }
        int pageSize = 16;
        try (PagedFile pfA = this.map(this.file("a"), pageSize);
             PagedFile pfB = this.map(this.existingFile("b"), pageSize);
             PageCursor cursorA = pfA.io(0L, 1, CursorContext.NULL);
             PageCursor cursorB = pfB.io(0L, 2, CursorContext.NULL);){
            while (cursorA.next()) {
                int bytesCopied;
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorB.next());
                do {
                    bytesCopied = cursorA.copyTo(0, cursorB, 0, cursorA.getCurrentPageSize());
                } while (cursorA.shouldRetry());
                Assertions.assertThat((int)bytesCopied).isEqualTo(pageSize);
            }
        }
        try (PagedFile pf = this.map(this.file("b"), 32);
             PageCursor cursor = pf.io(0L, 1, CursorContext.NULL);){
            for (int i = 0; i < bytes; ++i) {
                byte b;
                if ((i & 0x1F) == 0) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                }
                int offset = cursor.getOffset();
                do {
                    cursor.setOffset(offset);
                    b = cursor.getByte();
                } while (cursor.shouldRetry());
                Assertions.assertThat((byte)b).isEqualTo((byte)i);
            }
        }
    }

    @Test
    void mustCopyIntoLargerPageCursor() throws Exception {
        this.configureStandardPageCache();
        int smallPageSize = 16;
        int largePageSize = 17;
        try (PagedFile pfA = this.map(this.file("a"), smallPageSize);
             PagedFile pfB = this.map(this.existingFile("b"), largePageSize);
             PageCursor cursorA = pfA.io(0L, 2, CursorContext.NULL);
             PageCursor cursorB = pfB.io(0L, 2, CursorContext.NULL);){
            int i;
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorA.next());
            for (i = 0; i < smallPageSize; ++i) {
                cursorA.putByte((byte)(i + 1));
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorB.next());
            Assertions.assertThat((int)cursorA.copyTo(0, cursorB, 0, smallPageSize)).isEqualTo(smallPageSize);
            for (i = 0; i < smallPageSize; ++i) {
                Assertions.assertThat((byte)cursorB.getByte()).isEqualTo((byte)(i + 1));
            }
            Assertions.assertThat((byte)cursorB.getByte()).isEqualTo((byte)0);
        }
    }

    @Test
    void mustCopyIntoSmallerPageCursor() throws Exception {
        this.configureStandardPageCache();
        int smallPageSize = 16;
        int largePageSize = 17;
        try (PagedFile pfA = this.map(this.file("a"), largePageSize);
             PagedFile pfB = this.map(this.existingFile("b"), smallPageSize);
             PageCursor cursorA = pfA.io(0L, 2, CursorContext.NULL);
             PageCursor cursorB = pfB.io(0L, 2, CursorContext.NULL);){
            int i;
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorA.next());
            for (i = 0; i < largePageSize; ++i) {
                cursorA.putByte((byte)(i + 1));
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorB.next());
            Assertions.assertThat((int)cursorA.copyTo(0, cursorB, 0, largePageSize)).isEqualTo(smallPageSize);
            for (i = 0; i < smallPageSize; ++i) {
                Assertions.assertThat((byte)cursorB.getByte()).isEqualTo((byte)(i + 1));
            }
        }
    }

    @Test
    void mustThrowOnCopyIntoReadPageCursor() throws Exception {
        this.configureStandardPageCache();
        int pageSize = 17;
        try (PagedFile pfA = this.map(this.file("a"), pageSize);
             PagedFile pfB = this.map(this.existingFile("b"), pageSize);){
            PageCursor cursorB;
            try (PageCursor cursorA = pfA.io(0L, 2, CursorContext.NULL);){
                cursorB = pfB.io(0L, 2, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorA.next());
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorB.next());
                }
                finally {
                    if (cursorB != null) {
                        cursorB.close();
                    }
                }
            }
            cursorA = pfA.io(0L, 2, CursorContext.NULL);
            try {
                cursorB = pfB.io(0L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorA.next());
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorB.next());
                    org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> cursorA.copyTo(0, cursorB, 0, pageSize));
                }
                finally {
                    if (cursorB != null) {
                        cursorB.close();
                    }
                }
            }
            finally {
                if (cursorA != null) {
                    cursorA.close();
                }
            }
        }
    }

    @Test
    void copyToPageCursorMustCheckBounds() throws Exception {
        this.configureStandardPageCache();
        int pageSize = 16;
        try (PagedFile pf = this.map(this.file("a"), pageSize);
             PageCursor cursorA = pf.io(0L, 1, CursorContext.NULL);
             PageCursor cursorB = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorB.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorB.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorA.next());
            cursorA.copyTo(-1, cursorB, 0, 1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            cursorA.copyTo(0, cursorB, -1, 1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            cursorA.copyTo(pageSize, cursorB, 0, 1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            cursorA.copyTo(0, cursorB, pageSize, 1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            Assertions.assertThat((int)cursorA.copyTo(1, cursorB, 0, pageSize)).isEqualTo(pageSize - 1);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorA.checkAndClearBoundsFlag());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            Assertions.assertThat((int)cursorA.copyTo(0, cursorB, 1, pageSize)).isEqualTo(pageSize - 1);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorA.checkAndClearBoundsFlag());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            Assertions.assertThat((int)cursorA.copyTo(0, cursorB, 1, 0)).isEqualTo(0);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorA.checkAndClearBoundsFlag());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            cursorA.copyTo(1, cursorB, 1, -1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
        }
    }

    @Test
    void copyToHeapByteBufferFromReadPageCursorMustCheckBounds() throws Exception {
        this.configureStandardPageCache();
        ByteBuffer buffer = ByteBuffers.allocate((int)this.filePageSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor cursor = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            this.verifyCopyToBufferBounds(cursor, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void copyToDirectByteBufferFromReadPageCursorMustCheckBounds() throws Exception {
        this.configureStandardPageCache();
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)this.filePageSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            Path file = this.file("a");
            this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
            try (PagedFile pf = this.map(file, this.filePageSize);
                 PageCursor cursor = pf.io(0L, 1, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                this.verifyCopyToBufferBounds(cursor, buffer);
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }

    @Test
    void copyToHeapByteBufferFromWritePageCursorMustCheckBounds() throws Exception {
        this.configureStandardPageCache();
        ByteBuffer buffer = ByteBuffers.allocate((int)this.filePageSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            this.verifyCopyToBufferBounds(cursor, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void copyToDirectByteBufferFromWritePageCursorMustCheckBounds() throws Exception {
        this.configureStandardPageCache();
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)this.filePageSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            Path file = this.file("a");
            this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
            try (PagedFile pf = this.map(file, this.filePageSize);
                 PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                this.verifyCopyToBufferBounds(cursor, buffer);
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }

    private void verifyCopyToBufferBounds(PageCursor cursor, ByteBuffer buffer) throws IOException {
        int copied;
        do {
            buffer.clear();
            copied = cursor.copyTo(0, buffer);
        } while (cursor.shouldRetry());
        Assertions.assertThat((int)copied).isEqualTo(this.filePageSize);
        buffer.clear();
        this.verifyRecordsMatchExpected(0L, 0, buffer);
        buffer.clear();
        cursor.copyTo(-1, buffer);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        buffer.clear();
        copied = cursor.copyTo(1, buffer);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        Assertions.assertThat((int)copied).isEqualTo(this.filePageSize - 1);
        Assertions.assertThat((int)buffer.position()).isEqualTo(this.filePageSize - 1);
        Assertions.assertThat((int)buffer.remaining()).isEqualTo(1);
        buffer.clear();
        PageCacheTest.zapBuffer(buffer);
        do {
            buffer.clear();
            buffer.limit(this.filePageSize - this.recordSize);
            copied = cursor.copyTo(0, buffer);
        } while (cursor.shouldRetry());
        Assertions.assertThat((int)copied).isEqualTo(this.filePageSize - this.recordSize);
        Assertions.assertThat((int)buffer.position()).isEqualTo(this.filePageSize - this.recordSize);
        Assertions.assertThat((int)buffer.remaining()).isEqualTo(0);
        buffer.clear();
        buffer.limit(this.filePageSize - this.recordSize);
        this.verifyRecordsMatchExpected(0L, 0, buffer);
        PageCacheTest.zapBuffer(buffer);
        do {
            buffer.clear();
            buffer.limit(this.filePageSize - this.recordSize);
            copied = cursor.copyTo(this.recordSize, buffer);
        } while (cursor.shouldRetry());
        Assertions.assertThat((int)copied).isEqualTo(this.filePageSize - this.recordSize);
        Assertions.assertThat((int)buffer.position()).isEqualTo(this.filePageSize - this.recordSize);
        Assertions.assertThat((int)buffer.remaining()).isEqualTo(0);
        buffer.clear();
        buffer.limit(this.filePageSize - this.recordSize);
        this.verifyRecordsMatchExpected(0L, this.recordSize, buffer);
    }

    private static void zapBuffer(ByteBuffer buffer) {
        byte zero = 0;
        if (buffer.hasArray()) {
            Arrays.fill(buffer.array(), zero);
        } else {
            buffer.clear();
            while (buffer.hasRemaining()) {
                buffer.put(zero);
            }
        }
    }

    @Test
    void copyToReadOnlyHeapByteBufferMustThrow() throws Exception {
        this.configureStandardPageCache();
        ByteBuffer buf = ByteBuffers.allocate((int)this.filePageSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE).asReadOnlyBuffer();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertThrows(ReadOnlyBufferException.class, () -> cursor.copyTo(0, buf));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void copyToReadOnlyDirectByteBufferMustThrow() throws Exception {
        this.configureStandardPageCache();
        ByteBuffer allocation = ByteBuffers.allocateDirect((int)this.filePageSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            ByteBuffer buf = allocation.asReadOnlyBuffer();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
                 PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertThrows(ReadOnlyBufferException.class, () -> cursor.copyTo(0, buf));
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)allocation, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }

    @Test
    void shiftBytesMustNotRaiseOutOfBoundsOnLengthWithinPageBoundary() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            cursor.shiftBytes(0, this.filePageSize, 0);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
            cursor.shiftBytes(0, this.filePageSize - 1, 1);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
            cursor.shiftBytes(1, this.filePageSize - 1, -1);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustRaiseOutOfBoundsOnLengthLargerThanPageSize() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            cursor.shiftBytes(0, this.filePageSize + 1, 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustRaiseOutOfBoundsOnNegativeLength() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            cursor.shiftBytes(1, -1, 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustRaiseOutOfBoundsOnNegativeSource() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            cursor.shiftBytes(-1, 10, 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustRaiseOutOfBoundsOnOverSizedSource() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            cursor.shiftBytes(this.filePageSize, 1, 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
            cursor.shiftBytes(this.filePageSize + 1, 0, 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustRaiseOutOfBoundsOnBufferUnderflow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            cursor.shiftBytes(0, 1, -1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustRaiseOutOfBoundsOnBufferOverflow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            cursor.shiftBytes(this.filePageSize - 1, 1, 1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustThrowOnReadCursor() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
             PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> reader.shiftBytes(0, 0, 0));
        }
    }

    @Test
    void shiftBytesMustShiftBytesToTheRightOverlapping() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            int i;
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            byte[] bytes = new byte[30];
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                bytes[i2] = (byte)(i2 + 1);
            }
            int srcOffset = 10;
            cursor.setOffset(srcOffset);
            cursor.putBytes(bytes);
            int shift = 5;
            PageCacheTest.assertZeroes(cursor, 0, srcOffset);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length, this.filePageSize - srcOffset - bytes.length);
            cursor.shiftBytes(srcOffset, bytes.length, shift);
            PageCacheTest.assertZeroes(cursor, 0, srcOffset);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length + shift, this.filePageSize - srcOffset - bytes.length - shift);
            cursor.setOffset(srcOffset);
            for (i = 0; i < shift; ++i) {
                Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)(i + 1));
            }
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)(i + 1));
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustShiftBytesToTheRightNotOverlapping() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            int i;
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            byte[] bytes = new byte[30];
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                bytes[i2] = (byte)(i2 + 1);
            }
            int srcOffset = 10;
            cursor.setOffset(srcOffset);
            cursor.putBytes(bytes);
            int gap = 5;
            int shift = bytes.length + gap;
            PageCacheTest.assertZeroes(cursor, 0, srcOffset);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length, this.filePageSize - srcOffset - bytes.length);
            cursor.shiftBytes(srcOffset, bytes.length, shift);
            PageCacheTest.assertZeroes(cursor, 0, srcOffset);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length + shift, this.filePageSize - srcOffset - bytes.length - shift);
            cursor.setOffset(srcOffset);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)(i + 1));
            }
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length + shift, gap);
            cursor.setOffset(srcOffset + shift);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)(i + 1));
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustShiftBytesToTheLeftOverlapping() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            int i;
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            byte[] bytes = new byte[30];
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                bytes[i2] = (byte)(i2 + 1);
            }
            int srcOffset = 10;
            cursor.setOffset(srcOffset);
            cursor.putBytes(bytes);
            int shift = -5;
            PageCacheTest.assertZeroes(cursor, 0, srcOffset);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length, this.filePageSize - srcOffset - bytes.length);
            cursor.shiftBytes(srcOffset, bytes.length, shift);
            PageCacheTest.assertZeroes(cursor, 0, srcOffset + shift);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length, this.filePageSize - srcOffset - bytes.length);
            cursor.setOffset(srcOffset + shift);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)(i + 1));
            }
            for (i = shift; i < 0; ++i) {
                Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)(bytes.length + i + 1));
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustShiftBytesToTheLeftNotOverlapping() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            int i;
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            byte[] bytes = new byte[30];
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                bytes[i2] = (byte)(i2 + 1);
            }
            int srcOffset = this.filePageSize - bytes.length - 10;
            cursor.setOffset(srcOffset);
            cursor.putBytes(bytes);
            int gap = 5;
            int shift = -bytes.length - gap;
            PageCacheTest.assertZeroes(cursor, 0, srcOffset);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length, this.filePageSize - srcOffset - bytes.length);
            cursor.shiftBytes(srcOffset, bytes.length, shift);
            PageCacheTest.assertZeroes(cursor, 0, srcOffset + shift);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length, this.filePageSize - srcOffset - bytes.length);
            cursor.setOffset(srcOffset + shift);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)(i + 1));
            }
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length + shift, gap);
            cursor.setOffset(srcOffset);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertThat((byte)cursor.getByte()).isEqualTo((byte)(i + 1));
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private static void assertZeroes(PageCursor cursor, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            Assertions.assertThat((byte)cursor.getByte(offset + i)).isEqualTo((byte)0);
        }
    }

    @Test
    void readCursorsCanOpenLinkedCursor() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
                 PageCursor parent = pf.io(0L, 1, CursorContext.NULL);){
                PageCursor linked = parent.openLinkedCursor(1L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)parent.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)linked.next());
                this.verifyRecordsMatchExpected(parent);
                this.verifyRecordsMatchExpected(linked);
            }
        });
    }

    @Test
    void writeCursorsCanOpenLinkedCursor() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            Path file = this.file("a");
            try (PagedFile pf = this.map(file, this.filePageSize);
                 PageCursor parent = pf.io(0L, 2, CursorContext.NULL);){
                PageCursor linked = parent.openLinkedCursor(1L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)parent.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)linked.next());
                this.writeRecords(parent);
                this.writeRecords(linked);
            }
            this.verifyRecordsInFile(file, this.recordsPerFilePage * 2);
        });
    }

    @Test
    void closingParentCursorMustCloseLinkedCursor() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);){
                PageCursor writerParent = pf.io(0L, 2, CursorContext.NULL);
                PageCursor readerParent = pf.io(0L, 1, CursorContext.NULL);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writerParent.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)readerParent.next());
                PageCursor writerLinked = writerParent.openLinkedCursor(1L);
                PageCursor readerLinked = readerParent.openLinkedCursor(1L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writerLinked.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)readerLinked.next());
                writerParent.close();
                readerParent.close();
                writerLinked.getByte(0);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writerLinked.checkAndClearBoundsFlag());
                readerLinked.getByte(0);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)readerLinked.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void writeCursorWithNoGrowCanOpenLinkedCursorWithNoGrow() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
                 PageCursor parent = pf.io(0L, 6, CursorContext.NULL);){
                PageCursor linked = parent.openLinkedCursor(1L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)parent.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)linked.next());
                this.verifyRecordsMatchExpected(parent);
                this.verifyRecordsMatchExpected(linked);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)linked.next());
            }
        });
    }

    @Test
    void openingLinkedCursorMustCloseExistingLinkedCursor() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            PageCursor linked;
            PageCursor parent;
            this.configureStandardPageCache();
            Path file = this.file("a");
            try (PagedFile pf = this.map(file, this.filePageSize);){
                parent = pf.io(0L, 2, CursorContext.NULL);
                try {
                    linked = parent.openLinkedCursor(1L);
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)parent.next());
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)linked.next());
                    this.writeRecords(parent);
                    this.writeRecords(linked);
                    parent.openLinkedCursor(2L);
                    linked.putByte(0, (byte)1);
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)linked.checkAndClearBoundsFlag());
                }
                finally {
                    if (parent != null) {
                        parent.close();
                    }
                }
            }
            pf = this.map(file, this.filePageSize);
            try {
                parent = pf.io(0L, 1, CursorContext.NULL);
                try {
                    linked = parent.openLinkedCursor(1L);
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)parent.next());
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)linked.next());
                    parent.openLinkedCursor(2L);
                    linked.getByte(0);
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)linked.checkAndClearBoundsFlag());
                }
                finally {
                    if (parent != null) {
                        parent.close();
                    }
                }
            }
            finally {
                if (pf != null) {
                    pf.close();
                }
            }
        });
    }

    @Test
    void shouldRetryOnParentCursorMustReturnTrueIfLinkedCursorNeedsRetry() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
                 PageCursor parentReader = pf.io(0L, 1, CursorContext.NULL);
                 PageCursor writer = pf.io(1L, 2, CursorContext.NULL);){
                PageCursor linkedReader = parentReader.openLinkedCursor(1L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)parentReader.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)linkedReader.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)parentReader.shouldRetry());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)parentReader.shouldRetry());
            }
        });
    }

    @Test
    void checkAndClearBoundsFlagMustCheckAndClearLinkedCursor() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
                 PageCursor parent = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)parent.next());
                PageCursor linked = parent.openLinkedCursor(1L);
                linked.raiseOutOfBounds();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)parent.checkAndClearBoundsFlag());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)linked.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void shouldRetryMustClearBoundsFlagIfLinkedCursorNeedsRetry() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
             PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)linkedReader.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next(1L));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                reader.raiseOutOfBounds();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.shouldRetry());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)reader.checkAndClearBoundsFlag());
            }
        }
    }

    @Test
    void checkAndClearCursorExceptionMustNotThrowIfNoExceptionIsSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);){
            try (PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.checkAndClearCursorException();
            }
            cursor = pf.io(0L, 1, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.checkAndClearCursorException();
                while (cursor.shouldRetry()) {
                }
                cursor.checkAndClearCursorException();
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void checkAndClearCursorExceptionMustThrowIfExceptionIsSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);){
            PageCursor cursor;
            String msg = "Boo" + ThreadLocalRandom.current().nextInt();
            try {
                cursor = pf.io(0L, 2, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.setCursorException(msg);
                    cursor.checkAndClearCursorException();
                    org.junit.jupiter.api.Assertions.fail((String)"checkAndClearError on write cursor should have thrown");
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            catch (CursorException e) {
                Assertions.assertThat((String)e.getMessage()).isEqualTo(msg);
            }
            msg = "Boo" + ThreadLocalRandom.current().nextInt();
            try {
                cursor = pf.io(0L, 1, CursorContext.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.setCursorException(msg);
                    cursor.checkAndClearCursorException();
                    org.junit.jupiter.api.Assertions.fail((String)"checkAndClearError on read cursor should have thrown");
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            catch (CursorException e) {
                Assertions.assertThat((String)e.getMessage()).isEqualTo(msg);
            }
        }
    }

    @Test
    void checkAndClearCursorExceptionMustClearExceptionIfSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);){
            try (PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.setCursorException("boo");
                try {
                    cursor.checkAndClearCursorException();
                    org.junit.jupiter.api.Assertions.fail((String)"checkAndClearError on write cursor should have thrown");
                }
                catch (CursorException cursorException) {
                    // empty catch block
                }
                cursor.checkAndClearCursorException();
            }
            cursor = pf.io(0L, 1, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.setCursorException("boo");
                try {
                    cursor.checkAndClearCursorException();
                    org.junit.jupiter.api.Assertions.fail((String)"checkAndClearError on read cursor should have thrown");
                }
                catch (CursorException cursorException) {
                    // empty catch block
                }
                cursor.checkAndClearCursorException();
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void nextMustClearCursorExceptionIfSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);){
            try (PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.setCursorException("boo");
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.checkAndClearCursorException();
            }
            cursor = pf.io(0L, 1, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.setCursorException("boo");
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.checkAndClearCursorException();
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void nextWithIdMustClearCursorExceptionIfSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);){
            try (PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(1L));
                cursor.setCursorException("boo");
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(2L));
                cursor.checkAndClearCursorException();
            }
            cursor = pf.io(0L, 1, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(1L));
                cursor.setCursorException("boo");
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(2L));
                cursor.checkAndClearCursorException();
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void shouldRetryMustClearCursorExceptionIfItReturnsTrue() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
             PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next(0L));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            reader.setCursorException("boo");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.shouldRetry());
            reader.checkAndClearCursorException();
        }
    }

    @Test
    void shouldRetryMustNotClearCursorExceptionIfItReturnsFalse() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor cursor = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            do {
                cursor.setCursorException("boo");
            } while (cursor.shouldRetry());
            org.junit.jupiter.api.Assertions.assertThrows(CursorException.class, () -> ((PageCursor)cursor).checkAndClearCursorException());
        }
    }

    @Test
    void shouldRetryMustClearCursorExceptionIfLinkedShouldRetryReturnsTrue() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
             PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)linkedReader.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next(1L));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                reader.setCursorException("boo");
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.shouldRetry());
                reader.checkAndClearCursorException();
            }
        }
    }

    @Test
    void shouldRetryMustClearLinkedCursorExceptionIfItReturnsTrue() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
             PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)linkedReader.next());
                linkedReader.setCursorException("boo");
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next(0L));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.shouldRetry());
                linkedReader.checkAndClearCursorException();
                reader.checkAndClearCursorException();
            }
        }
    }

    @Test
    void shouldRetryMustClearLinkedCursorExceptionIfLinkedShouldRetryReturnsTrue() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
             PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)linkedReader.next());
                linkedReader.setCursorException("boo");
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next(1L));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.shouldRetry());
                linkedReader.checkAndClearCursorException();
                reader.checkAndClearCursorException();
            }
        }
    }

    @Test
    void shouldRetryMustNotClearCursorExceptionIfBothItAndLinkedShouldRetryReturnsFalse() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor reader = pf.io(0L, 1, CursorContext.NULL);
             PageCursor linkedReader = reader.openLinkedCursor(1L);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)linkedReader.next());
            do {
                reader.setCursorException("boo");
            } while (reader.shouldRetry());
            org.junit.jupiter.api.Assertions.assertThrows(CursorException.class, () -> ((PageCursor)reader).checkAndClearCursorException());
        }
    }

    @Test
    void shouldRetryMustNotClearLinkedCursorExceptionIfBothItAndLinkedShouldRetryReturnsFalse() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor reader = pf.io(0L, 1, CursorContext.NULL);
             PageCursor linkedReader = reader.openLinkedCursor(1L);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)linkedReader.next());
            do {
                linkedReader.setCursorException("boo");
            } while (reader.shouldRetry());
            org.junit.jupiter.api.Assertions.assertThrows(CursorException.class, () -> ((PageCursor)reader).checkAndClearCursorException());
        }
    }

    @Test
    void checkAndClearCursorExceptionMustThrowIfLinkedCursorHasErrorSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
             PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
            CursorException exception;
            String msg = "Boo" + ThreadLocalRandom.current().nextInt();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            try (PageCursor linkedWriter = writer.openLinkedCursor(1L);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)linkedWriter.next());
                linkedWriter.setCursorException(msg);
                exception = (CursorException)org.junit.jupiter.api.Assertions.assertThrows(CursorException.class, () -> ((PageCursor)writer).checkAndClearCursorException());
                Assertions.assertThat((String)exception.getMessage()).isEqualTo(msg);
            }
            msg = "Boo" + ThreadLocalRandom.current().nextInt();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)linkedReader.next());
                linkedReader.setCursorException(msg);
                exception = (CursorException)org.junit.jupiter.api.Assertions.assertThrows(CursorException.class, () -> ((PageCursor)reader).checkAndClearCursorException());
                Assertions.assertThat((String)exception.getMessage()).isEqualTo(msg);
            }
        }
    }

    @Test
    void checkAndClearCursorMustNotThrowIfErrorHasBeenSetButTheCursorHasBeenClosed() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);){
            PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            writer.setCursorException("boo");
            writer.close();
            writer.checkAndClearCursorException();
            PageCursor reader = pf.io(0L, 1, CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            reader.setCursorException("boo");
            reader.close();
            reader.checkAndClearCursorException();
            writer = pf.io(0L, 2, CursorContext.NULL);
            PageCursor linkedWriter = writer.openLinkedCursor(1L);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)linkedWriter.next());
            linkedWriter.setCursorException("boo");
            writer.close();
            linkedWriter.checkAndClearCursorException();
            reader = pf.io(0L, 1, CursorContext.NULL);
            PageCursor linkedReader = reader.openLinkedCursor(1L);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)linkedReader.next());
            linkedReader.setCursorException("boo");
            reader.close();
            linkedReader.checkAndClearCursorException();
        }
    }

    @Test
    void openingLinkedCursorOnClosedCursorMustThrow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);){
            PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            writer.close();
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> writer.openLinkedCursor(1L));
            PageCursor reader = pf.io(0L, 1, CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            reader.close();
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> reader.openLinkedCursor(1L));
        }
    }

    @Test
    void settingNullCursorExceptionMustThrow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
             PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> writer.setCursorException(null));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> reader.setCursorException(null));
        }
    }

    @Test
    void clearCursorExceptionMustUnsetErrorCondition() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
             PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            writer.setCursorException("boo");
            writer.clearCursorException();
            writer.checkAndClearCursorException();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            reader.setCursorException("boo");
            reader.clearCursorException();
            reader.checkAndClearCursorException();
        }
    }

    @Test
    void clearCursorExceptionMustUnsetErrorConditionOnLinkedCursor() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor writer = pf.io(0L, 2, CursorContext.NULL);
             PageCursor reader = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            PageCursor linkedWriter = writer.openLinkedCursor(1L);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)linkedWriter.next());
            linkedWriter.setCursorException("boo");
            writer.clearCursorException();
            writer.checkAndClearCursorException();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
            PageCursor linkedReader = reader.openLinkedCursor(1L);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)linkedReader.next());
            linkedReader.setCursorException("boo");
            reader.clearCursorException();
            reader.checkAndClearCursorException();
        }
    }

    @Test
    void sizeOfEmptyFileMustBeZero() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);){
            Assertions.assertThat((long)pf.fileSize()).isEqualTo(0L);
        }
    }

    @Test
    void fileSizeMustIncreaseInPageIncrements() throws Exception {
        this.configureStandardPageCache();
        long increment = this.filePageSize;
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertThat((long)pf.fileSize()).isEqualTo(increment);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertThat((long)pf.fileSize()).isEqualTo(2L * increment);
        }
    }

    @Test
    void shouldZeroAllBytesOnClear() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize);){
            byte[] read;
            long pageId = 0L;
            try (PageCursor cursor = pagedFile.io(pageId, 2, CursorContext.NULL);){
                ThreadLocalRandom rng = ThreadLocalRandom.current();
                byte[] bytes = new byte[this.filePageSize];
                rng.nextBytes(bytes);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putBytes(bytes);
            }
            byte[] allZeros = new byte[this.filePageSize];
            try (PageCursor cursor = pagedFile.io(pageId, 2, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.zapPage();
                read = new byte[this.filePageSize];
                cursor.getBytes(read);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
                org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])allZeros, (byte[])read);
            }
            cursor = pagedFile.io(pageId, 1, CursorContext.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                read = new byte[this.filePageSize];
                do {
                    cursor.getBytes(read);
                } while (cursor.shouldRetry());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
                org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])allZeros, (byte[])read);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void isWriteLockingMustBeTrueForCursorOpenedWithSharedWriteLock() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 2, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.isWriteLocked());
        }
    }

    @Test
    void isWriteLockingMustBeFalseForCursorOpenedWithSharedReadLock() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor cursor = pf.io(0L, 1, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.isWriteLocked());
        }
    }

    @Test
    void eagerFlushMustWriteToFileOnUnpin() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor cursor = pf.io(0L, 66, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            this.writeRecords(cursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            this.verifyRecordsInFile(file, this.recordsPerFilePage);
        }
    }

    @Test
    void eagerFlushMustWriteToFileOnClose() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        try (PagedFile pf = this.map(file, this.filePageSize);){
            try (PageCursor cursor = pf.io(0L, 66, CursorContext.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                this.writeRecords(cursor);
            }
            this.verifyRecordsInFile(file, this.recordsPerFilePage);
        }
    }

    @Test
    void noFaultNextReadOnInMemoryPages() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor faulter = pf.io(0L, 2, CursorContext.NULL);
             PageCursor nofault = pf.io(0L, 17, CursorContext.NULL);){
            PageCacheTest.verifyNoFaultAccessToInMemoryPages(faulter, nofault);
        }
    }

    @Test
    void noFaultNextWriteOnInMemoryPages() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor faulter = pf.io(0L, 2, CursorContext.NULL);
             PageCursor nofault = pf.io(0L, 18, CursorContext.NULL);){
            PageCacheTest.verifyNoFaultAccessToInMemoryPages(faulter, nofault);
        }
    }

    @Test
    void noFaultNextLinkedReadOnInMemoryPages() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor faulter = pf.io(0L, 2, CursorContext.NULL);
             PageCursor nofault = pf.io(0L, 17, CursorContext.NULL);
             PageCursor linkedNoFault = nofault.openLinkedCursor(0L);){
            PageCacheTest.verifyNoFaultAccessToInMemoryPages(faulter, linkedNoFault);
        }
    }

    @Test
    void noFaultNextLinkedWriteOnInMemoryPages() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize);
             PageCursor faulter = pf.io(0L, 2, CursorContext.NULL);
             PageCursor nofault = pf.io(0L, 18, CursorContext.NULL);
             PageCursor linkedNoFault = nofault.openLinkedCursor(0L);){
            PageCacheTest.verifyNoFaultAccessToInMemoryPages(faulter, linkedNoFault);
        }
    }

    private static void verifyNoFaultAccessToInMemoryPages(PageCursor faulter, PageCursor nofault) throws IOException {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)faulter.next());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.next());
        PageCacheTest.verifyNoFaultCursorIsInMemory(nofault, 0L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)faulter.next());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.next(1L));
        PageCacheTest.verifyNoFaultCursorIsInMemory(nofault, 1L);
    }

    private static void verifyNoFaultCursorIsInMemory(PageCursor nofault, long expectedPageId) {
        Assertions.assertThat((long)nofault.getCurrentPageId()).isEqualTo(expectedPageId);
        nofault.getByte();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)nofault.checkAndClearBoundsFlag());
        nofault.getByte(0);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)nofault.checkAndClearBoundsFlag());
    }

    @Test
    void noFaultReadOfPagesNotInMemory() throws Exception {
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)cacheTracer);
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        long initialFaults = cacheTracer.faults();
        try (PagedFile pf = this.map(file, this.filePageSize);
             CursorContext cursorContext = new CursorContext(cacheTracer.createPageCursorTracer("noFaultReadOfPagesNotInMemory"));
             PageCursor nofault = pf.io(0L, 17, cursorContext);){
            PageCacheTest.verifyNoFaultAccessToPagesNotInMemory(cacheTracer, cursorContext, nofault, initialFaults);
        }
    }

    @Test
    void noFaultWriteOnPagesNotInMemory() throws Exception {
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)cacheTracer);
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        long initialFaults = cacheTracer.faults();
        try (PagedFile pf = this.map(file, this.filePageSize);
             CursorContext cursorContext = new CursorContext(cacheTracer.createPageCursorTracer("noFaultWriteOnPagesNotInMemory"));
             PageCursor nofault = pf.io(0L, 18, cursorContext);){
            PageCacheTest.verifyNoFaultAccessToPagesNotInMemory(cacheTracer, cursorContext, nofault, initialFaults);
            PageCacheTest.verifyNoFaultWriteIsOutOfBounds(nofault);
        }
    }

    @Test
    void noFaultLinkedReadOfPagesNotInMemory() throws Exception {
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)cacheTracer);
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        long initialFaults = cacheTracer.faults();
        try (PagedFile pf = this.map(file, this.filePageSize);
             CursorContext cursorContext = new CursorContext(cacheTracer.createPageCursorTracer("noFaultLinkedReadOfPagesNotInMemory"));
             PageCursor nofault = pf.io(0L, 17, cursorContext);
             PageCursor linkedNoFault = nofault.openLinkedCursor(0L);){
            PageCacheTest.verifyNoFaultAccessToPagesNotInMemory(cacheTracer, cursorContext, linkedNoFault, initialFaults);
        }
    }

    @Test
    void noFaultLinkedWriteOnPagesNotInMemory() throws Exception {
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)cacheTracer);
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        long initialFaults = cacheTracer.faults();
        try (PagedFile pf = this.map(file, this.filePageSize);
             CursorContext cursorContext = new CursorContext(cacheTracer.createPageCursorTracer("noFaultLinkedWriteOnPagesNotInMemory"));
             PageCursor nofault = pf.io(0L, 18, cursorContext);
             PageCursor linkedNoFault = nofault.openLinkedCursor(0L);){
            PageCacheTest.verifyNoFaultAccessToPagesNotInMemory(cacheTracer, cursorContext, linkedNoFault, initialFaults);
            PageCacheTest.verifyNoFaultWriteIsOutOfBounds(linkedNoFault);
        }
    }

    private static void verifyNoFaultAccessToPagesNotInMemory(DefaultPageCacheTracer cacheTracer, CursorContext cursorContext, PageCursor nofault, long initialFaults) throws IOException {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.next());
        PageCacheTest.verifyNoFaultReadIsNotInMemory(nofault);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.next());
        PageCacheTest.verifyNoFaultReadIsNotInMemory(nofault);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)nofault.next());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.next(0L));
        PageCacheTest.verifyNoFaultReadIsNotInMemory(nofault);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)nofault.next(2L));
        ((DefaultPageCursorTracer)cursorContext.getCursorTracer()).setIgnoreCounterCheck(true);
        cursorContext.getCursorTracer().reportEvents();
        Assertions.assertThat((long)(cacheTracer.faults() - initialFaults)).isEqualTo(0L);
    }

    private static void verifyNoFaultReadIsNotInMemory(PageCursor nofault) {
        Assertions.assertThat((long)nofault.getCurrentPageId()).isEqualTo(-1L);
        nofault.getByte();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.checkAndClearBoundsFlag());
        nofault.getByte(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.checkAndClearBoundsFlag());
    }

    private static void verifyNoFaultWriteIsOutOfBounds(PageCursor nofault) throws IOException {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.next(0L));
        Assertions.assertThat((long)nofault.getCurrentPageId()).isEqualTo(-1L);
        nofault.putByte((byte)1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.checkAndClearBoundsFlag());
        nofault.putByte(0, (byte)1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.checkAndClearBoundsFlag());
    }

    @Test
    void noFaultNextReadMustStrideForwardMonotonically() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 6, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor faulter = pf.io(0L, 1, CursorContext.NULL);
             PageCursor nofault = pf.io(0L, 17, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)faulter.next(1L));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)faulter.next(3L));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)faulter.next(5L));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.next());
            PageCacheTest.verifyNoFaultReadIsNotInMemory(nofault);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.next());
            PageCacheTest.verifyNoFaultCursorIsInMemory(nofault, 1L);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.next());
            PageCacheTest.verifyNoFaultReadIsNotInMemory(nofault);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.next());
            PageCacheTest.verifyNoFaultCursorIsInMemory(nofault, 3L);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.next());
            PageCacheTest.verifyNoFaultReadIsNotInMemory(nofault);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.next());
            PageCacheTest.verifyNoFaultCursorIsInMemory(nofault, 5L);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)nofault.next());
        }
    }

    @Test
    void noFaultReadCursorMustCopeWithPageEviction() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor faulter = pf.io(0L, 2, CursorContext.NULL);
             PageCursor nofault = pf.io(0L, 17, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)faulter.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)faulter.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.next());
            PageCacheTest.verifyNoFaultCursorIsInMemory(nofault, 0L);
            PageCursor[] writerArray = new PageCursor[this.maxPages - 1];
            for (int i = 0; i < writerArray.length; ++i) {
                writerArray[i] = pf.io((long)(2 + i), 2, CursorContext.NULL);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writerArray[i].next());
            }
            for (PageCursor writer : writerArray) {
                writer.close();
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nofault.shouldRetry());
            PageCacheTest.verifyNoFaultReadIsNotInMemory(nofault);
        }
    }

    private static class PageCacheIOController
    extends EmptyIOController {
        private final AtomicInteger ioCounter;
        private final int pagesPerFlush;
        private final AtomicInteger callbackCounter;

        private PageCacheIOController(AtomicInteger ioCounter, int pagesPerFlush, AtomicInteger callbackCounter) {
            this.ioCounter = ioCounter;
            this.pagesPerFlush = pagesPerFlush;
            this.callbackCounter = callbackCounter;
        }

        public void maybeLimitIO(int recentlyCompletedIOs, Flushable flushable, MajorFlushEvent flushEvent) {
            this.ioCounter.addAndGet(recentlyCompletedIOs * this.pagesPerFlush);
            this.callbackCounter.getAndIncrement();
        }
    }

    @FunctionalInterface
    private static interface PageCursorAction {
        public void apply(PageCursor var1);
    }
}

