/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.net.URI;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.http.HttpHeader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.test.PortUtils;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;
import org.neo4j.test.server.HTTP;
import org.neo4j.test.server.InsecureTrustManager;

class HttpsAccessIT
extends ExclusiveWebContainerTestBase {
    private SSLSocketFactory originalSslSocketFactory;
    private TestWebContainer testWebContainer;

    HttpsAccessIT() {
    }

    @BeforeEach
    void setUp() {
        this.originalSslSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
    }

    @AfterEach
    void tearDown() {
        HttpsURLConnection.setDefaultSSLSocketFactory(this.originalSslSocketFactory);
        this.testWebContainer.shutdown();
    }

    @Test
    void serverShouldSupportSsl() throws Exception {
        this.startServer();
        Assertions.assertThat((int)HTTP.GET((String)this.testWebContainer.httpsUri().get().toString()).status()).isEqualTo(200);
        Assertions.assertThat((int)HTTP.GET((String)this.testWebContainer.getBaseUri().toString()).status()).isEqualTo(200);
    }

    @Test
    void txEndpointShouldReplyWithHttpsWhenItReturnsURLs() throws Exception {
        this.startServer();
        String baseUri = this.testWebContainer.getBaseUri().toString();
        HTTP.Response response = HTTP.POST((String)(baseUri + HttpsAccessIT.txEndpoint()), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements':[]}"));
        Assertions.assertThat((String)response.location()).startsWith((CharSequence)baseUri);
        Assertions.assertThat((String)response.get("commit").asText()).startsWith((CharSequence)baseUri);
    }

    @Test
    void shouldExposeBaseUriWhenHttpEnabledAndHttpsDisabled() throws Exception {
        this.startServer(true, false);
        this.shouldInstallConnector("http");
        this.shouldExposeCorrectSchemeInDiscoveryService("http");
    }

    @Test
    void shouldExposeBaseUriWhenHttpDisabledAndHttpsEnabled() throws Exception {
        this.startServer(false, true);
        this.shouldInstallConnector("https");
        this.shouldExposeCorrectSchemeInDiscoveryService("https");
    }

    @Test
    void shouldIncludeStrictTransportHeaderIfConfigured() throws Exception {
        String transportHeader = "max-age=31536000";
        this.startServer(false, true, transportHeader);
        this.shouldInstallConnector("https");
        HTTP.Response response = HTTP.GET((String)this.testWebContainer.getBaseUri().toString());
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((String)response.header(HttpHeader.STRICT_TRANSPORT_SECURITY.lowerCaseName())).isEqualTo(transportHeader);
    }

    private void shouldInstallConnector(String scheme) {
        URI uri = this.testWebContainer.getBaseUri();
        org.junit.jupiter.api.Assertions.assertEquals((Object)scheme, (Object)uri.getScheme());
        HostnamePort expectedHostPort = PortUtils.getConnectorAddress((GraphDatabaseAPI)this.testWebContainer.getDefaultDatabase(), (String)scheme);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedHostPort.getHost(), (Object)uri.getHost());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedHostPort.getPort(), (int)uri.getPort());
    }

    private void shouldExposeCorrectSchemeInDiscoveryService(String scheme) throws Exception {
        HTTP.Response response = HTTP.GET((String)this.testWebContainer.getBaseUri().toString());
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((String)response.stringFromContent("transaction")).startsWith((CharSequence)(scheme + "://"));
    }

    private void startServer() throws Exception {
        this.startServer(true, true, null);
    }

    private void startServer(boolean httpEnabled, boolean httpsEnabled) throws Exception {
        this.startServer(httpEnabled, httpsEnabled, null);
    }

    private void startServer(boolean httpEnabled, boolean httpsEnabled, String strictTransportHeader) throws Exception {
        CommunityWebContainerBuilder serverBuilder = CommunityWebContainerBuilder.serverOnRandomPorts().usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString());
        if (!httpEnabled) {
            serverBuilder.withHttpDisabled();
        }
        if (httpsEnabled) {
            serverBuilder.withHttpsEnabled();
        }
        if (strictTransportHeader != null) {
            serverBuilder.withProperty(ServerSettings.http_strict_transport_security.name(), strictTransportHeader);
        }
        this.testWebContainer = serverBuilder.build();
        TrustManager[] trustAllCerts = new TrustManager[]{new InsecureTrustManager()};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }
}

