/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web.logging;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;

class HTTPLoggingIT
extends ExclusiveWebContainerTestBase {
    HTTPLoggingIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses() throws Exception {
        String query = "?implicitlyDisabled" + HTTPLoggingIT.randomString();
        TestWebContainer server = this.createWebContainer("false");
        try {
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper(server);
            HttpResponse<Void> response = HTTPLoggingIT.queryBaseUri(query, functionalTestHelper);
            Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
            Assertions.assertThat((boolean)Files.exists(HTTPLoggingIT.httpLogFile(server), new LinkOption[0])).isEqualTo(false);
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess() throws Exception {
        String query = "?explicitlyEnabled=" + HTTPLoggingIT.randomString();
        TestWebContainer server = this.createWebContainer("true");
        try {
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper(server);
            HttpResponse<Void> response = HTTPLoggingIT.queryBaseUri(query, functionalTestHelper);
            Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
            Assert.assertEventually((String)"request appears in log", HTTPLoggingIT.httpLogContent(server), value -> value.contains(query), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void givenExplicitlyEnabledServerLoggingConfigurationShouldLogWithoutQueryString() throws Exception {
        String path = "/foo/bar/baz";
        TestWebContainer server = this.createWebContainer("true");
        try {
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper(server);
            HttpResponse<Void> response = HTTPLoggingIT.queryUri(functionalTestHelper.baseUri().resolve(path));
            Assertions.assertThat((int)response.statusCode()).isEqualTo(404);
            Assert.assertEventually((String)"request appears in log", HTTPLoggingIT.httpLogContent(server), (Condition)new Condition(value -> value.contains(path) && !value.contains("?"), "Contains path without query string.", new Object[0]), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        finally {
            server.shutdown();
        }
    }

    private TestWebContainer createWebContainer(String httpLoggingEnabledValue) throws IOException {
        String directoryPrefix = this.methodName;
        Path logDirectory = this.testDirectory.directory(directoryPrefix + "-logdir");
        return CommunityWebContainerBuilder.serverOnRandomPorts().withDefaultDatabaseTuning().persistent().withProperty(ServerSettings.http_logging_enabled.name(), httpLoggingEnabledValue).withProperty(GraphDatabaseSettings.logs_directory.name(), logDirectory.toAbsolutePath().toString()).withProperty(BoltConnector.listen_address.name(), ":0").usingDataDir(this.testDirectory.directory(directoryPrefix + "-dbdir").toAbsolutePath().toString()).build();
    }

    private static Callable<String> httpLogContent(TestWebContainer testWebContainer) {
        Path httpLogFile = HTTPLoggingIT.httpLogFile(testWebContainer);
        return () -> Files.readString(httpLogFile);
    }

    private static Path httpLogFile(TestWebContainer testWebContainer) {
        Path logDirectory = (Path)testWebContainer.getConfig().get(GraphDatabaseSettings.logs_directory);
        return logDirectory.resolve("http.log");
    }

    private static String randomString() {
        return UUID.randomUUID().toString();
    }

    private static HttpResponse<Void> queryBaseUri(String query, FunctionalTestHelper functionalTestHelper) throws IOException, InterruptedException {
        return HTTPLoggingIT.queryUri(URI.create(String.valueOf(functionalTestHelper.baseUri()) + query));
    }

    private static HttpResponse<Void> queryUri(URI uri) throws IOException, InterruptedException {
        HttpRequest httpRequest = HttpRequest.newBuilder(uri).GET().build();
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
        return httpClient.send(httpRequest, HttpResponse.BodyHandlers.discarding());
    }
}

