/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.util.concurrent.CountDownLatch;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.pagecache.ConfigurableIOBufferFactory;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;

public class MuninnPageCacheFixture
extends PageCacheTestSupport.Fixture<MuninnPageCache> {
    CountDownLatch backgroundFlushLatch;
    private MemoryAllocator allocator;

    @Override
    public MuninnPageCache createPageCache(PageSwapperFactory swapperFactory, int maxPages, PageCacheTracer tracer, JobScheduler jobScheduler, IOBufferFactory bufferFactory) {
        long memory = MuninnPageCache.memoryRequiredForPages((long)maxPages);
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        this.allocator = MemoryAllocator.createAllocator((long)memory, (MemoryTracker)memoryTracker);
        MuninnPageCache.Configuration configuration = MuninnPageCache.config((MemoryAllocator)this.allocator).pageCacheTracer(tracer).bufferFactory(MuninnPageCacheFixture.selectBufferFactory(bufferFactory, memoryTracker));
        return new MuninnPageCache(swapperFactory, jobScheduler, configuration);
    }

    private static IOBufferFactory selectBufferFactory(IOBufferFactory bufferFactory, LocalMemoryTracker memoryTracker) {
        return bufferFactory != null ? bufferFactory : new ConfigurableIOBufferFactory(Config.defaults(), (MemoryTracker)memoryTracker);
    }

    @Override
    public void tearDownPageCache(MuninnPageCache pageCache) {
        if (this.backgroundFlushLatch != null) {
            this.backgroundFlushLatch.countDown();
            this.backgroundFlushLatch = null;
        }
        pageCache.close();
        this.allocator.close();
    }
}

