/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.server.http.cypher.entity.HttpNode;
import org.neo4j.server.http.cypher.format.DefaultJsonFactory;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContent;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContentWriter;

class RestRepresentationWriterIT {
    private JsonGenerator jsonGenerator;
    private ByteArrayOutputStream stream;
    private ResultDataContentWriter contentWriter;

    RestRepresentationWriterIT() {
    }

    @BeforeEach
    void createOutputFormat() throws Exception {
        this.stream = new ByteArrayOutputStream();
        this.jsonGenerator = DefaultJsonFactory.INSTANCE.get().createGenerator((OutputStream)this.stream);
        this.contentWriter = ResultDataContent.rest.writer(new URI("http://localhost/"));
    }

    @Test
    void canFormatNode() throws IOException {
        HttpNode n = new HttpNode(0L);
        RecordEvent recordEvent = new RecordEvent(Collections.singletonList("key"), arg_0 -> RestRepresentationWriterIT.lambda$canFormatNode$0((Node)n, arg_0));
        this.jsonGenerator.writeStartObject();
        this.contentWriter.write(this.jsonGenerator, recordEvent);
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.flush();
        this.jsonGenerator.close();
        Assertions.assertTrue((boolean)this.stream.toString().matches(".*\"self\"\\w*:\\w*\"http://localhost/node/0\",.*"));
    }

    private static /* synthetic */ Object lambda$canFormatNode$0(Node n, String k) {
        return n;
    }
}

