/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.recordstorage.ReadOnlyLogVersionRepository;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class ReadOnlyLogVersionRepositoryIT {
    @Inject
    private PageCache pageCache;
    @Inject
    private DatabaseLayout databaseLayout;

    ReadOnlyLogVersionRepositoryIT() {
    }

    @Test
    void tracePageCacheAccessOnReadOnlyLogRepoConstruction() throws IOException {
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnReadOnlyLogRepoConstruction"));
        new ReadOnlyLogVersionRepository(this.pageCache, this.databaseLayout, cursorContext);
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(2L);
        Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(2L);
        Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(2L);
    }
}

