/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.gqlstatus.SimpleMessageFormat;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
public class SimpleMessageFormatPropertyTest {
    @Inject
    private RandomSupport rand;

    @Test
    void substituteArbitraryStrings() {
        for (int i = 0; i < 100; ++i) {
            List<String> parts = Stream.generate(this::randomStringWithoutSubstitution).limit(this.rand.nextInt(100)).toList();
            String template = String.join((CharSequence)"%s", parts);
            int substitutionCount = Math.max(0, parts.size() - 1);
            SimpleMessageFormat messageFormat = SimpleMessageFormat.compile((String)template);
            this.assertSubstitution(messageFormat, parts, this.randomStrings(substitutionCount));
            this.assertSubstitution(messageFormat, parts, this.randomStrings(substitutionCount));
            this.assertSubstitution(messageFormat, parts, this.randomStrings(this.rand.nextInt(1 + substitutionCount * 2)));
        }
    }

    private void assertSubstitution(SimpleMessageFormat messageFormat, List<String> parts, Object[] substitutions) {
        StringBuilder expectedBuilder = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            expectedBuilder.append(parts.get(i));
            if (i >= parts.size() - 1) continue;
            expectedBuilder.append(i < substitutions.length ? substitutions[i] : "null");
        }
        String expected = expectedBuilder.toString();
        Assertions.assertThat((String)messageFormat.format(substitutions)).isEqualTo(expected);
        String prefix = this.rand.nextString();
        Assertions.assertThat((StringBuilder)messageFormat.format(new StringBuilder(prefix), substitutions)).asString().isEqualTo(prefix + expected);
    }

    private String randomStringWithoutSubstitution() {
        String withoutSubstitution = this.rand.randomValues().nextTextValue(0, 12).stringValue();
        while (withoutSubstitution.contains("%s")) {
            withoutSubstitution = withoutSubstitution.replace("%s", "");
        }
        return withoutSubstitution;
    }

    private Object[] randomStrings(int size) {
        return Stream.generate(() -> this.rand.randomValues().nextTextValue(0, 24).stringValue()).limit(size).toArray();
    }
}

