/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.PropertyValueLookup;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.PopulationWorkJobScheduler;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.IndexIdMapper;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.index.schema.DefaultIndexProvidersAccess;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.token.CreatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@PageCacheExtension
class IndexIdMapperIT {
    private static final int ID_THRESHOLD = 1000;
    private static final LongToObjectFunction<Object> ID_FUNCTION = (LongToObjectFunction & Serializable)id -> id < 1000L ? String.valueOf(id) : String.valueOf(id - 1000L);
    private static final PropertyValueLookup ID_LOOKUP = () -> new PropertyValueLookup.Lookup(){

        public Object lookupProperty(long nodeId, MemoryTracker memoryTracker) {
            return ID_FUNCTION.valueOf(nodeId);
        }

        public void close() {
        }
    };
    @Inject
    private PageCache pageCache;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;
    private final Groups groups = new Groups();
    private final Group globalGroup = this.groups.getOrCreate(null);
    private final Map<String, IndexAccessor> accessors = new HashMap<String, IndexAccessor>();
    private final Map<String, IndexDescriptor> descriptors = new HashMap<String, IndexDescriptor>();
    private final LifeSupport life = new LifeSupport();
    private final ImmutableSet<OpenOption> openOptions = Sets.immutable.of((Object)PageCacheOpenOptions.BIG_ENDIAN);
    private final StorageEngineIndexingBehaviour indexingBehaviour = StorageEngineIndexingBehaviour.EMPTY;
    private JobScheduler jobScheduler;
    private IndexIdMapper idMapper;
    private TokenHolders tokenHolders;
    private IndexProviderMap indexProviders;
    private IndexProviderMap tempIndexProviders;
    private PopulationWorkJobScheduler workScheduler;
    private IndexStatisticsStore indexStatisticsStore;

    IndexIdMapperIT() {
    }

    @BeforeEach
    void init() throws IOException {
        this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        DefaultIndexProvidersAccess indexProvidersAccess = (DefaultIndexProvidersAccess)this.life.add((Lifecycle)new DefaultIndexProvidersAccess(StorageEngineFactory.defaultStorageEngine(), this.fs, Config.defaults(), this.jobScheduler, (LogService)NullLogService.getInstance(), PageCacheTracer.NULL, CursorContextFactory.NULL_CONTEXT_FACTORY));
        DatabaseLayout layout = Neo4jLayout.of((Path)this.directory.homePath()).databaseLayout("db");
        DatabaseLayout tempLayout = Neo4jLayout.of((Path)this.directory.homePath()).databaseLayout("temp");
        this.tokenHolders = new TokenHolders(this.tokenHolder("PropertyKey"), this.tokenHolder("Label"), this.tokenHolder("RelationshipType"));
        this.indexProviders = indexProvidersAccess.access(this.pageCache, layout, DatabaseReadOnlyChecker.writable(), this.tokenHolders);
        this.tempIndexProviders = indexProvidersAccess.access(this.pageCache, tempLayout, DatabaseReadOnlyChecker.writable(), this.tokenHolders);
        this.workScheduler = new PopulationWorkJobScheduler(this.jobScheduler, layout);
        this.fs.mkdirs(layout.databaseDirectory());
        this.indexStatisticsStore = (IndexStatisticsStore)this.life.add((Lifecycle)new IndexStatisticsStore(this.pageCache, this.fs, (DatabaseLayout)RecordDatabaseLayout.convert((DatabaseLayout)layout), RecoveryCleanupWorkCollector.immediate(), false, CursorContextFactory.NULL_CONTEXT_FACTORY, PageCacheTracer.NULL, this.openOptions));
        this.life.start();
    }

    @AfterEach
    void close() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[3];
        autoCloseableArray[0] = this.idMapper;
        autoCloseableArray[1] = () -> ((LifeSupport)this.life).shutdown();
        autoCloseableArray[2] = this.jobScheduler;
        IOUtils.closeAllUnchecked((AutoCloseable[])autoCloseableArray);
    }

    private void start() throws IOException {
        this.idMapper = new IndexIdMapper(this.accessors, this.tempIndexProviders, (TokenNameLookup)this.tokenHolders, this.descriptors, this.workScheduler, this.openOptions, Configuration.DEFAULT, PageCacheTracer.NULL, this.indexStatisticsStore, (ReadableGroups)this.groups, this.indexingBehaviour);
    }

    @Test
    void shouldGetAndPutOnSingleIndex() throws Exception {
        this.buildInitialIndex(this.globalGroup, 1L, 0, 0, this.sequentialNodes(0L, 100));
        this.start();
        this.put(1234567L, this.globalGroup);
        this.prepare(Collector.STRICT);
        this.assertId(0L, this.globalGroup);
        this.assertId(12L, this.globalGroup);
        this.assertId(1234567L, this.globalGroup);
    }

    @Test
    void shouldGetAndPutOnMultipleIndexes() throws Exception {
        Group group1 = this.groups.getOrCreate("one");
        Group group2 = this.groups.getOrCreate("two");
        this.buildInitialIndex(group1, 1L, 0, 0, this.sequentialNodes(0L, 100));
        this.buildInitialIndex(group2, 2L, 1, 1, this.sequentialNodes(100L, 100));
        this.start();
        this.put(1234567L, group1);
        this.put(7654321L, group2);
        this.prepare(Collector.STRICT);
        this.assertId(12L, group1);
        this.assertId(112L, group2);
        this.assertId(1234567L, group1);
        this.assertId(7654321L, group2);
    }

    @Test
    void shouldFindDuplicateNodesInMultipleIndexes() throws Exception {
        Group group1 = this.groups.getOrCreate("one");
        Group group2 = this.groups.getOrCreate("two");
        this.buildInitialIndex(group1, 1L, 0, 0, this.sequentialNodes(0L, 100));
        this.buildInitialIndex(group2, 2L, 1, 1, this.sequentialNodes(100L, 100));
        this.start();
        int duplicateNode1 = 1009;
        int duplicateNode2 = 1123;
        this.put(duplicateNode1, group1);
        this.put(duplicateNode2, group2);
        Collector collector = (Collector)Mockito.mock(Collector.class);
        this.prepare(collector);
        this.assertId(9L, group1);
        this.assertId(123L, group2);
        ((Collector)Mockito.verify((Object)collector)).collectDuplicateNode(ID_FUNCTION.valueOf((long)duplicateNode1), (long)duplicateNode1, group1);
        ((Collector)Mockito.verify((Object)collector)).collectDuplicateNode(ID_FUNCTION.valueOf((long)duplicateNode2), (long)duplicateNode2, group2);
        Assertions.assertThat((Object)this.asLongSet(this.idMapper.leftOverDuplicateNodesIds())).isEqualTo((Object)LongSets.immutable.of(new long[]{duplicateNode1, duplicateNode2}));
    }

    @Test
    void shouldFindNodesThatAreDuplicatesInTheIncrement() throws IOException, IndexEntryConflictException {
        Group group = this.groups.getOrCreate("group");
        this.buildInitialIndex(group, 1L, 0, 1, this.sequentialNodes(0L, 100));
        this.start();
        this.idMapper.put((Object)"110", 101L, group);
        this.idMapper.put((Object)"110", 102L, group);
        Collector collector = (Collector)Mockito.mock(Collector.class);
        this.prepare(collector);
        ((Collector)Mockito.verify((Object)collector)).collectDuplicateNode((Object)"110", 102L, group);
    }

    @Test
    void shouldStoreIncrementalIndexStatistics() throws Exception {
        long indexId = 1L;
        this.buildInitialIndex(this.globalGroup, indexId, 0, 0, this.sequentialNodes(0L, 100));
        this.start();
        int count = 10;
        for (int i = 0; i < count; ++i) {
            this.put(1234567 + i, this.globalGroup);
        }
        this.prepare(Collector.STRICT);
        IndexSample indexSample = this.indexStatisticsStore.indexSample(indexId);
        Assertions.assertThat((long)indexSample.indexSize()).isEqualTo((long)count);
        Assertions.assertThat((long)indexSample.sampleSize()).isEqualTo((long)count);
        Assertions.assertThat((long)indexSample.uniqueValues()).isEqualTo((long)count);
    }

    private LongSet asLongSet(LongIterator ids) {
        MutableLongSet set = LongSets.mutable.empty();
        while (ids.hasNext()) {
            set.add(ids.next());
        }
        return set;
    }

    private void prepare(Collector collector) {
        this.idMapper.completeBuild(collector, Runnable::run);
        this.idMapper.validate(collector);
        this.idMapper.prepare(ID_LOOKUP, collector, ProgressMonitorFactory.NONE);
    }

    private void put(long nodeId, Group group) {
        this.idMapper.put(ID_FUNCTION.valueOf(nodeId), nodeId, group);
    }

    private void assertId(long nodeId, Group group) {
        try (IdMapper.Getter getter = this.idMapper.newGetter();){
            Assertions.assertThat((long)getter.get(ID_FUNCTION.valueOf(nodeId), group)).isEqualTo(nodeId);
        }
    }

    private Map<Object, Long> sequentialNodes(long startId, int count) {
        HashMap<Object, Long> data = new HashMap<Object, Long>();
        for (int i = 0; i < count; ++i) {
            long entityId = startId + (long)i;
            data.put(ID_FUNCTION.valueOf(entityId), entityId);
        }
        return data;
    }

    private void buildInitialIndex(Group group, long indexId, int labelId, int propertyKeyId, Map<Object, Long> data) throws IOException, IndexEntryConflictException {
        IndexProvider indexProvider = this.indexProviders.getDefaultProvider();
        IndexDescriptor descriptor = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyKeyId})).withName(group.descriptiveName()).withIndexProvider(indexProvider.getProviderDescriptor()).materialise(indexId);
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        IndexAccessor accessor = indexProvider.getOnlineAccessor(descriptor, indexSamplingConfig, (TokenNameLookup)this.tokenHolders, this.openOptions, this.indexingBehaviour);
        try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL_CONTEXT, false);){
            for (Map.Entry<Object, Long> dataEntry : data.entrySet()) {
                updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)dataEntry.getValue(), (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)dataEntry.getKey())}));
            }
        }
        accessor.force(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        this.accessors.put(group.name(), accessor);
        this.descriptors.put(group.name(), descriptor);
    }

    private TokenHolder tokenHolder(String typePropertyKey) {
        CreatingTokenHolder tokenHolder = new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, typePropertyKey);
        ArrayList<NamedToken> initialTokens = new ArrayList<NamedToken>();
        for (int i = 0; i < 10; ++i) {
            initialTokens.add(new NamedToken("Token" + i, i));
        }
        tokenHolder.setInitialTokens(initialTokens);
        return tokenHolder;
    }
}

